/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.project.AbstractProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.osgi.util.NLS;

public class LocalProjectScanner
extends AbstractProjectScanner<MavenProjectInfo> {
    private final File workspaceRoot;
    private final List<String> folders;
    private final boolean basedirRemameRequired;
    private final Set<File> scannedFolders = new HashSet<File>();
    private final MavenModelManager modelManager;

    public LocalProjectScanner(File workspaceRoot, String folder, boolean needsRename, MavenModelManager modelManager) {
        this(workspaceRoot, Collections.singletonList(folder), needsRename, modelManager);
    }

    public LocalProjectScanner(File workspaceRoot, List<String> folders, boolean basedirRemameRequired, MavenModelManager modelManager) {
        this.workspaceRoot = workspaceRoot;
        this.folders = folders;
        this.basedirRemameRequired = basedirRemameRequired;
        this.modelManager = modelManager;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LocalProjectScanner_task_scanning, (int)1);
        subMonitor.beginTask(Messages.LocalProjectScanner_task_scanning, -1);
        try {
            for (String folderName : this.folders) {
                try {
                    File folder = new File(folderName).getCanonicalFile();
                    this.scanFolder(folder, "", (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, -1));
                }
                catch (IOException ex) {
                    this.addError(ex);
                }
            }
        }
        finally {
            subMonitor.done();
        }
    }

    private void scanFolder(File baseDir, String rootRelPath, IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        monitor.subTask(baseDir.toString());
        monitor.worked(1);
        if (!baseDir.exists() || !baseDir.isDirectory() || ".metadata".equals(baseDir.getName())) {
            return;
        }
        try {
            if (this.scannedFolders.contains(baseDir.getCanonicalFile())) {
                return;
            }
        }
        catch (IOException ex1) {
            this.addError(ex1);
            return;
        }
        MavenProjectInfo projectInfo = this.readMavenProjectInfo(baseDir, rootRelPath, null);
        if (projectInfo != null) {
            this.addProject(projectInfo);
            return;
        }
        File[] files = baseDir.listFiles();
        if (files == null) {
            this.addError(new Exception(NLS.bind((String)Messages.LocalProjectScanner_accessDeniedFromFolder, (Object)baseDir.getAbsolutePath())));
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            try {
                File file = file2.getCanonicalFile();
                if (file.isDirectory()) {
                    this.scanFolder(file, String.valueOf(rootRelPath) + "/" + file.getName(), monitor);
                }
            }
            catch (IOException ex) {
                this.addError(ex);
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private MavenProjectInfo readMavenProjectInfo(File baseDir, String modulePath, MavenProjectInfo parentInfo) {
        File pomFile;
        block23: {
            block22: {
                baseDir = baseDir.getCanonicalFile();
                if (this.scannedFolders.add(baseDir)) break block22;
                return null;
            }
            pomFile = new File(baseDir, "pom.xml");
            if (pomFile.exists()) break block23;
            return null;
        }
        try {
            Model model = null;
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream pomStream = Files.newInputStream(pomFile.toPath(), new OpenOption[0]);){
                model = this.modelManager.readMavenModel(pomStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String pomName = String.valueOf(modulePath) + "/" + "pom.xml";
            if (model.getArtifactId() == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", NLS.bind((String)Messages.LocalProjectScanner_missingArtifactId, (Object)pomName)));
            }
            MavenProjectInfo projectInfo = this.newMavenProjectInfo(pomName, pomFile, model, parentInfo);
            if (parentInfo == null) {
                projectInfo.setBasedirRename(this.getBasedirRename(projectInfo));
            }
            LinkedHashMap modules = new LinkedHashMap();
            for (String string : model.getModules()) {
                void var9_13;
                if (string.endsWith("/pom.xml")) {
                    String string2 = string.substring(0, string.length() - "/pom.xml".length());
                }
                modules.put(var9_13, new HashSet());
            }
            for (Profile profile : model.getProfiles()) {
                for (String module : profile.getModules()) {
                    HashSet<String> profiles;
                    if (module.endsWith("/pom.xml")) {
                        module = module.substring(0, module.length() - "/pom.xml".length());
                    }
                    if ((profiles = (HashSet<String>)modules.get(module)) == null) {
                        profiles = new HashSet<String>();
                        modules.put(module, profiles);
                    }
                    profiles.add(profile.getId());
                }
            }
            for (Map.Entry entry : modules.entrySet()) {
                String module;
                module = (String)entry.getKey();
                Set profiles = (Set)entry.getValue();
                File moduleBaseDir = new File(baseDir, module);
                MavenProjectInfo moduleInfo = this.readMavenProjectInfo(moduleBaseDir, module, projectInfo);
                if (moduleInfo == null) continue;
                moduleInfo.addProfiles(profiles);
                projectInfo.add(moduleInfo);
            }
            return projectInfo;
        }
        catch (IOException | CoreException ex) {
            this.addError(ex);
            return null;
        }
    }

    protected MavenProjectInfo newMavenProjectInfo(String label, File pomFile, Model model, MavenProjectInfo parent) {
        return new MavenProjectInfo(label, pomFile, model, parent);
    }

    @Override
    public String getDescription() {
        return this.folders.toString();
    }

    private int getBasedirRename(MavenProjectInfo mavenProjectInfo) {
        if (this.basedirRemameRequired) {
            return 2;
        }
        return 0;
    }
}

