/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.editor;

import java.io.ByteArrayInputStream;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClipboardParser {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private Exception error;
    private String scope;

    public ClipboardParser(String text) {
        if (text != null && text.trim().startsWith("<")) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream input = new ByteArrayInputStream(text.getBytes("UTF-8"));
                Document doc = builder.parse(input);
                this.groupId = this.getTextFor("groupId", doc);
                this.artifactId = this.getTextFor("artifactId", doc);
                this.version = this.getTextFor("version", doc);
                this.classifier = this.getTextFor("classifier", doc);
                this.scope = this.getTextFor("scope", doc);
            }
            catch (Exception e) {
                this.error = e;
            }
        }
    }

    private String getTextFor(String element, Document doc) {
        NodeList nl = doc.getElementsByTagName(element);
        Node item = nl.item(0);
        if (item != null) {
            return item.getTextContent();
        }
        return null;
    }

    public Exception getError() {
        return this.error;
    }

    public String getScope() {
        return Objects.requireNonNullElse(this.scope, "");
    }

    public String getGroupId() {
        return Objects.requireNonNullElse(this.groupId, "");
    }

    public String getArtifactId() {
        return Objects.requireNonNullElse(this.artifactId, "");
    }

    public String getVersion() {
        return Objects.requireNonNullElse(this.version, "");
    }

    public String getClassifier() {
        return Objects.requireNonNullElse(this.classifier, "");
    }
}

