/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.version.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.m2e.pde.CacheManager;
import org.eclipse.m2e.pde.MissingMetadataMode;
import org.eclipse.pde.core.target.TargetBundle;

public class MavenTargetBundle
extends TargetBundle {
    private TargetBundle bundle;
    private IStatus status;
    private final BundleInfo bundleInfo;
    private boolean isWrapped;
    private Artifact artifact;

    public BundleInfo getBundleInfo() {
        if (this.bundle == null) {
            return this.bundleInfo;
        }
        return this.bundle.getBundleInfo();
    }

    public boolean isSourceBundle() {
        if (this.bundle == null) {
            return false;
        }
        return this.bundle.isSourceBundle();
    }

    public BundleInfo getSourceTarget() {
        if (this.bundle == null) {
            return null;
        }
        return this.bundle.getSourceTarget();
    }

    public boolean isFragment() {
        if (this.bundle == null) {
            return false;
        }
        return this.bundle.isFragment();
    }

    public String getSourcePath() {
        if (this.bundle == null) {
            return null;
        }
        return this.bundle.getSourcePath();
    }

    public MavenTargetBundle(Artifact artifact, Properties bndInstructions, CacheManager cacheManager, MissingMetadataMode metadataMode) {
        this.artifact = artifact;
        File file = artifact.getFile();
        this.bundleInfo = new BundleInfo(String.valueOf(artifact.getGroupId()) + "." + artifact.getArtifactId(), artifact.getVersion(), file != null ? file.toURI() : null, -1, false);
        try {
            this.bundle = new TargetBundle(file);
        }
        catch (Exception ex) {
            if (metadataMode == MissingMetadataMode.ERROR) {
                this.status = new Status(4, MavenTargetBundle.class.getPackage().getName(), artifact + " is not a bundle", (Throwable)ex);
            }
            if (metadataMode == MissingMetadataMode.GENERATE) {
                try {
                    this.bundle = cacheManager.accessArtifactFile(artifact, artifactFile -> MavenTargetBundle.getWrappedArtifact(artifact, bndInstructions, artifactFile));
                    this.isWrapped = true;
                }
                catch (Exception e) {
                    String message = artifact + " is not a bundle and cannot be automatically bundled as such ";
                    if (e.getMessage() != null) {
                        message = String.valueOf(message) + " (" + e.getMessage() + ")";
                    }
                    this.status = new Status(4, MavenTargetBundle.class.getPackage().getName(), message, (Throwable)e);
                }
            }
            this.status = Status.CANCEL_STATUS;
        }
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public static TargetBundle getWrappedArtifact(Artifact artifact, Properties bndInstructions, File wrappedFile) throws Exception {
        File artifactFile = artifact.getFile();
        File instructionsFile = new File(wrappedFile.getParentFile(), String.valueOf(FilenameUtils.getBaseName((String)wrappedFile.getName())) + ".xml");
        if (CacheManager.isOutdated(wrappedFile, artifactFile) || MavenTargetBundle.propertiesChanged(bndInstructions, instructionsFile)) {
            Throwable throwable = null;
            Throwable throwable2 = null;
            try (Jar jar = new Jar(artifactFile);){
                Manifest originalManifest = jar.getManifest();
                Throwable throwable3 = null;
                Object var10_15 = null;
                try (Analyzer analyzer = new Analyzer();){
                    analyzer.setJar(jar);
                    if (originalManifest != null) {
                        analyzer.mergeManifest(originalManifest);
                    }
                    analyzer.setProperty("mvnGroupId", artifact.getGroupId());
                    analyzer.setProperty("mvnArtifactId", artifact.getArtifactId());
                    analyzer.setProperty("mvnVersion", artifact.getBaseVersion());
                    analyzer.setProperty("mvnClassifier", artifact.getClassifier());
                    analyzer.setProperty("generatedOSGiVersion", MavenTargetBundle.createBundleVersion(artifact).toString());
                    analyzer.setProperties(bndInstructions);
                    jar.setManifest(analyzer.calcManifest());
                    jar.write(wrappedFile);
                    wrappedFile.setLastModified(artifactFile.lastModified());
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
            TargetBundle targetBundle = new TargetBundle(wrappedFile);
            throwable2 = null;
            Object var7_10 = null;
            try (FileOutputStream os = new FileOutputStream(instructionsFile);){
                bndInstructions.storeToXML(os, null);
            }
            catch (Throwable throwable6) {
                if (throwable2 == null) {
                    throwable2 = throwable6;
                } else if (throwable2 != throwable6) {
                    throwable2.addSuppressed(throwable6);
                }
                throw throwable2;
            }
            return targetBundle;
        }
        try {
            return new TargetBundle(wrappedFile);
        }
        catch (Exception exception) {
            FileUtils.forceDelete((File)wrappedFile);
            return MavenTargetBundle.getWrappedArtifact(artifact, bndInstructions, wrappedFile);
        }
    }

    private static boolean propertiesChanged(Properties properties, File file) {
        Properties oldProperties = new Properties();
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (FileInputStream stream = new FileInputStream(file);){
                    oldProperties.loadFromXML(stream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return properties.equals(properties);
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static Version createBundleVersion(Artifact artifact) {
        String version = artifact.getVersion();
        if (version == null || version.isEmpty()) {
            return new Version(0, 0, 1);
        }
        try {
            int index = version.indexOf(45);
            if (index > -1) {
                StringBuilder sb = new StringBuilder(version);
                sb.setCharAt(index, '.');
                return Version.parseVersion((String)sb.toString());
            }
            return Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new Version(0, 0, 1, version);
        }
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public IStatus getStatus() {
        if (this.bundle == null) {
            if (this.status == null) {
                return Status.OK_STATUS;
            }
            return this.status;
        }
        return this.bundle.getStatus();
    }

    public int hashCode() {
        return this.getBundleInfo().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MavenTargetBundle) {
            MavenTargetBundle other = (MavenTargetBundle)((Object)obj);
            return this.getBundleInfo().equals((Object)other.getBundleInfo());
        }
        return false;
    }
}

