/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.NewProjectData;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.ProjectIntegration;
import org.eclipse.swt.widgets.Combo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ProjectIntegrationHelper {
    private static final ProjectIntegration projectIntegration = ProjectIntegrationHelper.getProjectIntegration();

    private static ProjectIntegration getProjectIntegration() {
        try {
            BundleContext bundleContext = QVTUIPlugin.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(ProjectIntegration.class.getName());
            return serviceReference == null ? null : (ProjectIntegration)bundleContext.getService(serviceReference);
        }
        catch (Throwable e) {
            QVTUIPlugin.log(e);
            return null;
        }
    }

    static boolean isProjectIntegration() {
        return projectIntegration != null;
    }

    static void setupProject(IProject project, NewProjectData data, IProgressMonitor monitor) throws CoreException {
        if (projectIntegration != null) {
            projectIntegration.setupProject(project, data, monitor);
        }
    }

    static String getRequiredExecutionEnv(String executionEnv) {
        if (projectIntegration != null) {
            return projectIntegration.getRequiredExecutionEnv(executionEnv);
        }
        return null;
    }

    static String getClassField(String id, String suffix) {
        if (projectIntegration != null) {
            return projectIntegration.getClassField(id, suffix);
        }
        return "";
    }

    static IStatus validateJavaTypeName(String name) {
        if (projectIntegration != null) {
            return projectIntegration.validateJavaTypeName(name);
        }
        return Status.OK_STATUS;
    }

    static void fillExecutionEnvironments(Combo combo) {
        if (projectIntegration != null) {
            projectIntegration.fillExecutionEnvironments(combo);
        }
    }
}

