/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.internal.collectionextract.HashMapCollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class HashSetCollectionExtractor
implements IMapExtractor {
    private final String array_attribute;
    private final String key_attribute;
    private final String size_attribute;
    private final String value_attribute;

    public HashSetCollectionExtractor(String array_attribute, String key_attribute) {
        this(null, array_attribute, key_attribute, null);
    }

    public HashSetCollectionExtractor(String size_attribute, String array_attribute, String key_attribute, String value_attribute) {
        if (array_attribute == null) {
            throw new IllegalArgumentException();
        }
        if (key_attribute == null) {
            throw new IllegalArgumentException();
        }
        this.size_attribute = size_attribute;
        this.array_attribute = array_attribute;
        this.key_attribute = key_attribute;
        this.value_attribute = value_attribute;
    }

    @Override
    public boolean hasSize() {
        return true;
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        if (this.size_attribute != null) {
            return ExtractionUtils.toInteger(coll.resolveValue(this.size_attribute));
        }
        return this.getNumberOfNotNullElements(coll);
    }

    @Override
    public boolean hasCapacity() {
        return true;
    }

    @Override
    public Integer getCapacity(IObject coll) throws SnapshotException {
        return this.createHashMapExtractor().getCapacity(coll);
    }

    @Override
    public boolean hasFillRatio() {
        return this.createHashMapExtractor().hasFillRatio();
    }

    @Override
    public Double getFillRatio(IObject coll) throws SnapshotException {
        return this.createHashMapExtractor().getFillRatio(coll);
    }

    @Override
    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    @Override
    public boolean hasExtractableArray() {
        return false;
    }

    @Override
    public boolean hasExtractableContents() {
        return true;
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        ISnapshot snapshot = coll.getSnapshot();
        ArrayInt ret = new ArrayInt();
        int[] entries = this.createHashMapExtractor().extractEntryIds(coll);
        if (this.key_attribute.endsWith("[]")) {
            String attr = this.key_attribute.replaceFirst("\\[\\]$", "");
            int[] nArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                int entryId = nArray[n2];
                IInstance entry = (IInstance)snapshot.getObject(entryId);
                Object f = entry.resolveValue(attr);
                if (f instanceof IObjectArray) {
                    IObjectArray valarr = (IObjectArray)f;
                    int n3 = valarr.getLength();
                    int s = 10;
                    int i = 0;
                    while (i < n3) {
                        s = Math.min(s, n3 - i);
                        long[] b = valarr.getReferenceArray(i, s);
                        int j = 0;
                        while (j < s) {
                            if (b[j] != 0L) {
                                int valueId = snapshot.mapAddressToId(b[j]);
                                ret.add(valueId);
                            }
                            ++j;
                        }
                        i += s;
                    }
                }
                ++n2;
            }
        } else {
            int[] nArray = entries;
            int n = entries.length;
            int n4 = 0;
            while (n4 < n) {
                int entryId = nArray[n4];
                IInstance entry = (IInstance)snapshot.getObject(entryId);
                Object f = entry.resolveValue(this.key_attribute);
                if (f instanceof IObject) {
                    ret.add(((IObject)f).getObjectId());
                }
                ++n4;
            }
        }
        return ret.toArray();
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject coll) throws SnapshotException {
        return this.createHashMapExtractor().getNumberOfNotNullElements(coll);
    }

    IMapExtractor createHashMapExtractor() {
        return new HashMapCollectionExtractor(this.size_attribute, this.array_attribute, this.key_attribute, this.value_attribute);
    }

    @Override
    public boolean hasCollisionRatio() {
        return this.createHashMapExtractor().hasCollisionRatio();
    }

    @Override
    public Double getCollisionRatio(IObject coll) throws SnapshotException {
        return this.createHashMapExtractor().getCollisionRatio(coll);
    }

    @Override
    public Iterator<Map.Entry<IObject, IObject>> extractMapEntries(IObject coll) throws SnapshotException {
        return this.createHashMapExtractor().extractMapEntries(coll);
    }
}

