/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class MATCollectionExtractor
implements ICollectionExtractor {
    String sizeField;
    String capacityField;

    public MATCollectionExtractor(String sizeField, String capacityField) {
        this.sizeField = sizeField;
        this.capacityField = capacityField;
    }

    @Override
    public boolean hasSize() {
        return this.sizeField != null;
    }

    @Override
    public Integer getSize(IObject collection) throws SnapshotException {
        return (Integer)collection.resolveValue(this.sizeField);
    }

    @Override
    public boolean hasCapacity() {
        return this.capacityField != null;
    }

    @Override
    public Integer getCapacity(IObject collection) throws SnapshotException {
        return (Integer)collection.resolveValue(this.sizeField);
    }

    @Override
    public boolean hasFillRatio() {
        return this.hasSize() && this.hasCapacity();
    }

    @Override
    public Double getFillRatio(IObject coll) throws SnapshotException {
        Integer size = this.getSize(coll);
        Integer cap = this.getCapacity(coll);
        if (size != null && cap != null) {
            double sz = size.doubleValue();
            double cp = cap.doubleValue();
            if (sz == 0.0 && cp == 0.0) {
                return 1.0;
            }
            return sz / cp;
        }
        return 1.0;
    }

    @Override
    public boolean hasExtractableContents() {
        return false;
    }

    @Override
    public int[] extractEntryIds(IObject collection) throws SnapshotException {
        return null;
    }

    @Override
    public boolean hasExtractableArray() {
        return false;
    }

    @Override
    public IObjectArray extractEntries(IObject collection) throws SnapshotException {
        return null;
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject collection) throws SnapshotException {
        return this.getSize(collection);
    }
}

