/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot;

import java.util.regex.Pattern;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.util.MessageUtil;

public final class OQL {
    private static final String OQL_classesByClassLoaderId = "SELECT * FROM java.lang.Class c WHERE c implements " + IClass.class.getName() + " and c.@classLoaderId = {0,number,0}";

    public static final String forAddress(long address) {
        return "SELECT * FROM OBJECTS 0x" + Long.toHexString(address);
    }

    public static final String forObjectId(int objectId) {
        return "SELECT * FROM OBJECTS " + objectId;
    }

    public static String forObjectIds(int[] objectIds) {
        if (objectIds.length == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("SELECT * FROM OBJECTS ");
        int ii = 0;
        while (ii < objectIds.length) {
            if (ii > 0) {
                buf.append(",");
            }
            buf.append(objectIds[ii]);
            ++ii;
        }
        return buf.toString();
    }

    public static final String retainedBy(String oqlQuery) {
        return "SELECT AS RETAINED SET * FROM OBJECTS (" + oqlQuery + ")";
    }

    public static String retainedBy(int objectId) {
        return "SELECT AS RETAINED SET * FROM OBJECTS " + objectId;
    }

    public static final String forObjectsOfClass(IClass clasz) {
        return "SELECT * FROM " + clasz.getName();
    }

    public static final String forObjectsOfClass(int classId) {
        return "SELECT * FROM " + classId;
    }

    private static CharSequence lastId(CharSequence query, int end) {
        int j = end - 1;
        while (j >= 0 && Character.isJavaIdentifierPart(query.charAt(j))) {
            --j;
        }
        if (j < end - 1 && Character.isJavaIdentifierStart(query.charAt(j + 1)) && OQL.isSpace(query, j)) {
            return query.subSequence(j, end);
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private static CharSequence matchObjs(CharSequence s, int e) {
        i = e - 1;
        while (OQL.isSpace(s, i)) {
            --i;
        }
        if (!OQL.isHexDigit(s, i)) {
            return "";
        }
        p = i;
        while (true) {
            if (OQL.isHexDigit(s, i)) ** GOTO lbl12
            return s.subSequence(i + 1, e);
lbl-1000:
            // 1 sources

            {
                --i;
lbl12:
                // 2 sources

                ** while (OQL.isDigit((CharSequence)s, (int)i))
            }
lbl13:
            // 1 sources

            if (!OQL.isHexDigit(s, i)) ** GOTO lbl21
            while (OQL.isHexDigit(s, i)) {
                --i;
            }
            if (OQL.isHexStart2(s, i) && OQL.isHexStart1(s, i - 1)) {
                i -= 2;
            } else {
                return s.subSequence(p + 1, e);
lbl21:
                // 1 sources

                if (OQL.isHexStart2(s, i) && OQL.isHexStart1(s, i - 1)) {
                    i -= 2;
                }
            }
            if (i < 0 || s.charAt(i) == ',' || s.charAt(i) == ' ') ** GOTO lbl26
            return s.subSequence(p + 1, e);
lbl-1000:
            // 1 sources

            {
                --i;
lbl26:
                // 2 sources

                ** while (OQL.isSpace((CharSequence)s, (int)i))
            }
lbl27:
            // 1 sources

            if (i < 0 || s.charAt(i) != ',') {
                return s.subSequence(i + 1, e);
            }
            --i;
            while (OQL.isSpace(s, i)) {
                --i;
            }
            p = i;
        }
    }

    private static boolean isDigit(CharSequence s, int i) {
        char c;
        return i >= 0 && i < s.length() && (c = s.charAt(i)) >= '0' && c <= '9';
    }

    private static boolean isHexDigit(CharSequence s, int i) {
        char c;
        return i >= 0 && i < s.length() && (c = s.charAt(i)) >= '0' && (c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F');
    }

    private static boolean isHexStart2(CharSequence s, int i) {
        char c;
        return i >= 0 && i < s.length() && ((c = s.charAt(i)) == 'x' || c == 'X');
    }

    private static boolean isHexStart1(CharSequence s, int i) {
        return i >= 0 && i < s.length() && s.charAt(i) == '0';
    }

    private static boolean isSpace(CharSequence s, int i) {
        char c;
        return i >= 0 && i < s.length() && ((c = s.charAt(i)) == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f');
    }

    public static void union(StringBuilder query, String other) {
        if (query.length() > 0) {
            int end = query.length();
            while (query.charAt(end - 1) == ')') {
                int start = query.lastIndexOf(" UNION (", end - 1);
                if (start == -1) break;
                if (OQL.union(query, start + 8, end - 1, other)) {
                    return;
                }
                if (start < 1) break;
                end = start;
            }
            if (OQL.union(query, 0, end, other)) {
                return;
            }
            query.append(" UNION (").append(other).append(")");
        } else {
            query.append(other);
        }
    }

    private static boolean union(StringBuilder query, int start, int end, String other) {
        CharSequence id2;
        CharSequence id1 = OQL.lastId(query, end);
        if (id1.equals(id2 = OQL.lastId(other, other.length()))) {
            CharSequence num1 = OQL.matchObjs(query, end - id1.length());
            CharSequence num2 = OQL.matchObjs(other, other.length() - id2.length());
            int s1 = end - id1.length() - num1.length();
            int s2 = other.length() - id2.length() - num2.length();
            if (num1.length() > 0 && num2.length() > 0 && query.subSequence(start, s1).equals(other.subSequence(0, s2))) {
                int j = 0;
                while (OQL.isSpace(num2, j)) {
                    ++j;
                }
                query.insert(s1 + num1.length(), "," + num2.subSequence(j, num2.length()));
                return true;
            }
        }
        return false;
    }

    public static String instancesByPattern(Pattern pattern, boolean includeSubclasses) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("SELECT * FROM \"");
        if (includeSubclasses) {
            buf.append(" INSTANCEOF");
        }
        buf.append(pattern.pattern());
        buf.append("\"");
        return buf.toString();
    }

    public static String classesByPattern(Pattern pattern, boolean includeSubclasses) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("SELECT * FROM OBJECTS \"");
        if (includeSubclasses) {
            buf.append(" INSTANCEOF");
        }
        buf.append(pattern.pattern());
        buf.append("\"");
        return buf.toString();
    }

    public static String instancesByClassLoaderId(int classLoaderId) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("SELECT * FROM (");
        buf.append(OQL.classesByClassLoaderId(classLoaderId));
        buf.append(")");
        return buf.toString();
    }

    public static String classesByClassLoaderId(int classLoaderId) {
        return MessageUtil.format((String)OQL_classesByClassLoaderId, (Object[])new Object[]{classLoaderId});
    }

    private OQL() {
    }
}

