/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.core.internal;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.modisco.facet.efacet.core.IFacetActions;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.modisco.facet.util.core.internal.Activator;
import org.eclipse.modisco.facet.util.emf.core.ICatalogSetManager2;
import org.eclipse.modisco.facet.util.emf.core.ICatalogSetManagerFactory;
import org.eclipse.modisco.facet.util.emf.core.exception.InvalidFacetSetException;
import org.eclipse.modisco.facet.util.pde.core.internal.exported.BuildPropertiesUtils;

public class FacetActionsImpl
implements IFacetActions {
    public void saveFacetSet(FacetSet facetSet, IFile file) throws IOException, InvalidFacetSetException {
        if (facetSet == null) {
            throw new IllegalArgumentException("The given FacetSet cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("The given IFile cannot be null");
        }
        if (file.exists()) {
            throw new IllegalArgumentException("The given IFile already exists");
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)facetSet);
        resource.save(null);
        try {
            BuildPropertiesUtils.addToBuild((IFile)file);
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (String)("Error adding file " + file.getFullPath() + " to the build.properties"), (Plugin)Activator.getDefault());
        }
        ICatalogSetManager2 catalogSetManager = ICatalogSetManagerFactory.DEFAULT.createICatalogSetManager((ResourceSet)resourceSet);
        catalogSetManager.registerModelDeclaration(file);
    }
}

