/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.util;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.asciidoc.internal.AsciiDocContentState;
import org.eclipse.mylyn.wikitext.parser.TableCellAttributes;

public class LanguageSupport {
    private static final Pattern COLUMN_FORMATTING_SPLITTER = Pattern.compile("([0-9]+)\\*(.*)");
    private static final Pattern ALIGN_PATTERN = Pattern.compile("((?:\\.)?)([<^>])");
    private static Pattern keyValuePattern = Pattern.compile("(.*)=\"(.*)\"");

    public static Map<String, String> parseFormattingProperties(String rawFormat, List<String> positionalParameters) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (rawFormat == null || rawFormat.trim().length() == 0) {
            return properties;
        }
        Iterable valpairs = Splitter.on((Pattern)Pattern.compile(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)")).split((CharSequence)rawFormat);
        for (String pair : valpairs) {
            Matcher matcher = keyValuePattern.matcher(pair.trim());
            if (matcher.find()) {
                String key = matcher.group(1);
                String value = matcher.group(2);
                properties.put(key, value);
                continue;
            }
            if (positionalParameters.isEmpty()) continue;
            properties.put(positionalParameters.remove(0), pair.trim());
        }
        return properties;
    }

    public static List<TableCellAttributes> computeColumnsAttributeList(String cols) {
        if (cols != null) {
            ArrayList<TableCellAttributes> result = new ArrayList<TableCellAttributes>();
            for (String c : cols.split(",")) {
                Matcher matcher = COLUMN_FORMATTING_SPLITTER.matcher(c);
                if (matcher.matches()) {
                    int repeat = Integer.parseInt(matcher.group(1));
                    for (int i = 0; i < repeat; ++i) {
                        result.add(LanguageSupport.convertToTableCellAttributes(matcher.group(2)));
                    }
                    continue;
                }
                result.add(LanguageSupport.convertToTableCellAttributes(c));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static TableCellAttributes convertToTableCellAttributes(String columnFormat) {
        TableCellAttributes result = new TableCellAttributes();
        Matcher alignMatcher = ALIGN_PATTERN.matcher(columnFormat);
        int start = 0;
        while (alignMatcher.find(start)) {
            String align = alignMatcher.group(2);
            if (".".equals(alignMatcher.group(1))) {
                if ("<".equals(align)) {
                    result.setValign("top");
                } else if ("^".equals(align)) {
                    result.setValign("middle");
                } else if (">".equals(align)) {
                    result.setValign("bottom");
                }
            } else if ("<".equals(align)) {
                result.setAlign("left");
            } else if ("^".equals(align)) {
                result.setAlign("center");
            } else if (">".equals(align)) {
                result.setAlign("right");
            }
            start = alignMatcher.end();
        }
        return result;
    }

    public static List<TableCellAttributes> createDefaultColumnsAttributeList(int size) {
        ArrayList<TableCellAttributes> result = new ArrayList<TableCellAttributes>();
        for (int i = 0; i < size; ++i) {
            result.add(new TableCellAttributes());
        }
        return result;
    }

    public static int computeHeadingLevel(int initialLevel, AsciiDocContentState state) {
        int levelOffset;
        String attributeValue = state.getAttributeOrValue("leveloffset", "0");
        try {
            levelOffset = Integer.parseInt(attributeValue);
        }
        catch (NumberFormatException e) {
            return initialLevel;
        }
        return Math.max(1, Math.min(initialLevel + levelOffset, 6));
    }
}

