/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.html;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.mylyn.wikitext.html.HtmlLanguage;
import org.eclipse.mylyn.wikitext.html.internal.FontElementStrategy;
import org.eclipse.mylyn.wikitext.html.internal.HtmlSubsetLanguage;
import org.eclipse.mylyn.wikitext.html.internal.LiteralHtmlDocumentHandler;
import org.eclipse.mylyn.wikitext.html.internal.SpanHtmlElementStrategy;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class HtmlLanguageBuilder {
    private String name;
    private final Set<DocumentBuilder.BlockType> blockTypes = Sets.newHashSet();
    private final Set<DocumentBuilder.SpanType> spanTypes = Sets.newHashSet();
    private final Map<DocumentBuilder.SpanType, String> spanTypeToElementNameSubstitution = Maps.newHashMap();
    private final List<SpanHtmlElementStrategy> spanElementStrategies = new ArrayList<SpanHtmlElementStrategy>();
    private int headingLevel;
    private LiteralHtmlDocumentHandler documentHandler;
    private boolean xhtmlStrict;
    private boolean supportsImages = true;

    HtmlLanguageBuilder() {
    }

    public HtmlLanguageBuilder name(String name) {
        Objects.requireNonNull(name, "Must provide a name");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name must not be empty");
        Preconditions.checkArgument((!name.equalsIgnoreCase("HTML") ? 1 : 0) != 0, (String)"Name must not be equal to %s", (Object)"HTML");
        Preconditions.checkArgument((boolean)name.equals(name.trim()), (Object)"Name must not have leading or trailing whitespace");
        this.name = name;
        return this;
    }

    public HtmlLanguageBuilder add(DocumentBuilder.BlockType blockType) {
        this.blockTypes.add(Objects.requireNonNull(blockType, "Must provide a blockType"));
        return this;
    }

    public HtmlLanguageBuilder add(DocumentBuilder.SpanType spanType) {
        this.spanTypes.add(Objects.requireNonNull(spanType, "Must provide a spanType"));
        return this;
    }

    public HtmlLanguageBuilder addSubstitution(DocumentBuilder.SpanType spanType, String alternativeTagName) {
        Objects.requireNonNull(spanType, "Must provide a spanType");
        Objects.requireNonNull(alternativeTagName, "Must provide an alternativeTagName");
        this.spanTypeToElementNameSubstitution.put(spanType, alternativeTagName);
        return this;
    }

    public HtmlLanguageBuilder addHeadings(int level) {
        Preconditions.checkArgument((level > 0 && level <= 6 ? 1 : 0) != 0, (Object)"Heading level must be between 1 and 6");
        this.headingLevel = level;
        return this;
    }

    public HtmlLanguageBuilder addSpanFont() {
        this.spanElementStrategies.add(new FontElementStrategy());
        return this;
    }

    public HtmlLanguageBuilder setXhtmlStrict(boolean xhtmlStrict) {
        this.xhtmlStrict = xhtmlStrict;
        return this;
    }

    public HtmlLanguageBuilder document(String prefix, String suffix) {
        Objects.requireNonNull(prefix, "Must provide a prefix");
        Objects.requireNonNull(suffix, "Must provide a suffix");
        this.documentHandler = new LiteralHtmlDocumentHandler(prefix, suffix);
        return this;
    }

    public HtmlLanguageBuilder setSupportsImages(boolean supportsImages) {
        this.supportsImages = supportsImages;
        return this;
    }

    public HtmlLanguage create() {
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"Name must be provided to create an HtmlLanguage");
        return new HtmlSubsetLanguage(this.name, this.documentHandler, this.headingLevel, this.blockTypes, this.spanTypes, this.spanTypeToElementNameSubstitution, this.spanElementStrategies, this.xhtmlStrict, this.supportsImages);
    }
}

