/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.commands;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.wikitext.ui.commands.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.util.IOUtil;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.commands.AbstractMarkupResourceHandler;
import org.eclipse.mylyn.wikitext.util.ServiceLocator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConvertMarkupToMarkup
extends AbstractMarkupResourceHandler {
    static final String PARAM_MARKUP_LANGUAGE = "org.eclipse.mylyn.wikitext.ui.targetLanguage";
    static final String COMMAND_ID = "org.eclipse.mylyn.wikitext.ui.convertToMarkupCommand";

    @Override
    protected void handleFile(ExecutionEvent event, IFile file, String name) throws ExecutionException {
        MarkupLanguage targetMmarkupLanguage = ServiceLocator.getInstance().getMarkupLanguage(event.getParameter(PARAM_MARKUP_LANGUAGE));
        String extension = targetMmarkupLanguage.getName().toLowerCase().replaceAll("\\W", "");
        IFile newFile = file.getParent().getFile((IPath)new Path(String.valueOf(name) + "." + extension));
        if (newFile.exists() && !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)NLS.bind((String)Messages.ConvertMarkupToMarkup_overwrite_file, (Object)targetMmarkupLanguage.getName()), (String)NLS.bind((String)Messages.ConvertMarkupToMarkup_overwrite_file_detail, (Object[])new Object[]{newFile.getFullPath()}))) {
            return;
        }
        StringWriter writer = new StringWriter();
        MarkupParser parser = new MarkupParser();
        parser.setMarkupLanguage(this.markupLanguage);
        parser.setBuilder(targetMmarkupLanguage.createDocumentBuilder((Writer)writer));
        try {
            String inputContent = IOUtil.readFully(file);
            parser.parse(inputContent);
            String targetConent = writer.toString();
            IRunnableWithProgress runnable = monitor -> {
                try {
                    if (newFile.exists()) {
                        newFile.setContents((InputStream)new ByteArrayInputStream(targetConent.getBytes(StandardCharsets.UTF_8)), false, true, monitor);
                    } else {
                        newFile.create((InputStream)new ByteArrayInputStream(targetConent.getBytes(StandardCharsets.UTF_8)), false, monitor);
                    }
                    newFile.setCharset("utf-8", monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            StringWriter message = new StringWriter();
            PrintWriter out = new PrintWriter(message);
            out.println(NLS.bind((String)Messages.ConvertMarkupToMarkup_cannot_generate_detail, (Object)targetMmarkupLanguage.getName(), (Object)e.getMessage()));
            out.println(Messages.ConvertMarkupToMarkup_details_follow);
            e.printStackTrace(out);
            out.close();
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)NLS.bind((String)Messages.ConvertMarkupToMarkup_cannot_generate_title, (Object)targetMmarkupLanguage.getName()), (String)message.toString());
        }
    }

    @Override
    protected void handleFile(IFile file, String name) throws ExecutionException {
        throw new UnsupportedOperationException();
    }
}

