/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UIUtil {
    public static final IWorkbench WORKBENCH;
    private static final int COLOR_TRANSPARENT;
    private static Image errorImage;
    private static Image warningImage;
    private static Image infoImage;
    private static Boolean browserAvailable;

    static {
        IWorkbench workbench = null;
        int colorTransparent = -1;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            colorTransparent = (Integer)ReflectUtil.getValue((String)"COLOR_TRANSPARENT", SWT.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        WORKBENCH = workbench;
        COLOR_TRANSPARENT = colorTransparent;
    }

    private UIUtil() {
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            try {
                display = PlatformUI.getWorkbench().getDisplay();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (display == null) {
            display = new Display();
        }
        return display;
    }

    public static Shell getShell() {
        final Shell[] shell = new Shell[1];
        final Display display = UIUtil.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                Shell[] shells;
                shell[0] = display.getActiveShell();
                if (shell[0] == null) {
                    try {
                        IWorkbenchWindow[] windows;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length != 0) {
                            window = windows[0];
                        }
                        if (window != null) {
                            shell[0] = window.getShell();
                        }
                    }
                    catch (Throwable window) {
                        // empty catch block
                    }
                }
                if (shell[0] == null && (shells = display.getShells()).length > 0) {
                    shell[0] = shells[0];
                }
            }
        });
        return shell[0];
    }

    public static synchronized boolean isBrowserAvailable() {
        if (browserAvailable == null) {
            UIUtil.syncExec(new Runnable(){

                public void run() {
                    Shell shell = null;
                    try {
                        try {
                            shell = new Shell();
                            new Browser((Composite)shell, 0);
                            browserAvailable = true;
                        }
                        catch (SWTError ex) {
                            browserAvailable = false;
                            try {
                                shell.dispose();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    finally {
                        try {
                            shell.dispose();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
        return browserAvailable;
    }

    public static boolean isParent(Composite parent, Control controlToCheck) {
        if (parent == null || controlToCheck == null) {
            throw new IllegalArgumentException("Neither parent nor controlToCheck must be null");
        }
        if (controlToCheck == parent) {
            return true;
        }
        Composite tmpParent = controlToCheck.getParent();
        while (tmpParent != parent && tmpParent != null) {
            tmpParent = tmpParent.getParent();
        }
        return tmpParent == parent;
    }

    public static GridLayout createGridLayout(int numColumns) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public static GridData applyGridData(Control control) {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        control.setLayoutData((Object)data);
        return data;
    }

    public static GridData grabVertical(GridData data) {
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        return data;
    }

    public static void clearTextSelection(Object control) {
        Text text = UIUtil.findTextControl(control);
        if (text != null) {
            text.clearSelection();
        }
    }

    public static void setSelectionToEnd(Widget control) {
        Text text = UIUtil.findTextControl(control);
        if (text != null) {
            String content = text.getText();
            text.setSelection(content.length() + 1);
        }
    }

    public static void setSelectionTo(Widget control, Point selection) {
        Text text = UIUtil.findTextControl(control);
        if (text != null) {
            text.setSelection(selection);
        }
    }

    public static void selectAllText(Widget control) {
        Text text = UIUtil.findTextControl(control);
        if (text != null) {
            text.selectAll();
        }
    }

    private static Text findTextControl(Object control) {
        if (control instanceof Viewer) {
            control = ((Viewer)control).getControl();
        }
        if (control instanceof CCombo) {
            CCombo combo = (CCombo)control;
            try {
                control = ReflectUtil.getValue((String)"text", (Object)combo);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (control instanceof Text) {
            return (Text)control;
        }
        return null;
    }

    public static void runInProgressDialog(Shell shell, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        block3: {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell){

                protected Point getInitialSize() {
                    Point calculatedSize = super.getInitialSize();
                    if (calculatedSize.x < 800) {
                        calculatedSize.x = 800;
                    }
                    return calculatedSize;
                }
            };
            try {
                dialog.run(true, true, runnable);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() instanceof OperationCanceledException) break block3;
                throw ex;
            }
        }
    }

    public static void handleException(Throwable ex) {
        UIPlugin.INSTANCE.log(ex);
        ErrorDialog.open(ex);
    }

    public static Color getEclipseThemeColor() {
        return UIPlugin.getColor(44, 34, 85);
    }

    public static Image[] extractSprites(Image textureAtlas, int countX, int countY) {
        Rectangle atlasBounds = textureAtlas.getBounds();
        int width = atlasBounds.width / countX;
        int height = atlasBounds.height / countY;
        Image[] sprites = new Image[countX * countY];
        int y = 0;
        while (y < countY) {
            int x = 0;
            while (x < countX) {
                sprites[countX * y + x] = UIUtil.extractSprite(textureAtlas, x * width, y * width, width, height);
                ++x;
            }
            ++y;
        }
        return sprites;
    }

    public static Image extractSprite(Image textureAtlas, int x, int y, int width, int height) {
        ImageData textureAtlasData = textureAtlas.getImageData();
        PaletteData textureAtlasPaletteData = textureAtlasData.palette;
        ImageData spriteImageData = new ImageData(width, height, textureAtlasData.depth, new PaletteData(textureAtlasPaletteData.redMask, textureAtlasPaletteData.greenMask, textureAtlasPaletteData.blueMask));
        int[] pixels = new int[width * height];
        byte[] alphas = new byte[width * height];
        int scanline = 0;
        while (scanline < height) {
            int yOffset = y + scanline;
            textureAtlasData.getPixels(x, yOffset, width, pixels, scanline * width);
            textureAtlasData.getAlphas(x, yOffset, width, alphas, scanline * width);
            ++scanline;
        }
        spriteImageData.setPixels(0, 0, pixels.length, pixels, 0);
        spriteImageData.setAlphas(0, 0, alphas.length, alphas, 0);
        return new Image((Device)UIUtil.getDisplay(), spriteImageData);
    }

    public static Image getStatusImage(int severity) {
        if (severity == 4) {
            if (errorImage == null) {
                errorImage = UIPlugin.INSTANCE.getSWTImage("error");
            }
            return errorImage;
        }
        if (severity == 2) {
            if (warningImage == null) {
                warningImage = UIPlugin.INSTANCE.getSWTImage("warning");
            }
            return warningImage;
        }
        if (infoImage == null) {
            infoImage = UIPlugin.INSTANCE.getSWTImage("info");
        }
        return infoImage;
    }

    public static void exec(Display display, boolean async, Runnable runnable) {
        if (async) {
            UIUtil.asyncExec(display, runnable);
        } else {
            UIUtil.syncExec(display, runnable);
        }
    }

    public static void asyncExec(Runnable runnable) {
        Display display = UIUtil.getDisplay();
        if (display != null) {
            UIUtil.asyncExec(display, runnable);
        }
    }

    public static void asyncExec(final Control control, final Runnable runnable) {
        block3: {
            try {
                if (control.isDisposed()) {
                    return;
                }
                control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!control.isDisposed()) {
                            runnable.run();
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 24) break block3;
                throw ex;
            }
        }
    }

    public static void asyncExec(final Display display, final Runnable runnable) {
        block3: {
            try {
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(){

                    public void run() {
                        block3: {
                            if (display.isDisposed()) {
                                return;
                            }
                            try {
                                runnable.run();
                            }
                            catch (SWTException ex) {
                                if (ex.code == 24) break block3;
                                throw ex;
                            }
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 24) break block3;
                throw ex;
            }
        }
    }

    public static void syncExec(Runnable runnable) {
        Display display = UIUtil.getDisplay();
        if (Display.getCurrent() == display || display == null) {
            runnable.run();
        } else {
            UIUtil.syncExec(display, runnable);
        }
    }

    public static void syncExec(final Control control, final Runnable runnable) {
        block3: {
            try {
                if (control.isDisposed()) {
                    return;
                }
                control.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (!control.isDisposed()) {
                            runnable.run();
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 24) break block3;
                throw ex;
            }
        }
    }

    public static void syncExec(final Display display, final Runnable runnable) {
        block3: {
            try {
                if (display.isDisposed()) {
                    return;
                }
                display.syncExec(new Runnable(){

                    public void run() {
                        block3: {
                            if (display.isDisposed()) {
                                return;
                            }
                            try {
                                runnable.run();
                            }
                            catch (SWTException ex) {
                                if (ex.code == 24) break block3;
                                throw ex;
                            }
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 24) break block3;
                throw ex;
            }
        }
    }

    public static void timerExec(int milliseconds, Runnable runnable) {
        Display display = UIUtil.getDisplay();
        if (display != null) {
            UIUtil.timerExec(milliseconds, display, runnable);
        }
    }

    public static void timerExec(int milliseconds, final Display display, final Runnable runnable) {
        block3: {
            try {
                if (display.isDisposed()) {
                    return;
                }
                display.timerExec(milliseconds, new Runnable(){

                    public void run() {
                        block3: {
                            if (display.isDisposed()) {
                                return;
                            }
                            try {
                                runnable.run();
                            }
                            catch (SWTException ex) {
                                if (ex.code == 24) break block3;
                                throw ex;
                            }
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 24) break block3;
                throw ex;
            }
        }
    }

    public static IDialogSettings getOrCreateSection(IDialogSettings settings, String sectionName) {
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    public static void dispose(Resource ... resources) {
        int i = 0;
        while (i < resources.length) {
            Resource resource = resources[i];
            if (resource != null && !resource.isDisposed()) {
                resource.dispose();
            }
            ++i;
        }
    }

    public static void simulateKey(char character) {
        Display display = UIUtil.getDisplay();
        Event event = new Event();
        event.type = 1;
        event.character = character;
        display.post(event);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        event.type = 2;
        display.post(event);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String stripHTML(String html) {
        try {
            final StringBuilder builder = new StringBuilder();
            new ParserDelegator().parse(new StringReader(html), new HTMLEditorKit.ParserCallback(){

                public void handleText(char[] text, int pos) {
                    builder.append(text);
                }

                public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                    if (t.breaksFlow()) {
                        builder.append("\n");
                    }
                }
            }, Boolean.TRUE);
            return builder.toString();
        }
        catch (LinkageError ex) {
            return html;
        }
        catch (IOException ex) {
            return html;
        }
    }

    public static String getRenderableHTML(String html) {
        return UIUtil.stripHTMLFull(html, true);
    }

    private static String stripHTMLFull(String html, final boolean renderable) {
        try {
            final StringBuilder result = new StringBuilder();
            new ParserDelegator().parse(new StringReader(html), new HTMLEditorKit.ParserCallback(){
                private StringBuilder builder;
                private List<List<StringBuilder>> table;
                private List<StringBuilder> row;
                {
                    this.builder = stringBuilder;
                }

                public void handleText(char[] text, int pos) {
                    if (renderable) {
                        this.builder.append(DiagnosticDecorator.escapeContent((String)new String(text)));
                    } else {
                        this.builder.append(text);
                    }
                }

                public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                    if ("img".equals(t.toString())) {
                        this.builder.append("      ");
                    } else if (t.breaksFlow()) {
                        if (renderable && this.builder == result) {
                            this.builder.append("<br/>");
                        }
                        this.builder.append("\n");
                    }
                }

                public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                    String tagName = t.toString();
                    if ("table".equals(tagName)) {
                        this.table = new ArrayList<List<StringBuilder>>();
                    } else if ("tr".equals(tagName)) {
                        this.row = new ArrayList<StringBuilder>();
                        this.table.add(this.row);
                    } else if ("td".equals(tagName)) {
                        this.builder = new StringBuilder();
                        this.row.add(this.builder);
                    } else if (tagName.startsWith("h") && tagName.length() > 1 && Character.isDigit(tagName.charAt(1))) {
                        this.appendLineFeed(true);
                        this.appendLineFeed(false);
                        if (renderable) {
                            this.builder.append("<b>");
                        }
                    } else if (t.breaksFlow()) {
                        this.appendLineFeed(true);
                    }
                }

                public void handleEndTag(HTML.Tag t, int pos) {
                    String tagName = t.toString();
                    if ("table".equals(tagName)) {
                        int n;
                        int[] widths = null;
                        String[][][] tableEntries = new String[this.table.size()][][];
                        this.builder = result;
                        int rowIndex = 0;
                        for (List<StringBuilder> list : this.table) {
                            if (widths == null) {
                                widths = new int[list.size()];
                            }
                            String[][] tableRow = new String[list.size()][];
                            tableEntries[rowIndex] = tableRow;
                            int columnIndex = 0;
                            for (StringBuilder stringBuilder : list) {
                                String value = StringUtil.trimRight((String)stringBuilder.toString());
                                String[] lines = value.split("\n");
                                tableRow[columnIndex] = lines;
                                String[] stringArray = lines;
                                int n2 = lines.length;
                                n = 0;
                                while (n < n2) {
                                    String line = stringArray[n];
                                    widths[columnIndex] = Math.max(widths[columnIndex], line.length());
                                    ++n;
                                }
                                ++columnIndex;
                            }
                            ++rowIndex;
                        }
                        if (renderable) {
                            this.builder.append("<pre>");
                        }
                        String[][][] stringArrayArray = tableEntries;
                        int n3 = tableEntries.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int columnIndex;
                            int i;
                            int n5;
                            String[][] stringArray = stringArrayArray[n4];
                            boolean bl = false;
                            String[][] stringArray2 = stringArray;
                            int lines = stringArray.length;
                            int value = 0;
                            while (value < lines) {
                                String[] column = stringArray2[value];
                                n5 = Math.max(n5, column.length);
                                ++value;
                            }
                            if (renderable) {
                                i = 0;
                                while (i < n5) {
                                    columnIndex = 0;
                                    String[][] stringArray3 = stringArray;
                                    n = stringArray.length;
                                    int n6 = 0;
                                    while (n6 < n) {
                                        String[] column = stringArray3[n6];
                                        String columnText = i < column.length ? column[i] : "";
                                        int columnWidth = widths[columnIndex];
                                        this.append(columnText, columnWidth);
                                        ++columnIndex;
                                        ++n6;
                                    }
                                    this.builder.append("\n");
                                    ++i;
                                }
                            } else {
                                this.appendLineFeed(true);
                                i = 0;
                                while (i < n5) {
                                    this.builder.append("|  ");
                                    columnIndex = 0;
                                    String[][] stringArray4 = stringArray;
                                    n = stringArray.length;
                                    int n7 = 0;
                                    while (n7 < n) {
                                        String[] column = stringArray4[n7];
                                        this.append(i < column.length ? column[i] : "", widths[columnIndex]);
                                        this.builder.append(columnIndex == stringArray.length - 1 ? "  |" : "  |  ");
                                        ++columnIndex;
                                        ++n7;
                                    }
                                    this.appendLineFeed(false);
                                    ++i;
                                }
                            }
                            ++n4;
                        }
                        if (renderable) {
                            this.builder.append("</pre>");
                        }
                        this.table = null;
                    } else if (!"tr".equals(tagName) && !"td".equals(tagName)) {
                        if (tagName.startsWith("h") && tagName.length() > 1 && Character.isDigit(tagName.charAt(1))) {
                            if (renderable) {
                                this.builder.append("</b>");
                                this.appendLineFeed(true);
                            }
                        } else if (t.breaksFlow()) {
                            this.appendLineFeed(true);
                        }
                    }
                }

                private void append(String value, int width) {
                    this.builder.append(value);
                    int i = value.length();
                    while (i < width) {
                        this.builder.append(' ');
                        ++i;
                    }
                }

                private void appendLineFeed(boolean conditional) {
                    int length;
                    if (conditional && ((length = this.builder.length()) == 0 || this.builder.charAt(length - 1) == '\n')) {
                        return;
                    }
                    if (renderable) {
                        this.builder.append("<br/>");
                    }
                    this.builder.append('\n');
                }
            }, Boolean.TRUE);
            return result.toString();
        }
        catch (LinkageError ex) {
            return html;
        }
        catch (IOException ex) {
            return html;
        }
    }

    public static Point caclcuateSize(String html) {
        FontRegistry fontRegistry;
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        Font font = fontRegistry.get((fontRegistry = JFaceResources.getFontRegistry()).hasValueFor("org.eclipse.jdt.ui.javadocfont") ? "org.eclipse.jdt.ui.javadocfont" : "org.eclipse.jface.dialogfont");
        Font fixedPitchFont = JFaceResources.getTextFont();
        gc.setFont(font);
        FontMetrics fontMetrics = gc.getFontMetrics();
        int averageCharWidth = fontMetrics.getAverageCharWidth();
        Font boldFont = ExtendedFontRegistry.INSTANCE.getFont(font, (Object)IItemFontProvider.BOLD_FONT);
        gc.setFont(boldFont);
        boolean browerAvailable = UIUtil.isBrowserAvailable();
        String text = UIUtil.stripHTMLFull(html, false).trim();
        String[] lines = text.split("\n");
        int pixelWidth = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            boolean isTableRow = line.startsWith("|");
            if (!browerAvailable && isTableRow) {
                gc.setFont(fixedPitchFont);
            }
            int lineWidth = gc.textExtent((String)line).x;
            if (browerAvailable && isTableRow) {
                lineWidth += 4 * averageCharWidth;
            }
            pixelWidth = Math.max(pixelWidth, lineWidth);
            gc.setFont(font);
            ++n2;
        }
        int numberOfAverageCharacters = pixelWidth / averageCharWidth + 2;
        gc.dispose();
        shell.dispose();
        return new Point(numberOfAverageCharacters, lines.length);
    }

    public static void setTransparentBackgroundColor(Control control) {
        if (COLOR_TRANSPARENT != -1) {
            Color transparentColor = control.getDisplay().getSystemColor(COLOR_TRANSPARENT);
            control.setBackground(transparentColor);
        }
    }

    public static <T> T getService(IServiceLocator serviceLocator, Class<T> api) {
        return api.cast(serviceLocator.getService(api));
    }

    public static abstract class DelayedRunnable
    implements Runnable {
        private final Control control;
        private int delay;
        private boolean dispatched;
        private boolean redispatch;

        public DelayedRunnable(Control control, int milliseconds) {
            this.control = control;
            this.delay = milliseconds;
        }

        protected abstract void perform();

        protected void prepareForDispatch() {
        }

        public void run() {
            if (!this.control.isDisposed()) {
                this.dispatched = false;
                if (this.redispatch) {
                    this.schedule();
                } else {
                    this.perform();
                }
            }
        }

        public void schedule() {
            if (this.dispatched) {
                this.redispatch = true;
            } else {
                this.prepareForDispatch();
                this.dispatched = true;
                this.redispatch = false;
                UIUtil.timerExec(this.delay, this);
            }
        }
    }
}

