/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.oomph.version.Markers;
import org.eclipse.oomph.version.ui.quickfixes.AbstractResolution;
import org.eclipse.oomph.version.ui.quickfixes.AddNatureResolution;
import org.eclipse.oomph.version.ui.quickfixes.ConfigureResolution;
import org.eclipse.oomph.version.ui.quickfixes.IgnoreRootProjectsResolution;
import org.eclipse.oomph.version.ui.quickfixes.Messages;
import org.eclipse.oomph.version.ui.quickfixes.PropertiesResolution;
import org.eclipse.oomph.version.ui.quickfixes.ReleasePathResolution;
import org.eclipse.oomph.version.ui.quickfixes.ReplaceResolution;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class VersionResolutionGenerator
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        String nature;
        String option;
        ArrayList<AbstractResolution> resolutions = new ArrayList<AbstractResolution>();
        String problemType = Markers.getProblemType((IMarker)marker);
        String regEx = Markers.getQuickFixPattern((IMarker)marker);
        if (regEx != null) {
            String replacement = Markers.getQuickFixReplacement((IMarker)marker);
            resolutions.add(new ReplaceResolution(marker, problemType, replacement));
            final String alternativeReplacement = Markers.getQuickFixAlternativeReplacement((IMarker)marker);
            if (alternativeReplacement != null) {
                resolutions.add(new ReplaceResolution(marker, problemType, alternativeReplacement){

                    public String getLabel() {
                        return Messages.VersionResolutionGenerator_changeToOmniVersion;
                    }

                    public String getDescription() {
                        return NLS.bind((String)Messages.VersionResolutionGenerator_changeVersionTo, (Object)alternativeReplacement);
                    }

                    protected String getQuickFixReplacement(IMarker marker) {
                        return Markers.getQuickFixAlternativeReplacement((IMarker)marker);
                    }
                });
            }
        }
        if ("unreferenced.element".equals(problemType)) {
            resolutions.add(new PropertiesResolution.RootProjects(marker));
            resolutions.add(new IgnoreRootProjectsResolution(marker));
        } else if ("release.path".equals(problemType)) {
            resolutions.add(new ReleasePathResolution(marker));
        }
        String ignoreReference = Markers.getQuickFixReference((IMarker)marker);
        if (ignoreReference != null) {
            resolutions.add(new PropertiesResolution.IgnoredReferences(marker));
        }
        if ((option = Markers.getQuickFixConfigureOption((IMarker)marker)) != null) {
            resolutions.add(new ConfigureResolution(marker, option));
        }
        if ((nature = Markers.getQuickFixNature((IMarker)marker)) != null) {
            resolutions.add(new AddNatureResolution(marker, nature));
        }
        return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
    }

    public boolean hasResolutions(IMarker marker) {
        if (Markers.getQuickFixPattern((IMarker)marker) != null) {
            return true;
        }
        if (Markers.getQuickFixConfigureOption((IMarker)marker) != null) {
            return true;
        }
        if (Markers.getQuickFixReference((IMarker)marker) != null) {
            return true;
        }
        if (Markers.getQuickFixNature((IMarker)marker) != null) {
            return true;
        }
        String problemType = Markers.getProblemType((IMarker)marker);
        if ("unreferenced.element".equals(problemType)) {
            return true;
        }
        return "release.path".equals(problemType);
    }
}

