/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.licenses.model.toberemoved;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.internal.api.EvaluationInstructions;
import org.eclipse.passage.lic.internal.api.EvaluationType;
import org.eclipse.passage.lic.internal.api.conditions.Condition;
import org.eclipse.passage.lic.internal.api.conditions.IssuerSignature;
import org.eclipse.passage.lic.internal.api.conditions.ValidityPeriod;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.internal.base.conditions.BaseCondition;
import org.eclipse.passage.lic.internal.base.conditions.BaseEvaluationInstructions;
import org.eclipse.passage.lic.internal.base.conditions.BaseValidityPeriodClosed;
import org.eclipse.passage.lic.internal.licenses.convert.PIssuerSignature;
import org.eclipse.passage.lic.internal.licenses.convert.PVersionMatch;
import org.eclipse.passage.lic.internal.licenses.model.migration.LicensesResourceHandler;
import org.eclipse.passage.lic.licenses.ValidityPeriodClosedDescriptor;
import org.eclipse.passage.lic.licenses.model.api.PersonalFeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;
import org.eclipse.passage.lic.licenses.model.util.LicensesResourceImpl;

abstract class BaseXmiConditionTransport
implements ConditionTransport {
    private final ContentType type = new ContentType.Xml();
    private final Predicate<PersonalLicensePack> filter;

    protected BaseXmiConditionTransport() {
        this(p -> true);
    }

    protected BaseXmiConditionTransport(Predicate<PersonalLicensePack> filter) {
        this.filter = filter;
    }

    public ContentType id() {
        return this.type;
    }

    public ConditionTransport.Data read(InputStream input) throws IOException {
        LicensesResourceImpl resource = new LicensesResourceImpl();
        resource.load(input, this.loadOptions());
        Optional<PersonalLicensePack> license = resource.getContents().stream().filter(PersonalLicensePack.class::isInstance).map(PersonalLicensePack.class::cast).filter(this.filter).findAny();
        if (!license.isPresent()) {
            return new ConditionTransport.Data();
        }
        return new ConditionTransport.Data(this.conditions(license.get()), this.signature(license.get()));
    }

    private Optional<IssuerSignature> signature(PersonalLicensePack pack) {
        if (pack.getLicense().getSignature() == null) {
            return Optional.empty();
        }
        return Optional.of(new PIssuerSignature(pack.getLicense().getSignature()).get());
    }

    private Collection<Condition> conditions(PersonalLicensePack license) {
        return license.getGrants().stream().map(this::condition).collect(Collectors.toList());
    }

    private Map<String, Object> loadOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("http://www.eclipse.org/passage/lic/licenses/2.0.0", LicensesPackage.eINSTANCE);
        options.put("licenses", LicensesPackage.eINSTANCE);
        options.put("RESOURCE_HANDLER", (Object)new LicensesResourceHandler());
        return options;
    }

    private Condition condition(PersonalFeatureGrant grant) {
        return new BaseCondition(grant.getIdentifier(), grant.getFeature().getIdentifier(), new PVersionMatch(grant.getFeature().getVersionMatch()).get(), (ValidityPeriod)new BaseValidityPeriodClosed(this.fromDate(((ValidityPeriodClosedDescriptor)grant.getValid()).getFrom()), this.fromDate(((ValidityPeriodClosedDescriptor)grant.getValid()).getUntil())), (EvaluationInstructions)new BaseEvaluationInstructions((EvaluationType)new EvaluationType.Of(grant.getUserAuthentication().getType()), grant.getUserAuthentication().getExpression()));
    }

    private ZonedDateTime fromDate(Date date) {
        if (date == null) {
            return ZonedDateTime.now().minusMinutes(1L);
        }
        return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }
}

