/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.parts.CheckboxTreePart;
import org.eclipse.pde.internal.ui.shared.CachedCheckboxTreeViewer;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class WizardCheckboxTreePart
extends CheckboxTreePart {
    private int selectAllIndex = -1;
    private int deselectAllIndex = -1;
    private int selectIndex = -1;
    private int deselectIndex = -1;
    private String tableName;
    private Label counterLabel;

    public WizardCheckboxTreePart(String tableName, String[] buttonLabels) {
        super(buttonLabels);
        this.tableName = tableName;
    }

    public WizardCheckboxTreePart(String mainLabel) {
        this(mainLabel, new String[]{PDEUIMessages.WizardCheckboxTablePart_selectAll, PDEUIMessages.WizardCheckboxTablePart_deselectAll, PDEUIMessages.WizardCheckboxTablePart_select, PDEUIMessages.WizardCheckboxTablePart_deselect});
        this.setSelectAllIndex(0);
        this.setDeselectAllIndex(1);
        this.setSelectIndex(2);
        this.setDeselectIndex(3);
    }

    public void setSelectAllIndex(int index) {
        this.selectAllIndex = index;
    }

    public void setDeselectAllIndex(int index) {
        this.deselectAllIndex = index;
    }

    public void setSelectIndex(int index) {
        this.selectIndex = index;
    }

    public void setDeselectIndex(int index) {
        this.deselectIndex = index;
    }

    @Override
    protected void buttonSelected(Button button, int index) {
        if (index == this.selectAllIndex) {
            this.handleSelectAll(true);
        }
        if (index == this.deselectAllIndex) {
            this.handleSelectAll(false);
        }
        if (index == this.selectIndex) {
            this.handleSelect(true);
        }
        if (index == this.deselectIndex) {
            this.handleSelect(false);
        }
    }

    public Object[] getSelection() {
        CachedCheckboxTreeViewer viewer = this.getTreeViewer();
        return viewer.getCheckedElements();
    }

    public void setSelection(Object[] selected) {
        CachedCheckboxTreeViewer viewer = this.getTreeViewer();
        viewer.setCheckedElements(selected);
        this.updateCounterLabel();
    }

    public void createControl(Composite parent) {
        this.createControl(parent, 2);
    }

    public void createControl(Composite parent, int span) {
        this.createControl(parent, 0, span, null);
        this.counterLabel = new Label(parent, 0);
        GridData gd = new GridData(258);
        gd.horizontalSpan = span;
        this.counterLabel.setLayoutData((Object)gd);
        this.updateCounterLabel();
    }

    public void createControl(Composite parent, int span, boolean multiselect) {
        if (multiselect) {
            this.createControl(parent, 2, span, null);
        } else {
            this.createControl(parent, 0, span, null);
        }
        this.counterLabel = new Label(parent, 0);
        GridData gd = new GridData(258);
        gd.horizontalSpan = span;
        this.counterLabel.setLayoutData((Object)gd);
        this.updateCounterLabel();
    }

    @Override
    protected Button createButton(Composite parent, String label, int index, FormToolkit toolkit) {
        Button button = super.createButton(parent, label, index, toolkit);
        SWTUtil.setButtonDimensionHint(button);
        return button;
    }

    @Override
    protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
        StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
        viewer.setComparator(ListUtil.NAME_COMPARATOR);
        return viewer;
    }

    @Override
    protected void createMainLabel(Composite parent, int span, FormToolkit toolkit) {
        if (this.tableName == null) {
            return;
        }
        Label label = new Label(parent, 0);
        label.setText(this.tableName);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
    }

    public void updateCounterLabel() {
        String number = "" + this.getSelectionCount();
        String totalNumber = "" + this.getTotalCount();
        String message = NLS.bind((String)PDEUIMessages.WizardCheckboxTablePart_counter, (Object[])new String[]{number, totalNumber});
        this.counterLabel.setText(message);
    }

    public int getSelectionCount() {
        CachedCheckboxTreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return 0;
        }
        return viewer.getCheckedLeafCount();
    }

    public void selectAll(boolean select) {
        this.handleSelectAll(select);
    }

    private int getTotalCount() {
        CachedCheckboxTreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return 0;
        }
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        if (contentProvider == null) {
            return 0;
        }
        return contentProvider.getElements(viewer.getInput()).length;
    }

    protected void handleSelectAll(boolean select) {
        CachedCheckboxTreeViewer viewer = this.getTreeViewer();
        viewer.setAllChecked(select);
        this.updateCounterLabel();
    }

    protected void handleSelect(boolean select) {
        CachedCheckboxTreeViewer viewer = this.getTreeViewer();
        if (viewer.getTree().getSelection().length > 0) {
            TreeItem[] selected;
            TreeItem[] treeItemArray = selected = viewer.getTree().getSelection();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem selectedItem = treeItemArray[n2];
                viewer.setChecked(selectedItem.getData(), select);
                ++n2;
            }
            this.updateCounterLabel();
        }
    }

    @Override
    protected void elementChecked(Object element, boolean checked) {
        this.updateCounterLabel();
    }

    public Label getCounterLabel() {
        return this.counterLabel;
    }
}

