/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

class PositionInFile {
    private int line = -1;
    private int startCol = -1;
    private int startOffset = -1;
    private int endCol = -1;
    private int endOffset = -1;

    public PositionInFile(int ln, int stCl, int endCl, int stOfst, int endOfst) {
        this.line = ln;
        this.startCol = stCl;
        this.endCol = endCl;
        this.startOffset = stOfst;
        this.endOffset = endOfst;
    }

    public PositionInFile(int ln, int cl, int ofst, boolean isStart) {
        this.line = ln;
        if (isStart) {
            this.startCol = cl;
            this.startOffset = ofst;
        } else {
            this.endCol = cl;
            this.endOffset = ofst;
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndCol() {
        return this.startCol;
    }

    public int getEndOffset() {
        return this.startOffset;
    }

    public boolean isSameStart(PositionInFile other) {
        return other.line == this.line && other.startCol == this.startCol && other.startOffset == this.startOffset;
    }

    public boolean isSameEnd(PositionInFile other) {
        return other.line == this.line && other.endCol == this.endCol && other.endOffset == this.endOffset;
    }

    public int hashCode() {
        return this.endOffset;
    }

    public boolean equals(Object obj) {
        return ((PositionInFile)obj).endOffset == this.endOffset;
    }
}

