/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIChangedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDestroyedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIVariableManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIArgument;
import org.eclipse.ptp.debug.core.pdi.model.IPDIArgumentDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIGlobalVariable;
import org.eclipse.ptp.debug.core.pdi.model.IPDIGlobalVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDILocalVariable;
import org.eclipse.ptp.debug.core.pdi.model.IPDILocalVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIRegister;
import org.eclipse.ptp.debug.core.pdi.model.IPDIRegisterDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrame;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThreadStorage;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThreadStorageDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.request.IPDIListArgumentsRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIListLocalVariablesRequest;
import org.eclipse.ptp.internal.debug.core.pdi.manager.AbstractPDIManager;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;

public class VariableManager
extends AbstractPDIManager
implements IPDIVariableManager {
    static final IPDIVariable[] EMPTY_VARIABLES = new IPDIVariable[0];
    int MAX_STACK_DEPTH = 200;
    Map<TaskSet, List<IPDIVariable>> variablesMap = new Hashtable<TaskSet, List<IPDIVariable>>();

    public VariableManager(IPDISession session) {
        super(session, true);
    }

    @Override
    public IPDIArgument createArgument(IPDIArgumentDescriptor argDesc) throws PDIException {
        IPDIVariable variable = this.findVariable(argDesc);
        IPDIArgument argument = null;
        if (variable != null && variable instanceof IPDIArgument) {
            argument = (IPDIArgument)variable;
        }
        if (argument == null) {
            IPDIStackFrame stack = argDesc.getStackFrame();
            IPDITarget target = stack.getTarget();
            IPDIThread currentThread = target.getCurrentThread();
            IPDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
            target.lockTarget();
            try {
                target.setCurrentThread(stack.getThread(), false);
                stack.getThread().setCurrentStackFrame(stack, false);
                argument = this.session.getModelFactory().newArgument(this.session, argDesc, argDesc.getId());
                List<IPDIVariable> variablesList = this.getVariablesList(argDesc.getTasks());
                variablesList.add(argument);
            }
            finally {
                target.setCurrentThread(currentThread, false);
                currentThread.setCurrentStackFrame(currentFrame, false);
                target.releaseTarget();
            }
        }
        return argument;
    }

    @Override
    public IPDIGlobalVariable createGlobalVariable(IPDIGlobalVariableDescriptor varDesc) throws PDIException {
        IPDIVariable variable = this.findVariable(varDesc);
        IPDIGlobalVariable global = null;
        if (variable instanceof IPDIGlobalVariable) {
            global = (IPDIGlobalVariable)variable;
        }
        if (global == null) {
            global = this.session.getModelFactory().newGlobalVariable(this.session, varDesc, varDesc.getId());
            List<IPDIVariable> variablesList = this.getVariablesList(varDesc.getTasks());
            variablesList.add(global);
        }
        return global;
    }

    @Override
    public IPDILocalVariable createLocalVariable(IPDILocalVariableDescriptor varDesc) throws PDIException {
        IPDIVariable variable = this.findVariable(varDesc);
        IPDILocalVariable local = null;
        if (variable instanceof IPDILocalVariable) {
            local = (IPDILocalVariable)variable;
        }
        if (local == null) {
            IPDIStackFrame stack = varDesc.getStackFrame();
            IPDITarget target = stack.getTarget();
            IPDIThread currentThread = target.getCurrentThread();
            IPDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
            target.lockTarget();
            try {
                target.setCurrentThread(stack.getThread(), false);
                stack.getThread().setCurrentStackFrame(stack, false);
                local = this.session.getModelFactory().newLocalVariable(this.session, varDesc, varDesc.getId());
                List<IPDIVariable> variablesList = this.getVariablesList(varDesc.getTasks());
                variablesList.add(local);
            }
            finally {
                target.setCurrentThread(currentThread, false);
                currentThread.setCurrentStackFrame(currentFrame, false);
                target.releaseTarget();
            }
        }
        return local;
    }

    @Override
    public IPDIThreadStorage createThreadStorage(IPDIThreadStorageDescriptor desc) throws PDIException {
        throw new PDIException(desc.getTasks(), Messages.VariableManager_0);
    }

    @Override
    public IPDIVariable createVariable(IPDIVariableDescriptor varDesc) throws PDIException {
        if (varDesc instanceof IPDIArgumentDescriptor) {
            return this.createArgument((IPDIArgumentDescriptor)varDesc);
        }
        if (varDesc instanceof IPDILocalVariableDescriptor) {
            return this.createLocalVariable((IPDILocalVariableDescriptor)varDesc);
        }
        if (varDesc instanceof IPDIGlobalVariableDescriptor) {
            return this.createGlobalVariable((IPDIGlobalVariableDescriptor)varDesc);
        }
        if (varDesc instanceof IPDIRegisterDescriptor) {
            return this.session.getRegisterManager().createRegister((IPDIRegisterDescriptor)varDesc);
        }
        if (varDesc instanceof IPDIThreadStorageDescriptor) {
            return this.createThreadStorage((IPDIThreadStorageDescriptor)varDesc);
        }
        throw new PDIException(varDesc.getTasks(), Messages.VariableManager_0);
    }

    public void destroyAllVariables(TaskSet qTasks) throws PDIException {
        IPDIVariable[] variables;
        ArrayList<IPDIDestroyedEvent> eventList = new ArrayList<IPDIDestroyedEvent>();
        IPDIVariable[] iPDIVariableArray = variables = this.getVariables(qTasks);
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIVariable variable = iPDIVariableArray[n2];
            this.removeVar(qTasks, variable.getId());
            eventList.add(this.session.getEventFactory().newDestroyedEvent(this.session.getEventFactory().newVariableInfo(this.session, qTasks, variable.getId(), variable)));
            ++n2;
        }
        this.session.getEventManager().fireEvents(eventList.toArray(new IPDIEvent[0]));
    }

    @Override
    public void destroyVariable(IPDIVariable variable) throws PDIException {
        TaskSet qTasks = variable.getTasks();
        List<IPDIVariable> varList = this.getVariablesList(qTasks);
        if (varList.contains(variable)) {
            this.removeVar(qTasks, variable.getId());
        }
        IPDIDestroyedEvent event = this.session.getEventFactory().newDestroyedEvent(this.session.getEventFactory().newVariableInfo(this.session, qTasks, variable.getId(), variable));
        this.session.getEventManager().fireEvents(new IPDIEvent[]{event});
    }

    public IPDIVariable findVariable(IPDIVariableDescriptor v) throws PDIException {
        IPDIVariable[] vars;
        IPDIVariable[] iPDIVariableArray = vars = this.getVariables(v.getTasks());
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIVariable var = iPDIVariableArray[n2];
            if (var.getFullName().equals(v.getFullName()) && var.equalDescriptors(v)) {
                return var;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IPDIArgumentDescriptor[] getArgumentDescriptors(IPDIStackFrame frame) throws PDIException {
        ArrayList<IPDIArgumentDescriptor> argObjects = new ArrayList<IPDIArgumentDescriptor>();
        IPDITarget target = frame.getTarget();
        IPDIThread currentThread = target.getCurrentThread();
        IPDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            target.setCurrentThread(frame.getThread(), false);
            frame.getThread().setCurrentStackFrame(frame, false);
            int depth = frame.getThread().getStackFrameCount();
            int level = frame.getLevel();
            int diff = depth - level;
            IPDIListArgumentsRequest request = this.session.getRequestFactory().getListArgumentsRequest(target.getTasks(), diff, diff);
            this.session.getEventRequestManager().addEventRequest(request);
            String[] args = request.getArguments(target.getTasks());
            int i = 0;
            while (i < args.length) {
                argObjects.add(this.session.getModelFactory().newArgumentDescriptor(this.session, target.getTasks(), null, frame, args[i], null, args.length - i, level));
                ++i;
            }
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
        }
        return argObjects.toArray(new IPDIArgumentDescriptor[0]);
    }

    @Override
    public IPDIGlobalVariableDescriptor getGlobalVariableDescriptor(TaskSet tasks, String filename, String function, String name) throws PDIException {
        if (filename == null) {
            filename = new String();
        }
        if (function == null) {
            function = new String();
        }
        if (name == null) {
            name = new String();
        }
        StringBuffer buffer = new StringBuffer();
        if (filename.length() > 0) {
            buffer.append('\'').append(filename).append('\'').append("::");
        }
        if (function.length() > 0) {
            buffer.append(function).append("::");
        }
        buffer.append(name);
        return this.session.getModelFactory().newGlobalVariableDescriptor(this.session, tasks, null, null, buffer.toString(), null, 0, 0);
    }

    @Override
    public IPDILocalVariableDescriptor[] getLocalVariableDescriptors(IPDIStackFrame frame) throws PDIException {
        ArrayList<IPDILocalVariableDescriptor> varObjects = new ArrayList<IPDILocalVariableDescriptor>();
        IPDITarget target = frame.getTarget();
        IPDIThread currentThread = target.getCurrentThread();
        IPDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            target.setCurrentThread(frame.getThread(), false);
            frame.getThread().setCurrentStackFrame(frame, false);
            int level = frame.getLevel();
            IPDIListLocalVariablesRequest request = this.session.getRequestFactory().getListLocalVariablesRequest(target.getTasks());
            this.session.getEventRequestManager().addEventRequest(request);
            String[] vars = request.getLocalVariables(target.getTasks());
            int i = 0;
            while (i < vars.length) {
                varObjects.add(this.session.getModelFactory().newLocalVariableDescriptor(this.session, target.getTasks(), null, frame, vars[i], null, vars.length - i, level));
                ++i;
            }
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
        }
        return varObjects.toArray(new IPDILocalVariableDescriptor[0]);
    }

    @Override
    public IPDIThreadStorageDescriptor[] getThreadStorageDescriptors(IPDIThread thread) throws PDIException {
        return new IPDIThreadStorageDescriptor[0];
    }

    public IPDIVariable getVariable(TaskSet tasks, String varid) {
        IPDIVariable[] vars;
        IPDIVariable[] iPDIVariableArray = vars = this.getVariables(tasks);
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIVariable var = iPDIVariableArray[n2];
            if (var.getId().equals(varid)) {
                return var;
            }
            IPDIVariable v = var.getChild(varid);
            if (v != null) {
                return v;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IPDIVariable getVariableByName(TaskSet tasks, String varname) {
        IPDIVariable[] vars;
        IPDIVariable[] iPDIVariableArray = vars = this.getVariables(tasks);
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIVariable var = iPDIVariableArray[n2];
            if (var.getName().equals(varname)) {
                return var;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IPDIVariableDescriptor getVariableDescriptorAsArray(IPDIVariableDescriptor varDesc, int start, int length) throws PDIException {
        IPDIThread thread = varDesc.getThread();
        IPDIStackFrame frame = varDesc.getStackFrame();
        String name = varDesc.getName();
        String fullName = varDesc.getFullName();
        int pos = varDesc.getPosition();
        int depth = varDesc.getStackDepth();
        IPDIVariableDescriptor vo = null;
        if (varDesc instanceof IPDIArgumentDescriptor || varDesc instanceof IPDIArgument) {
            vo = this.session.getModelFactory().newArgumentDescriptor(this.session, varDesc.getTasks(), thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof IPDILocalVariableDescriptor || varDesc instanceof IPDILocalVariable) {
            vo = this.session.getModelFactory().newLocalVariableDescriptor(this.session, varDesc.getTasks(), thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof IPDIGlobalVariableDescriptor || varDesc instanceof IPDIGlobalVariable) {
            vo = this.session.getModelFactory().newGlobalVariableDescriptor(this.session, varDesc.getTasks(), thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof IPDIRegisterDescriptor || varDesc instanceof IPDIRegister) {
            vo = this.session.getModelFactory().newRegisterDescriptor(this.session, varDesc.getTasks(), thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof IPDIThreadStorageDescriptor || varDesc instanceof IPDIThreadStorage) {
            vo = this.session.getModelFactory().newThreadStorageDescriptor(this.session, varDesc.getTasks(), thread, frame, name, fullName, pos, depth);
        } else {
            throw new PDIException(varDesc.getTasks(), Messages.VariableManager_0);
        }
        vo.setCastingArrayStart(varDesc.getCastingArrayStart() + start);
        vo.setCastingArrayEnd(length);
        return vo;
    }

    @Override
    public IPDIVariableDescriptor getVariableDescriptorAsType(IPDIVariableDescriptor varDesc, String type) throws PDIException {
        throw new PDIException(varDesc.getTasks(), Messages.VariableManager_1);
    }

    public IPDIVariable[] getVariables(TaskSet tasks) {
        List<IPDIVariable> variableList = this.variablesMap.get(tasks);
        if (variableList != null) {
            return variableList.toArray(new IPDIVariable[variableList.size()]);
        }
        return new IPDIVariable[0];
    }

    public void removeVar(TaskSet tasks, String varid) throws PDIException {
        this.session.getEventRequestManager().addEventRequest(this.session.getRequestFactory().getDeletePartialExpressionRequest(tasks, varid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPDIVariable removeVariableFromList(TaskSet tasks, String varId) {
        List<IPDIVariable> varList;
        List<IPDIVariable> list = varList = this.getVariablesList(tasks);
        synchronized (list) {
            Iterator<IPDIVariable> iterator = varList.iterator();
            while (iterator.hasNext()) {
                IPDIVariable variable = iterator.next();
                if (!variable.getId().equals(varId)) continue;
                iterator.remove();
                return variable;
            }
        }
        return null;
    }

    @Override
    public void shutdown() {
        this.variablesMap.clear();
    }

    @Override
    public void update(TaskSet qTasks) throws PDIException {
        this.update(qTasks, new String[0]);
    }

    @Override
    public void update(TaskSet qTasks, String[] vars) throws PDIException {
        ArrayList<IPDIChangedEvent> eventList = new ArrayList<IPDIChangedEvent>();
        String[] stringArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            IPDIVariable variable = this.getVariable(qTasks, var);
            if (variable != null) {
                eventList.add(this.session.getEventFactory().newChangedEvent(this.session.getEventFactory().newVariableInfo(this.session, qTasks, variable.getId(), variable)));
            }
            ++n2;
        }
        this.session.getEventManager().fireEvents(eventList.toArray(new IPDIEvent[0]));
    }

    private synchronized List<IPDIVariable> getVariablesList(TaskSet tasks) {
        List<IPDIVariable> variablesList = this.variablesMap.get(tasks);
        if (variablesList == null) {
            variablesList = Collections.synchronizedList(new ArrayList());
            this.variablesMap.put(tasks, variablesList);
        }
        return variablesList;
    }
}

