/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.analysis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIBlock;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IBlock;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.impl.ControlFlowGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPIControlFlowGraph
extends ControlFlowGraph {
    protected List<IBlock> returnBlocks_;
    private static final boolean traceOn = false;

    public MPIControlFlowGraph(IASTStatement funcBody) {
        super(funcBody);
    }

    public List<IBlock> getReturnBlocks() {
        return this.returnBlocks_;
    }

    protected void collectBlocks() {
        this.entry_ = new MPIBlock();
        this.exit_ = new MPIBlock();
        MPIBlockCollector mbc = new MPIBlockCollector();
        mbc.run();
    }

    protected void otherOPs() {
        this.returnBlocks_ = new ArrayList<IBlock>();
        PhiFlowBuilder phi = new PhiFlowBuilder();
        phi.run();
        BreakContinueChecker bcc = new BreakContinueChecker();
        bcc.run();
    }

    public void print() {
        IBlock b = this.entry_;
        while (b != null) {
            MPIBlock block = (MPIBlock)b;
            block.print();
            b = b.topNext();
        }
    }

    class BreakContinueChecker
    extends ASTVisitor {
        BreakContinueChecker() {
        }

        public void run() {
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            MPIControlFlowGraph.this.prog_.accept((ASTVisitor)this);
        }

        public int visit(IASTStatement stmt) {
            if (stmt instanceof IASTBreakStatement || stmt instanceof IASTContinueStatement) {
                IASTNode parent = stmt.getParent();
                while (parent != MPIControlFlowGraph.this.prog_) {
                    if (parent instanceof IASTIfStatement) break;
                    parent = parent.getParent();
                }
                if (!(parent instanceof IASTIfStatement)) {
                    return 3;
                }
                IASTIfStatement ifS = (IASTIfStatement)parent;
                IASTExpression cond = ifS.getConditionExpression();
                MPIBlock condBlock = (MPIBlock)MPIControlFlowGraph.this.getBlock(cond, (IASTStatement)ifS);
                if (stmt instanceof IASTBreakStatement) {
                    condBlock.withBreak = true;
                } else {
                    condBlock.withContinue = true;
                }
            }
            return 3;
        }
    }

    class MPIBlockCollector
    extends ASTVisitor {
        MPIBlockCollector() {
        }

        public void run() {
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            MPIControlFlowGraph.this.prog_.accept((ASTVisitor)this);
        }

        public int visit(IASTStatement stmt) {
            if (stmt instanceof IASTBreakStatement) {
                MPIBlock block = new MPIBlock(stmt);
                MPIControlFlowGraph.this.addBlock((IBlock)block);
            } else if (stmt instanceof IASTCaseStatement) {
                MPIBlock block = new MPIBlock(stmt);
                MPIControlFlowGraph.this.addBlock((IBlock)block);
            } else if (!(stmt instanceof IASTCompoundStatement)) {
                if (stmt instanceof IASTContinueStatement) {
                    MPIBlock block = new MPIBlock(stmt);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                } else if (stmt instanceof IASTDeclarationStatement) {
                    MPIBlock block = new MPIBlock(stmt);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                } else if (stmt instanceof IASTDefaultStatement) {
                    MPIBlock block = new MPIBlock(stmt);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                } else if (stmt instanceof IASTDoStatement) {
                    IASTDoStatement doStmt = (IASTDoStatement)stmt;
                    MPIBlock block = new MPIBlock(doStmt.getCondition(), stmt);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                    MPIBlock exitjoin = new MPIBlock(null, stmt, 5);
                    MPIControlFlowGraph.this.addBlock((IBlock)exitjoin);
                    MPIBlock continuejoin = new MPIBlock(null, stmt, 4);
                    MPIControlFlowGraph.this.addBlock((IBlock)continuejoin);
                } else if (stmt instanceof IASTExpressionStatement) {
                    MPIBlock block = new MPIBlock(stmt);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                } else if (stmt instanceof IASTForStatement) {
                    IASTForStatement forStmt = (IASTForStatement)stmt;
                    MPIBlock block = new MPIBlock(forStmt.getConditionExpression(), stmt);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                    if (forStmt.getIterationExpression() != null) {
                        block = new MPIBlock(forStmt.getIterationExpression(), stmt);
                        MPIControlFlowGraph.this.addBlock((IBlock)block);
                    }
                    MPIBlock continuejoin = new MPIBlock(null, stmt, 4);
                    MPIControlFlowGraph.this.addBlock((IBlock)continuejoin);
                    MPIBlock exitjoin = new MPIBlock(null, stmt, 5);
                    MPIControlFlowGraph.this.addBlock((IBlock)exitjoin);
                } else if (stmt instanceof IASTGotoStatement) {
                    MPIBlock block = new MPIBlock(stmt);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                } else if (stmt instanceof IASTIfStatement) {
                    IASTIfStatement ifStmt = (IASTIfStatement)stmt;
                    MPIBlock block = new MPIBlock(ifStmt.getConditionExpression(), stmt);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                    MPIBlock join = new MPIBlock(null, stmt, 5);
                    MPIControlFlowGraph.this.addBlock((IBlock)join);
                } else if (stmt instanceof IASTLabelStatement) {
                    IASTLabelStatement labelS = (IASTLabelStatement)stmt;
                    MPIBlock block = new MPIBlock((IASTNode)labelS.getName(), stmt, 3);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                } else if (stmt instanceof IASTNullStatement) {
                    MPIBlock block = new MPIBlock(stmt);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                } else if (stmt instanceof IASTProblemStatement) {
                    MPIBlock block = new MPIBlock(stmt);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                } else if (stmt instanceof IASTReturnStatement) {
                    IASTReturnStatement rtStmt = (IASTReturnStatement)stmt;
                    MPIBlock block = new MPIBlock(rtStmt.getReturnValue(), stmt);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                } else if (stmt instanceof IASTSwitchStatement) {
                    IASTSwitchStatement swStmt = (IASTSwitchStatement)stmt;
                    MPIBlock block = new MPIBlock(swStmt.getControllerExpression(), stmt);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                    MPIBlock join = new MPIBlock(null, stmt, 5);
                    MPIControlFlowGraph.this.addBlock((IBlock)join);
                } else if (stmt instanceof IASTWhileStatement) {
                    IASTWhileStatement whStmt = (IASTWhileStatement)stmt;
                    MPIBlock block = new MPIBlock(whStmt.getCondition(), stmt);
                    MPIControlFlowGraph.this.addBlock((IBlock)block);
                    MPIBlock join = new MPIBlock(null, stmt, 4);
                    MPIControlFlowGraph.this.addBlock((IBlock)join);
                    MPIBlock exitjoin = new MPIBlock(null, stmt, 5);
                    MPIControlFlowGraph.this.addBlock((IBlock)exitjoin);
                }
            }
            return 3;
        }
    }

    class PhiFlowBuilder
    extends ControlFlowGraph.FlowBuilder {
        PhiFlowBuilder() {
            super((ControlFlowGraph)MPIControlFlowGraph.this);
        }

        public void run() {
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitTranslationUnit = true;
            this.shouldVisitExpressions = true;
            MPIControlFlowGraph.this.prog_.accept((ASTVisitor)this);
        }

        public int visit(IASTStatement stmt) {
            block30: {
                if (stmt instanceof IASTBreakStatement) {
                    IASTNode parent = stmt.getParent();
                    ArrayList<IASTIfStatement> branches = new ArrayList<IASTIfStatement>();
                    while (true) {
                        if (parent instanceof IASTDoStatement || parent instanceof IASTForStatement || parent instanceof IASTWhileStatement) {
                            MPIBlock exitjoin = (MPIBlock)MPIControlFlowGraph.this.getBlock(null, (IASTStatement)parent, 5);
                            for (IASTIfStatement ifstmt : branches) {
                                MPIBlock ifcondblock = (MPIBlock)MPIControlFlowGraph.this.getBlock(ifstmt.getConditionExpression(), (IASTStatement)ifstmt);
                                this.PhiEdge(ifcondblock, exitjoin);
                            }
                            MPIBlock loopcondblock = null;
                            if (parent instanceof IASTDoStatement) {
                                IASTDoStatement doS = (IASTDoStatement)parent;
                                loopcondblock = (MPIBlock)MPIControlFlowGraph.this.getBlock(doS.getCondition(), (IASTStatement)doS);
                            } else if (parent instanceof IASTForStatement) {
                                IASTForStatement forS = (IASTForStatement)parent;
                                loopcondblock = (MPIBlock)MPIControlFlowGraph.this.getBlock(forS.getConditionExpression(), (IASTStatement)forS);
                            } else if (parent instanceof IASTWhileStatement) {
                                IASTWhileStatement whileS = (IASTWhileStatement)parent;
                                loopcondblock = (MPIBlock)MPIControlFlowGraph.this.getBlock(whileS.getCondition(), (IASTStatement)whileS);
                            }
                            this.PhiEdge(loopcondblock, exitjoin);
                            break block30;
                        }
                        if (parent instanceof IASTSwitchStatement) {
                            MPIBlock exitjoin = (MPIBlock)MPIControlFlowGraph.this.getBlock(null, (IASTStatement)parent, 5);
                            IASTSwitchStatement swStmt = (IASTSwitchStatement)parent;
                            MPIBlock swcond = (MPIBlock)MPIControlFlowGraph.this.getBlock(swStmt.getControllerExpression(), (IASTStatement)parent);
                            this.PhiEdge(swcond, exitjoin);
                            break block30;
                        }
                        if (parent instanceof IASTIfStatement) {
                            branches.add((IASTIfStatement)parent);
                            parent = parent.getParent();
                            continue;
                        }
                        parent = parent.getParent();
                    }
                }
                if (stmt instanceof IASTCaseStatement || stmt instanceof IASTDefaultStatement) {
                    IASTNode parent = stmt.getParent();
                    while (!(parent instanceof IASTSwitchStatement)) {
                        parent = parent.getParent();
                    }
                    IASTSwitchStatement swStmt = (IASTSwitchStatement)parent;
                    MPIBlock swblock = (MPIBlock)MPIControlFlowGraph.this.getBlock(swStmt.getControllerExpression(), (IASTStatement)parent);
                    MPIBlock caseblock = (MPIBlock)MPIControlFlowGraph.this.getBlock(stmt);
                    if (caseblock.getPreds().size() > 1) {
                        this.PhiEdge(swblock, caseblock);
                    }
                } else {
                    if (stmt instanceof IASTContinueStatement) {
                        IASTNode parent = stmt.getParent();
                        ArrayList<IASTIfStatement> branches = new ArrayList<IASTIfStatement>();
                        while (true) {
                            if (parent instanceof IASTDoStatement || parent instanceof IASTForStatement || parent instanceof IASTWhileStatement) {
                                MPIBlock continuejoin = (MPIBlock)MPIControlFlowGraph.this.getBlock(null, (IASTStatement)parent, 4);
                                for (IASTIfStatement ifS : branches) {
                                    MPIBlock ifcondblock = (MPIBlock)MPIControlFlowGraph.this.getBlock(ifS.getConditionExpression(), (IASTStatement)ifS);
                                    this.PhiEdge(ifcondblock, continuejoin);
                                }
                                break block30;
                            }
                            if (parent instanceof IASTIfStatement) {
                                branches.add((IASTIfStatement)parent);
                                parent = parent.getParent();
                                continue;
                            }
                            parent = parent.getParent();
                        }
                    }
                    if (stmt instanceof IASTDoStatement) {
                        IASTDoStatement doStmt = (IASTDoStatement)stmt;
                        MPIBlock cond = (MPIBlock)MPIControlFlowGraph.this.getBlock(doStmt.getCondition(), stmt);
                        if (doStmt.getBody() != null) {
                            MPIBlock first = (MPIBlock)this.firstBlock(doStmt.getBody());
                            this.PhiEdge(cond, first);
                        }
                    } else if (stmt instanceof IASTForStatement) {
                        IASTForStatement forStmt = (IASTForStatement)stmt;
                        MPIBlock cond = (MPIBlock)MPIControlFlowGraph.this.getBlock(forStmt.getConditionExpression(), stmt);
                        this.PhiEdge(cond, cond);
                    } else if (stmt instanceof IASTIfStatement) {
                        IASTIfStatement ifStmt = (IASTIfStatement)stmt;
                        MPIBlock condb = (MPIBlock)MPIControlFlowGraph.this.getBlock(ifStmt.getConditionExpression(), stmt);
                        MPIBlock join = (MPIBlock)MPIControlFlowGraph.this.getBlock(null, stmt, 5);
                        this.PhiEdge(condb, join);
                    } else if (stmt instanceof IASTReturnStatement) {
                        IASTReturnStatement rtStmt = (IASTReturnStatement)stmt;
                        MPIBlock rv = (MPIBlock)MPIControlFlowGraph.this.getBlock(rtStmt.getReturnValue(), stmt);
                        MPIControlFlowGraph.this.returnBlocks_.add((IBlock)rv);
                    } else if (stmt instanceof IASTWhileStatement) {
                        IASTWhileStatement whStmt = (IASTWhileStatement)stmt;
                        MPIBlock cond = (MPIBlock)MPIControlFlowGraph.this.getBlock(whStmt.getCondition(), stmt);
                        this.PhiEdge(cond, cond);
                    }
                }
            }
            return 3;
        }

        protected void PhiEdge(MPIBlock from, MPIBlock to) {
            List<IBlock> joins;
            if (!to.getCond().contains((Object)from)) {
                to.getCond().add((IBlock)from);
            }
            if (!(joins = from.getJoin()).contains((Object)to)) {
                joins.add((IBlock)to);
            }
        }
    }
}

