/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.deltas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementDelta;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.internal.core.model.Q7Element;
import org.eclipse.rcptt.internal.core.model.deltas.ResourceChangeToNonQ7Delta;
import org.eclipse.rcptt.internal.core.model.deltas.SimpleDelta;

public class Q7ElementDelta
extends SimpleDelta
implements IQ7ElementDelta {
    protected static final IQ7ElementDelta[] EMPTY_DELTA = new IQ7ElementDelta[0];
    protected IQ7ElementDelta[] affectedChildren = EMPTY_DELTA;
    protected IQ7Element changedElement;
    protected IResourceDelta[] resourceDeltas = null;
    protected int resourceDeltasCounter;
    protected IQ7Element movedFromHandle = null;
    protected IQ7Element movedToHandle = null;

    public Q7ElementDelta(IQ7Element element) {
        this.changedElement = element;
    }

    public void added(IQ7Element element) {
        this.added(element, 0);
    }

    public void added(IQ7Element element, int flags) {
        Q7ElementDelta addedDelta = new Q7ElementDelta(element);
        addedDelta.added();
        addedDelta.changeFlags |= flags;
        this.insertDeltaTree(element, addedDelta);
    }

    public void removed(IQ7Element element) {
        this.removed(element, 0);
    }

    public void removed(IQ7Element element, int flags) {
        Q7ElementDelta removedDelta = new Q7ElementDelta(element);
        this.insertDeltaTree(element, removedDelta);
        Q7ElementDelta actualDelta = this.getDeltaFor(element);
        if (actualDelta != null) {
            actualDelta.removed();
            actualDelta.changeFlags |= flags;
            actualDelta.affectedChildren = EMPTY_DELTA;
        }
    }

    protected Q7ElementDelta getDeltaFor(IQ7Element element) {
        if (this.equalsAndSameParent(this.getElement(), element)) {
            return this;
        }
        if (this.affectedChildren.length == 0) {
            return null;
        }
        int childrenCount = this.affectedChildren.length;
        int i = 0;
        while (i < childrenCount) {
            Q7ElementDelta delta = (Q7ElementDelta)this.affectedChildren[i];
            if (this.equalsAndSameParent(delta.getElement(), element)) {
                return delta;
            }
            if ((delta = delta.getDeltaFor(element)) != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    protected void addAffectedChild(Q7ElementDelta child) {
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.changeFlags |= 8;
                break;
            }
            default: {
                this.kind = 4;
                this.changeFlags |= 8;
            }
        }
        if (this.changedElement.getElementType().equals((Object)IQ7Element.HandleType.Context) || this.changedElement.getElementType().equals((Object)IQ7Element.HandleType.Verification) || this.changedElement.getElementType().equals((Object)IQ7Element.HandleType.TestCase) || this.changedElement.getElementType().equals((Object)IQ7Element.HandleType.TestSuite)) {
            this.fineGrained();
        }
        if (this.affectedChildren == null || this.affectedChildren.length == 0) {
            this.affectedChildren = new IQ7ElementDelta[]{child};
            return;
        }
        SimpleDelta existingChild = null;
        int existingChildIndex = -1;
        if (this.affectedChildren != null) {
            int i = 0;
            while (i < this.affectedChildren.length) {
                if (this.equalsAndSameParent(this.affectedChildren[i].getElement(), child.getElement())) {
                    existingChild = (Q7ElementDelta)this.affectedChildren[i];
                    existingChildIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (existingChild == null) {
            this.affectedChildren = this.growAndAddToArray(this.affectedChildren, child);
        } else {
            switch (existingChild.getKind()) {
                case 1: {
                    switch (child.getKind()) {
                        case 1: 
                        case 4: {
                            return;
                        }
                        case 2: {
                            this.affectedChildren = this.removeAndShrinkArray(this.affectedChildren, existingChildIndex);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (child.getKind()) {
                        case 1: {
                            child.kind = 4;
                            this.affectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 2: 
                        case 4: {
                            return;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (child.getKind()) {
                        case 1: 
                        case 2: {
                            this.affectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 4: {
                            IResourceDelta[] resDeltas;
                            IQ7ElementDelta[] children = child.getAffectedChildren();
                            int i = 0;
                            while (i < children.length) {
                                Q7ElementDelta childsChild = (Q7ElementDelta)children[i];
                                ((Q7ElementDelta)existingChild).addAffectedChild(childsChild);
                                ++i;
                            }
                            boolean childHadContentFlag = (child.changeFlags & 1) != 0;
                            boolean existingChildHadChildrenFlag = (((Q7ElementDelta)existingChild).changeFlags & 8) != 0;
                            ((Q7ElementDelta)existingChild).changeFlags |= child.changeFlags;
                            if (childHadContentFlag && existingChildHadChildrenFlag) {
                                ((Q7ElementDelta)existingChild).changeFlags &= 0xFFFFFFFE;
                            }
                            if ((resDeltas = child.getResourceDeltas()) != null) {
                                ((Q7ElementDelta)existingChild).resourceDeltas = resDeltas;
                                ((Q7ElementDelta)existingChild).resourceDeltasCounter = child.resourceDeltasCounter;
                            }
                            return;
                        }
                    }
                    break;
                }
                default: {
                    int flags = existingChild.getFlags();
                    this.affectedChildren[existingChildIndex] = child;
                    child.changeFlags |= flags;
                }
            }
        }
    }

    @Override
    public IQ7Element getElement() {
        return this.changedElement;
    }

    public Q7ElementDelta changed(IQ7Element element, int changeFlag) {
        Q7ElementDelta changedDelta = new Q7ElementDelta(element);
        changedDelta.changed(changeFlag);
        this.insertDeltaTree(element, changedDelta);
        return changedDelta;
    }

    public void insertDeltaTree(IQ7Element element, Q7ElementDelta delta) {
        Q7ElementDelta childDelta = this.createDeltaTree(element, delta);
        if (!this.equalsAndSameParent(element, this.getElement())) {
            this.addAffectedChild(childDelta);
        }
    }

    protected Q7ElementDelta createDeltaTree(IQ7Element element, Q7ElementDelta delta) {
        Q7ElementDelta childDelta = delta;
        ArrayList<IQ7Element> ancestors = this.getAncestors(element);
        if (ancestors == null) {
            if (this.equalsAndSameParent(delta.getElement(), this.getElement())) {
                this.kind = delta.kind;
                this.changeFlags = delta.changeFlags;
                this.movedToHandle = delta.movedToHandle;
                this.movedFromHandle = delta.movedFromHandle;
            }
        } else {
            int i = 0;
            int size = ancestors.size();
            while (i < size) {
                IQ7Element ancestor = ancestors.get(i);
                Q7ElementDelta ancestorDelta = new Q7ElementDelta(ancestor);
                ancestorDelta.addAffectedChild(childDelta);
                childDelta = ancestorDelta;
                ++i;
            }
        }
        return childDelta;
    }

    protected boolean equalsAndSameParent(IQ7Element e1, IQ7Element e2) {
        IQ7Element parent1;
        return e1.equals(e2) && (parent1 = e1.getParent()) != null && parent1.equals(e2.getParent());
    }

    @Override
    public IQ7ElementDelta[] getAddedChildren() {
        return this.getChildrenOfType(1);
    }

    @Override
    public IQ7ElementDelta[] getAffectedChildren() {
        return this.affectedChildren;
    }

    private ArrayList<IQ7Element> getAncestors(IQ7Element element) {
        IQ7Element parent = element.getParent();
        if (parent == null) {
            return null;
        }
        ArrayList<IQ7Element> parents = new ArrayList<IQ7Element>();
        while (!parent.equals(this.changedElement)) {
            parents.add(parent);
            parent = parent.getParent();
            if (parent != null) continue;
            return null;
        }
        parents.trimToSize();
        return parents;
    }

    protected IQ7ElementDelta[] growAndAddToArray(IQ7ElementDelta[] array, IQ7ElementDelta addition) {
        IQ7ElementDelta[] old = array;
        array = new IQ7ElementDelta[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected IQ7ElementDelta[] removeAndShrinkArray(IQ7ElementDelta[] old, int index) {
        int rest;
        IQ7ElementDelta[] array = new IQ7ElementDelta[old.length - 1];
        if (index > 0) {
            System.arraycopy(old, 0, array, 0, index);
        }
        if ((rest = old.length - index - 1) > 0) {
            System.arraycopy(old, index + 1, array, index, rest);
        }
        return array;
    }

    public void fineGrained() {
        this.changed(16384);
    }

    @Override
    public IResourceDelta[] getResourceDeltas() {
        if (this.resourceDeltas == null) {
            return null;
        }
        if (this.resourceDeltas.length != this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        return this.resourceDeltas;
    }

    protected void removeAffectedChild(Q7ElementDelta child) {
        int index = -1;
        if (this.affectedChildren != null) {
            int i = 0;
            while (i < this.affectedChildren.length) {
                if (this.equalsAndSameParent(this.affectedChildren[i].getElement(), child.getElement())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index >= 0) {
            this.affectedChildren = this.removeAndShrinkArray(this.affectedChildren, index);
        }
    }

    public void contentChanged() {
        this.changeFlags |= 1;
    }

    public void movedFrom(IQ7Element movedFromElement, IQ7Element movedToElement) {
        Q7ElementDelta removedDelta = new Q7ElementDelta(movedFromElement);
        removedDelta.kind = 2;
        removedDelta.changeFlags |= 0x20;
        removedDelta.movedToHandle = movedToElement;
        this.insertDeltaTree(movedFromElement, removedDelta);
    }

    public void movedTo(IQ7Element movedToElement, IQ7Element movedFromElement) {
        Q7ElementDelta addedDelta = new Q7ElementDelta(movedToElement);
        addedDelta.kind = 1;
        addedDelta.changeFlags |= 0x10;
        addedDelta.movedFromHandle = movedFromElement;
        this.insertDeltaTree(movedToElement, addedDelta);
    }

    protected void addResourceDelta(IResource resource) {
        this.addResourceDelta(new ResourceChangeToNonQ7Delta(resource));
    }

    protected void addResourceDelta(IResourceDelta child) {
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.changeFlags |= 1;
                break;
            }
            default: {
                this.kind = 4;
                this.changeFlags |= 1;
            }
        }
        if (this.resourceDeltas == null) {
            this.resourceDeltas = new IResourceDelta[5];
            this.resourceDeltas[this.resourceDeltasCounter++] = child;
            return;
        }
        if (this.resourceDeltas.length == this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter * 2];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        this.resourceDeltas[this.resourceDeltasCounter++] = child;
    }

    protected Q7ElementDelta find(IQ7Element e) {
        if (this.equalsAndSameParent(this.changedElement, e)) {
            return this;
        }
        int i = 0;
        while (i < this.affectedChildren.length) {
            Q7ElementDelta delta = ((Q7ElementDelta)this.affectedChildren[i]).find(e);
            if (delta != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    public void closed(IQ7Element element) {
        Q7ElementDelta delta = new Q7ElementDelta(element);
        delta.changed(1024);
        this.insertDeltaTree(element, delta);
    }

    public void opened(IQ7Element element) {
        Q7ElementDelta delta = new Q7ElementDelta(element);
        delta.changed(512);
        this.insertDeltaTree(element, delta);
    }

    protected IQ7ElementDelta[] getChildrenOfType(int type) {
        int length = this.affectedChildren.length;
        if (length == 0) {
            return new IQ7ElementDelta[0];
        }
        ArrayList<IQ7ElementDelta> children = new ArrayList<IQ7ElementDelta>(length);
        int i = 0;
        while (i < length) {
            if (this.affectedChildren[i].getKind() == type) {
                children.add(this.affectedChildren[i]);
            }
            ++i;
        }
        IQ7ElementDelta[] childrenOfType = new IQ7ElementDelta[children.size()];
        children.toArray(childrenOfType);
        return childrenOfType;
    }

    @Override
    public IQ7Element getMovedFromElement() {
        return this.movedFromHandle;
    }

    @Override
    public IQ7Element getMovedToElement() {
        return this.movedToHandle;
    }

    @Override
    public String toString() {
        return this.toDebugString(0);
    }

    public String toDebugString(int depth) {
        int i;
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < depth) {
            buffer.append('\t');
            ++i2;
        }
        buffer.append(((Q7Element)this.getElement()).toDebugString());
        this.toDebugString(buffer);
        IQ7ElementDelta[] children = this.getAffectedChildren();
        if (children != null) {
            i = 0;
            while (i < children.length) {
                buffer.append("\n");
                buffer.append(((Q7ElementDelta)children[i]).toDebugString(depth + 1));
                ++i;
            }
        }
        i = 0;
        while (i < this.resourceDeltasCounter) {
            buffer.append("\n");
            int j = 0;
            while (j < depth + 1) {
                buffer.append('\t');
                ++j;
            }
            IResourceDelta resourceDelta = this.resourceDeltas[i];
            buffer.append(resourceDelta.toString());
            buffer.append("[");
            switch (resourceDelta.getKind()) {
                case 1: {
                    buffer.append('+');
                    break;
                }
                case 2: {
                    buffer.append('-');
                    break;
                }
                case 4: {
                    buffer.append('*');
                    break;
                }
                default: {
                    buffer.append('?');
                }
            }
            buffer.append("]");
            ++i;
        }
        return buffer.toString();
    }

    @Override
    protected boolean toDebugString(StringBuffer buffer, int flags) {
        boolean prev = super.toDebugString(buffer, flags);
        if ((flags & 8) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CHILDREN");
            prev = true;
        }
        if ((flags & 0x80000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("PROJECT DESCRIPTION");
            prev = true;
        }
        if ((flags & 1) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CONTENT");
            prev = true;
        }
        if ((flags & 0x10) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_FROM(" + ((Q7Element)this.getMovedFromElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((flags & 0x20) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_TO(" + ((Q7Element)this.getMovedToElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((flags & 0x100) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("REORDERED");
            prev = true;
        }
        if ((flags & 0x4000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("FINE GRAINED");
            prev = true;
        }
        if ((flags & 0x40000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("PRIMARY RESOURCE");
            prev = true;
        }
        if ((flags & 0x200) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("OPENED");
            prev = true;
        }
        if ((flags & 0x400) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CLOSED");
            prev = true;
        }
        return prev;
    }

    @Override
    public IQ7NamedElement[] getNamedElements() {
        IQ7ElementDelta[] deltas;
        HashSet<IQ7NamedElement> namedElements = new HashSet<IQ7NamedElement>();
        IQ7ElementDelta[] iQ7ElementDeltaArray = deltas = this.getAffectedChildren();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7ElementDelta delta = iQ7ElementDeltaArray[n2];
            if ((delta.getFlags() & 0x10000) == 0) {
                IQ7NamedElement[] elements;
                IQ7Element element = delta.getElement();
                if (element instanceof IQ7NamedElement) {
                    namedElements.add((IQ7NamedElement)element);
                }
                if ((elements = delta.getNamedElements()).length > 0) {
                    namedElements.addAll(Arrays.asList(elements));
                }
            }
            ++n2;
        }
        return namedElements.toArray(new IQ7NamedElement[namedElements.size()]);
    }

    @Override
    public IQ7ElementDelta getChildBy(IQ7NamedElement e) {
        IQ7ElementDelta[] deltas;
        IQ7ElementDelta[] iQ7ElementDeltaArray = deltas = this.getAffectedChildren();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7ElementDelta delta = iQ7ElementDeltaArray[n2];
            IQ7Element element = delta.getElement();
            if (element.equals(e)) {
                return delta;
            }
            IQ7ElementDelta childBy = delta.getChildBy(e);
            if (childBy != null) {
                return childBy;
            }
            ++n2;
        }
        return null;
    }
}

