/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.filesystem.internal.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.filesystem.CopyFile;
import org.eclipse.rcptt.ecl.filesystem.EclFilesystemPlugin;
import org.eclipse.rcptt.ecl.filesystem.FileResolver;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class CopyFileService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        CopyFile copyFile = (CopyFile)command;
        String src = copyFile.getSource();
        String dst = copyFile.getDestination();
        String name = copyFile.getName();
        if (src == null || src.length() == 0) {
            return EclFilesystemPlugin.createError("Source file/directory is not specified.", new Object[0]);
        }
        if (dst == null || dst.length() == 0) {
            return EclFilesystemPlugin.createError("Destination directory is not specified.", new Object[0]);
        }
        try {
            File srcFile = FileResolver.resolve(src).toFile().getCanonicalFile();
            if (!srcFile.exists()) {
                return EclFilesystemPlugin.createError("Source file/directory \"%s\" does not exist.", srcFile);
            }
            File dstFile = FileResolver.resolve(dst).toFile().getCanonicalFile();
            if (dstFile.exists() && !dstFile.isDirectory()) {
                return EclFilesystemPlugin.createError("Destination \"%s\" must be a directory.", dstFile);
            }
            if (!dstFile.exists() && !dstFile.mkdirs()) {
                return EclFilesystemPlugin.createError("Unable to create the destination directory \"%s\".", dstFile);
            }
            dstFile = name != null && name.length() > 0 ? new File(dstFile, name) : new File(dstFile, srcFile.getName());
            if (srcFile.isFile()) {
                return CopyFileService.copyFile(srcFile, dstFile);
            }
            if (srcFile.isDirectory()) {
                return CopyFileService.copyDirectory(srcFile, dstFile);
            }
            return EclFilesystemPlugin.createError("Unsupported source type.", new Object[0]);
        }
        catch (Exception e) {
            return EclFilesystemPlugin.createError(e.getMessage(), new Object[0]);
        }
    }

    private static IStatus copyFile(File src, File dst) throws IOException {
        if (dst.exists()) {
            return EclFilesystemPlugin.createError("Destination \"%s\" already exists.", dst);
        }
        File parent = dst.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            return EclFilesystemPlugin.createError("Unable to create the destination directory \"%s\".", parent);
        }
        CopyFileService.doCopyFile(src, dst);
        return Status.OK_STATUS;
    }

    private static void doCopyFile(File src, File dst) throws IOException {
        if (!dst.exists()) {
            dst.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(src).getChannel();
            destination = new FileOutputStream(dst).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
        try {
            if (src.canExecute() && !dst.setExecutable(true, true)) {
                EclFilesystemPlugin.logWarning(String.format("Can't set executable permissions for %s", dst.getAbsolutePath()), null);
            }
        }
        catch (SecurityException e) {
            EclFilesystemPlugin.logWarning(String.format("Can't set executable permissions for %s", dst.getAbsolutePath()), e);
        }
    }

    private static IStatus copyDirectory(File src, File dst) throws IOException {
        if (dst.exists()) {
            return EclFilesystemPlugin.createError("Destination \"%s\" already exists.", dst);
        }
        if (CopyFileService.isSourceIncludesDestination(dst, src)) {
            return EclFilesystemPlugin.createError("Destination \"%s\" is nested inside source \"%s\".", dst, src);
        }
        if (!dst.mkdirs()) {
            return EclFilesystemPlugin.createError("Unable to create the destination directory \"%s\".", dst);
        }
        CopyFileService.copyFilesAndDirectories(src, dst);
        return Status.OK_STATUS;
    }

    private static boolean isSourceIncludesDestination(File dst, File src) {
        while (dst != null) {
            if (dst.equals(src)) {
                return true;
            }
            dst = dst.getParentFile();
        }
        return false;
    }

    private static void copyFilesAndDirectories(File src, File dst) throws IOException {
        File[] fileArray = src.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                CopyFileService.doCopyFile(f, new File(dst, f.getName()));
            } else if (f.isDirectory()) {
                File dir = new File(dst, f.getName());
                if (!dir.exists() && !dir.mkdirs()) {
                    throw new IOException(String.format("Unable to create \"%s\" directory.", dir));
                }
                CopyFileService.copyFilesAndDirectories(f, dir);
            }
            ++n2;
        }
    }
}

