/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.protocol.Assert;
import org.eclipse.rcptt.tesla.core.protocol.AssertImageData;
import org.eclipse.rcptt.tesla.core.protocol.AssertKind;
import org.eclipse.rcptt.tesla.core.protocol.AssertionFailedError;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GetRegionText;
import org.eclipse.rcptt.tesla.core.protocol.GetTextResponse;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;

public class BasicUIElement {
    protected final Element element;
    protected UIPlayer player;
    protected ProtocolFactory factory = ProtocolFactory.eINSTANCE;

    public BasicUIElement(Element e, UIPlayer player) {
        this.element = e != null ? (Element)EcoreUtil.copy((EObject)e) : null;
        this.player = player;
    }

    public Element getElement() {
        return this.element != null ? (Element)EcoreUtil.copy((EObject)this.element) : null;
    }

    public boolean isWindow() {
        return this.element.getKind().equals(ElementKind.Window.name());
    }

    public void doAssert(AssertKind kind, String attribute, String expected) throws AssertionFailedError {
        this.doAssert(kind, attribute, null, expected, null);
    }

    public void doAssert(AssertKind kind, String attribute, Integer index, String expected) throws AssertionFailedError {
        this.doAssert(kind, attribute, index, expected, null);
    }

    public void doAssert(AssertKind kind, String attribute, String expected, String category) throws AssertionFailedError {
        this.doAssert(kind, attribute, null, expected, category);
    }

    public void doAssert(AssertKind kind, String attribute, Integer index, String expected, String category) throws AssertionFailedError {
        Assert assertCmd = this.factory.createAssert();
        assertCmd.setElement(this.getElement());
        assertCmd.setKind(kind);
        assertCmd.setIndex(index);
        assertCmd.setAttribute(attribute);
        assertCmd.setValue(expected);
        assertCmd.setCategory(category);
        Response response = this.player.safeExecuteCommand(assertCmd);
        if (response == null) {
            return;
        }
    }

    public void doContainsImageAssert(byte[] image) throws AssertionFailedError {
        Assert assertCmd = this.factory.createAssert();
        assertCmd.setElement(this.getElement());
        assertCmd.setKind(AssertKind.CONTAINS_IMAGE);
        AssertImageData imageData = this.factory.createAssertImageData();
        imageData.setImage(image);
        assertCmd.setImageData(imageData);
        Response response = this.player.safeExecuteCommand(assertCmd);
        if (response == null) {
            return;
        }
    }

    public String getRegionText(int x, int y, int sx, int sy, int width, int height) throws AssertionFailedError {
        GetRegionText cmd = this.factory.createGetRegionText();
        cmd.setElement(this.getElement());
        cmd.setX(x);
        cmd.setY(y);
        cmd.setSx(sx);
        cmd.setSy(sy);
        cmd.setWidth(width);
        cmd.setHeight(height);
        Response response = this.player.safeExecuteCommand(cmd);
        if (response instanceof GetTextResponse) {
            return ((GetTextResponse)response).getText();
        }
        return null;
    }
}

