/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.selectionwizard;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.direct.preferences.PreferencesUtil;
import org.eclipse.reddeer.eclipse.selectionwizard.AbstractSelectionWizardDialog;
import org.eclipse.reddeer.eclipse.selectionwizard.SelectionWizardOpenable;
import org.eclipse.reddeer.eclipse.ui.dialogs.NewWizard;
import org.eclipse.reddeer.jface.window.Openable;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.button.NoButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;

public abstract class NewMenuWizard
extends AbstractSelectionWizardDialog {
    public NewMenuWizard(String shellText, String wizardCategory, String wizardName) {
        super(shellText, wizardCategory, wizardName);
    }

    public NewMenuWizard(String shellText, String[] wizardPath) {
        super(shellText, wizardPath);
    }

    protected Openable getOpenAction() {
        return new SelectionWizardOpenable(new NewWizard(), this.wizardPath, this.matcher);
    }

    public void finish(boolean openPerspective) {
        this.finish(TimePeriod.LONG, openPerspective);
    }

    public void finish(TimePeriod timePeriod, boolean openPerspective) {
        String openAssociatedPerspective = PreferencesUtil.getOpenAssociatedPerspective();
        this.checkShell();
        this.log.info("Finish wizard");
        new FinishButton((ReferencedComposite)this).click();
        try {
            new WaitWhile((WaitCondition)new JobIsRunning(), timePeriod);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        if (!openAssociatedPerspective.equals("prompt")) {
            throw new RedDeerException("Property " + RedDeerProperties.OPEN_ASSOCIATED_PERSPECTIVE + " is set to '" + openAssociatedPerspective + "' but it should be set to 'prompt'");
        }
        new WaitUntil((WaitCondition)new ShellIsAvailable("Open Associated Perspective?"));
        if (openPerspective) {
            new PushButton("Open Perspective").click();
        } else {
            new NoButton().click();
        }
    }
}

