/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.extension.log.collector;

import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.direct.platform.Platform;
import org.eclipse.reddeer.junit.extension.log.collector.LogCollector;
import org.eclipse.reddeer.junit.extensionpoint.IBeforeTest;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class BeforesLogCollector
extends LogCollector
implements IBeforeTest {
    public static final String BEFORE_TEST_METHOD_DESCRIPTION = "Log entries collected between before class extensions (included)\nand before extensions (excluded) for a test method:";
    public static boolean hasToRun = true;

    public long getPriority() {
        return Long.MAX_VALUE;
    }

    public void runBeforeTestClass(String config, TestClass testClass) {
        Platform.getWorkbenchLog().delete();
        hasToRun = true;
    }

    public void runBeforeTest(String config, Object target, FrameworkMethod method) {
        this.processWorkbenchLog(config, method.getDeclaringClass().getSimpleName(), BEFORE_TEST_METHOD_DESCRIPTION);
        Platform.getWorkbenchLog().delete();
        hasToRun = false;
    }

    public boolean hasToRun() {
        return RedDeerProperties.LOG_COLLECTOR_ENABLED.getBooleanValue() && hasToRun && this.eclipseLogFileExists();
    }
}

