/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core.commands;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.remote.internal.proxy.core.ProxyConnection;
import org.eclipse.remote.internal.proxy.core.commands.AbstractCommand;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class ShellCommand
extends AbstractCommand<Void> {
    private final DataOutputStream out;
    private final DataInputStream in;
    private final int cmdChan;
    private final int ioChan;

    public ShellCommand(ProxyConnection conn, int cmdChan, int ioChan) {
        super(conn);
        this.out = new DataOutputStream(conn.getCommandChannel().getOutputStream());
        this.in = new DataInputStream(conn.getCommandChannel().getInputStream());
        this.cmdChan = cmdChan;
        this.ioChan = ioChan;
    }

    @Override
    public Void call() throws ProxyException {
        try {
            this.out.writeByte(1);
            this.out.writeShort(102);
            this.out.writeByte(this.cmdChan);
            this.out.writeByte(this.ioChan);
            this.out.flush();
            byte res = this.in.readByte();
            if (res != 0) {
                String errMsg = this.in.readUTF();
                throw new ProxyException(errMsg);
            }
        }
        catch (IOException e) {
            throw new ProxyException(e.getMessage());
        }
        return null;
    }
}

