/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.proxy.ui.Activator;
import org.eclipse.remote.internal.proxy.ui.messages.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class ProxyConnectionPage
extends WizardPage {
    private Text fConnectionName;
    private Button fPasswordButton;
    private Button fPublicKeyButton;
    private Button fDefaultServerButton;
    private Text fHostText;
    private Text fUserText;
    private Text fPasswordText;
    private Text fPassphraseText;
    private Text fPortText;
    private Text fTimeoutText;
    private Text fServerCommandText;
    private String fInitialName = "Remote Host";
    private Set<String> fInvalidConnectionNames;
    private final Map<String, String> fInitialAttributes = new HashMap<String, String>();
    private IRemoteConnectionWorkingCopy fConnection;
    private final IRemoteConnectionType fConnectionType;
    private final DataModifyListener fDataModifyListener = new DataModifyListener();

    public ProxyConnectionPage(IRemoteConnectionType connectionType) {
        super(Messages.ProxyNewConnectionPage_New_connection_properties);
        this.fConnectionType = connectionType;
        this.setPageComplete(false);
    }

    private void createAdvancedControls(final Composite parent) {
        ExpandableComposite expComp = new ExpandableComposite(parent, 2);
        expComp.setText(Messages.ProxyNewConnectionPage_Advanced);
        expComp.setLayoutData((Object)new GridData(4, 128, true, false));
        expComp.setExpanded(false);
        expComp.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                int i = 0;
                while (i < 2) {
                    Point newSize = parent.computeSize(-1, -1);
                    Point currentSize = parent.getSize();
                    int deltaY = newSize.y - currentSize.y;
                    Point shellSize = ProxyConnectionPage.this.getShell().getSize();
                    shellSize.y += deltaY;
                    ProxyConnectionPage.this.getShell().setSize(shellSize);
                    ProxyConnectionPage.this.getShell().layout(true, true);
                    ++i;
                }
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        Composite advancedComp = new Composite((Composite)expComp, 0);
        advancedComp.setLayout((Layout)new GridLayout(1, false));
        advancedComp.setLayoutData((Object)new GridData(4, 128, true, false));
        Group settingsComp = new Group(advancedComp, 0);
        settingsComp.setText(Messages.ProxyConnectionPage_Settings0);
        settingsComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        settingsComp.setLayout((Layout)new GridLayout(2, false));
        Label portLabel = new Label((Composite)settingsComp, 0);
        portLabel.setText(Messages.ProxyNewConnectionPage_Port);
        this.fPortText = new Text((Composite)settingsComp, 2052);
        this.fPortText.setText(Integer.toString(22));
        this.fPortText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.setTextFieldWidthInChars(this.fPortText, 5);
        Label timeoutLabel = new Label((Composite)settingsComp, 0);
        timeoutLabel.setText(Messages.ProxyNewConnectionPage_Timeout);
        this.fTimeoutText = new Text((Composite)settingsComp, 2052);
        this.fTimeoutText.setText(Integer.toString(0));
        this.fDefaultServerButton = new Button((Composite)settingsComp, 32);
        this.fDefaultServerButton.setText("Use default server");
        this.fDefaultServerButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.fDefaultServerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyConnectionPage.this.validateFields();
                ProxyConnectionPage.this.updateEnablement();
            }
        });
        Label serverLabel = new Label((Composite)settingsComp, 0);
        serverLabel.setText("Server command");
        this.fServerCommandText = new Text((Composite)settingsComp, 2052);
        this.fServerCommandText.setText("sh .eclipsesettings/proxy.sh");
        this.fServerCommandText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fDefaultServerButton.setSelection(true);
        expComp.setClient((Control)advancedComp);
    }

    private void createAuthControls(Composite parent) {
        Composite controls = new Composite(parent, 0);
        controls.setLayout((Layout)new GridLayout(3, false));
        controls.setLayoutData((Object)new GridData(4, 4, true, false));
        Label hostLabel = new Label(controls, 0);
        hostLabel.setText(Messages.ProxyNewConnectionPage_Host);
        this.fHostText = new Text(controls, 2052);
        this.fHostText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label userLabel = new Label(controls, 0);
        userLabel.setText(Messages.ProxyNewConnectionPage_User);
        this.fUserText = new Text(controls, 2052);
        this.fUserText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fPublicKeyButton = new Button(controls, 16);
        this.fPublicKeyButton.setText(Messages.ProxyNewConnectionPage_Public_key_based_authentication);
        this.fPublicKeyButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.fPublicKeyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyConnectionPage.this.validateFields();
                ProxyConnectionPage.this.updateEnablement();
            }
        });
        Link link = new Link(controls, 64);
        GridData linkLayoutData = new GridData(768);
        link.setLayoutData((Object)linkLayoutData);
        String PREFS_PAGE_ID_NET_SSH = "org.eclipse.jsch.ui.SSHPreferences";
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)ProxyConnectionPage.this.getShell(), (String)"org.eclipse.jsch.ui.SSHPreferences", (String[])new String[]{"org.eclipse.jsch.ui.SSHPreferences"}, null);
                dlg.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        link.setText(Messages.ProxyConnectionPage_KeysAtSSH2);
        Label passphraseLabel = new Label(controls, 0);
        passphraseLabel.setText(Messages.ProxyNewConnectionPage_Passphrase);
        this.fPassphraseText = new Text(controls, 0x400804);
        this.fPassphraseText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fPasswordButton = new Button(controls, 16);
        this.fPasswordButton.setText(Messages.ProxyNewConnectionPage_Password_based_authentication);
        this.fPasswordButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        this.fPasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyConnectionPage.this.validateFields();
                ProxyConnectionPage.this.updateEnablement();
            }
        });
        Label passwordLabel = new Label(controls, 0);
        passwordLabel.setText(Messages.ProxyNewConnectionPage_Password);
        this.fPasswordText = new Text(controls, 0x400804);
        this.fPasswordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fPasswordButton.setSelection(false);
        this.fPublicKeyButton.setSelection(true);
        controls.setTabList(new Control[]{this.fHostText, this.fUserText, this.fPublicKeyButton, this.fPassphraseText, this.fPasswordButton, this.fPasswordText});
    }

    public void createControl(Composite parent) {
        if (this.fConnection == null) {
            this.setDescription(Messages.ProxyNewConnectionPage_New_connection_properties);
            this.setTitle(Messages.ProxyNewConnectionPage_New_connection_properties);
            this.setMessage(Messages.ProxyConnectionPage_Initial_Message);
        } else {
            this.setDescription(Messages.ProxyConnectionPage_Edit_properties_of_an_existing_connection);
            this.setTitle(Messages.ProxyConnectionPage_Edit_Connection);
        }
        this.setErrorMessage(null);
        GridLayout topLayout = new GridLayout(2, false);
        Composite topControl = new Composite(parent, 0);
        this.setControl((Control)topControl);
        topControl.setLayout((Layout)topLayout);
        Label label = new Label(topControl, 0);
        label.setText(Messages.ProxyNewConnectionPage_Connection_name);
        this.fConnectionName = new Text(topControl, 2052);
        this.fConnectionName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fConnectionName.setEnabled(this.fConnection == null);
        Group authGroup = new Group(topControl, 0);
        authGroup.setText(Messages.ProxyNewConnectionPage_Host_information);
        authGroup.setLayout((Layout)new GridLayout(1, false));
        authGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.createAuthControls((Composite)authGroup);
        this.createAdvancedControls((Composite)authGroup);
        try {
            this.loadValues();
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
        this.registerListeners();
        if (this.fConnection != null) {
            this.validateFields();
        }
        this.updateEnablement();
    }

    public IRemoteConnectionWorkingCopy getConnection() {
        return this.fConnection;
    }

    private boolean isInvalidName(String name) {
        if (this.fConnection == null) {
            if (this.fInvalidConnectionNames == null) {
                return this.fConnectionType.getConnection(name) != null;
            }
            return this.fInvalidConnectionNames.contains(name);
        }
        return false;
    }

    private void loadValues() throws CoreException {
        IRemoteServicesManager manager = Activator.getService(IRemoteServicesManager.class);
        if (this.fConnection != null) {
            this.fConnectionName.setText(this.fConnection.getName());
            this.fHostText.setText(this.fConnection.getAttribute("PROXY_HOSTNAME__ATTR"));
            this.fUserText.setText(this.fConnection.getAttribute("PROXY_USERNAME_ATTR"));
            String portStr = this.fConnection.getAttribute("PROXY_PORT_ATTR");
            this.fPortText.setText(portStr.isEmpty() ? Integer.toString(22) : portStr);
            String timeoutStr = this.fConnection.getAttribute("PROXY_TIMEOUT_ATTR");
            this.fTimeoutText.setText(timeoutStr.isEmpty() ? Integer.toString(0) : timeoutStr);
            String isPwdStr = this.fConnection.getAttribute("PROXY_USE_PASSWORD_ATTR");
            boolean isPwd = isPwdStr.isEmpty() ? false : Boolean.parseBoolean(isPwdStr);
            this.fPasswordButton.setSelection(isPwd);
            this.fPublicKeyButton.setSelection(!isPwd);
            this.fPasswordText.setText(this.fConnection.getSecureAttribute("PROXY_PASSWORD_ATTR"));
            this.fPassphraseText.setText(this.fConnection.getSecureAttribute("PROXY_PASSPHRASE_ATTR"));
            String useDefaultServerStr = this.fConnection.getAttribute("PROXY_USE_DEFAULT_SERVER_ATTR");
            boolean useDefaultServer = useDefaultServerStr.isEmpty() ? true : Boolean.parseBoolean(useDefaultServerStr);
            this.fDefaultServerButton.setSelection(useDefaultServer);
            String serverCommandStr = this.fConnection.getAttribute("PROXY_SERVER_COMMAND_ATTR");
            this.fServerCommandText.setText(serverCommandStr.isEmpty() ? "sh .eclipsesettings/proxy.sh" : serverCommandStr);
        } else {
            String serverCommand;
            String useDefaultServer;
            String passphrase;
            String password;
            String isPwd;
            String timeout;
            String port;
            String username;
            this.fConnectionName.setText(this.fInitialName);
            String host = this.fInitialAttributes.get("PROXY_HOSTNAME__ATTR");
            if (host != null) {
                this.fHostText.setText(host);
            }
            if ((username = this.fInitialAttributes.get("PROXY_USERNAME_ATTR")) != null) {
                this.fUserText.setText(username);
            }
            if ((port = this.fInitialAttributes.get("PROXY_PORT_ATTR")) != null) {
                this.fPortText.setText(port);
            }
            if ((timeout = this.fInitialAttributes.get("PROXY_TIMEOUT_ATTR")) != null) {
                this.fTimeoutText.setText(timeout);
            }
            if ((isPwd = this.fInitialAttributes.get("PROXY_USE_PASSWORD_ATTR")) != null) {
                this.fPasswordButton.setSelection(Boolean.parseBoolean(isPwd));
            }
            if ((password = this.fInitialAttributes.get("PROXY_PASSWORD_ATTR")) != null) {
                this.fPasswordText.setText(password);
            }
            if ((passphrase = this.fInitialAttributes.get("PROXY_PASSPHRASE_ATTR")) != null) {
                this.fPassphraseText.setText(passphrase);
            }
            if ((useDefaultServer = this.fInitialAttributes.get("PROXY_USE_DEFAULT_SERVER_ATTR")) != null) {
                this.fDefaultServerButton.setSelection(Boolean.parseBoolean(useDefaultServer));
            }
            if ((serverCommand = this.fInitialAttributes.get("PROXY_SERVER_COMMAND_ATTR")) != null) {
                this.fServerCommandText.setText(serverCommand);
            }
        }
    }

    private void registerListeners() {
        this.fConnectionName.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fHostText.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fUserText.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fPasswordText.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fPassphraseText.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fPortText.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fTimeoutText.addModifyListener((ModifyListener)this.fDataModifyListener);
        this.fServerCommandText.addModifyListener((ModifyListener)this.fDataModifyListener);
    }

    public void setAddress(String address) {
        this.fInitialAttributes.put("PROXY_HOSTNAME__ATTR", address);
    }

    public void setAttributes(Map<String, String> attributes) {
        this.fInitialAttributes.putAll(attributes);
    }

    public void setConnection(IRemoteConnectionWorkingCopy connection) {
        this.fConnection = connection;
    }

    public void setConnectionName(String name) {
        this.fInitialName = name;
    }

    public void setInvalidConnectionNames(Set<String> names) {
        this.fInvalidConnectionNames = names;
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        if (complete) {
            this.storeValues();
        }
    }

    public void setPort(int port) {
        this.fInitialAttributes.put("PROXY_PORT_ATTR", Integer.toString(port));
    }

    private void setTextFieldWidthInChars(Text text, int chars) {
        text.setTextLimit(chars);
        Object data = text.getLayoutData();
        if (data instanceof GridData) {
            GC gc = new GC((Drawable)text);
            FontMetrics fm = gc.getFontMetrics();
            int width = chars * fm.getAverageCharWidth();
            gc.dispose();
            ((GridData)data).widthHint = width;
        }
    }

    public void setUsername(String username) {
        this.fInitialAttributes.put("PROXY_USERNAME_ATTR", username);
    }

    private void storeValues() {
        if (this.fConnection == null) {
            try {
                this.fConnection = this.fConnectionType.newConnection(this.fConnectionName.getText().trim());
            }
            catch (RemoteConnectionException e) {
                Activator.log(e);
            }
        }
        if (this.fConnection != null) {
            this.fConnection.setName(this.fConnectionName.getText().trim());
            this.fConnection.setAttribute("PROXY_HOSTNAME__ATTR", this.fHostText.getText().trim());
            this.fConnection.setAttribute("PROXY_USERNAME_ATTR", this.fUserText.getText().trim());
            this.fConnection.setSecureAttribute("PROXY_PASSWORD_ATTR", this.fPasswordText.getText().trim());
            this.fConnection.setSecureAttribute("PROXY_PASSPHRASE_ATTR", this.fPassphraseText.getText().trim());
            this.fConnection.setAttribute("PROXY_USE_PASSWORD_ATTR", Boolean.toString(this.fPasswordButton.getSelection()));
            this.fConnection.setAttribute("PROXY_TIMEOUT_ATTR", this.fTimeoutText.getText().trim());
            this.fConnection.setAttribute("PROXY_PORT_ATTR", this.fPortText.getText().trim());
            this.fConnection.setAttribute("PROXY_USE_DEFAULT_SERVER_ATTR", Boolean.toString(this.fDefaultServerButton.getSelection()));
            this.fConnection.setAttribute("PROXY_SERVER_COMMAND_ATTR", this.fServerCommandText.getText().trim());
        }
    }

    private void updateEnablement() {
        boolean isPasswordAuth = this.fPasswordButton.getSelection();
        this.fPasswordText.setEnabled(isPasswordAuth);
        this.fPassphraseText.setEnabled(!isPasswordAuth);
        this.fServerCommandText.setEnabled(!this.fDefaultServerButton.getSelection());
    }

    private String validateAdvanced() {
        try {
            Integer.parseInt(this.fPortText.getText().trim());
        }
        catch (NumberFormatException ne) {
            return Messages.ProxyNewConnectionPage_Port_is_not_valid;
        }
        try {
            Integer.parseInt(this.fTimeoutText.getText().trim());
        }
        catch (NumberFormatException ne) {
            return Messages.ProxyNewConnectionPage_Timeout_is_not_valid;
        }
        return null;
    }

    private void validateFields() {
        String message = null;
        if (this.fConnectionName.getText().trim().length() == 0) {
            message = Messages.ProxyNewConnectionPage_Please_enter_a_connection_name;
        } else if (this.isInvalidName(this.fConnectionName.getText().trim())) {
            message = Messages.ProxyConnectionPage_A_connection_with_that_name_already_exists;
        } else if (this.fHostText.getText().trim().length() == 0) {
            message = Messages.ProxyNewConnectionPage_Host_name_cannot_be_empty;
        } else if (this.fUserText.getText().trim().length() == 0) {
            message = Messages.ProxyNewConnectionPage_User_name_cannot_be_empty;
        } else if (!this.fDefaultServerButton.getSelection() && this.fServerCommandText.getText().trim().length() == 0) {
            message = "Server command cannot be empty";
        }
        if (message == null) {
            message = this.validateAdvanced();
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private class DataModifyListener
    implements ModifyListener {
        private DataModifyListener() {
        }

        public synchronized void modifyText(ModifyEvent e) {
            ProxyConnectionPage.this.validateFields();
            ProxyConnectionPage.this.getContainer().updateButtons();
        }
    }
}

