/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.figure;

import com.google.common.collect.Iterables;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.TransparentBorder;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.ecore.extender.business.api.permission.LockStatus;
import org.eclipse.sirius.ext.draw2d.figure.IFixedFigure;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class DiagramSemanticElementLockedNotificationFigure
extends Ellipse
implements IFixedFigure {
    public static final RGB BORDER_COLOR_LOCKED_BY_ME = new RGB(50, 205, 50);
    public static final RGB BORDER_COLOR_LOCKED_BY_OTHER = new RGB(255, 0, 0);
    private static final int DEFAULT_WIDTH = 25;
    private static final int DEFAULT_HEIGHT = 25;
    private static final ImageDescriptor LOCK_BY_ME_IMAGE_DESCRIPTOR = SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)"icons/full/decorator/permission_granted_to_current_user_exclusively.gif");
    private static final ImageDescriptor LOCK_BY_OTHER_IMAGE_DESCRIPTOR = SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)"icons/full/decorator/permission_denied.gif");
    private int transparency = 20;
    private PropertyChangeListener propListener;
    private Viewport viewport;
    private DiagramRootEditPart rootEditPart;

    public DiagramSemanticElementLockedNotificationFigure(DiagramRootEditPart rootEditPart, String message, String tooltip, LockStatus lockStatus, int height, int width) {
        Label label;
        this.rootEditPart = rootEditPart;
        this.viewport = (Viewport)rootEditPart.getFigure();
        this.setSize(width, height);
        this.setLineWidth(3);
        this.updateLocation();
        if (LockStatus.LOCKED_BY_ME.equals((Object)lockStatus)) {
            this.setForegroundColor(DiagramColorRegistry.getInstance().getColor(BORDER_COLOR_LOCKED_BY_ME));
            Image lockStatusImage = DiagramUIPlugin.getPlugin().getImage(LOCK_BY_ME_IMAGE_DESCRIPTOR);
            label = new Label(message, lockStatusImage);
        } else if (LockStatus.LOCKED_BY_OTHER.equals((Object)lockStatus)) {
            this.setForegroundColor(DiagramColorRegistry.getInstance().getColor(BORDER_COLOR_LOCKED_BY_OTHER));
            Image lockStatusImage = DiagramUIPlugin.getPlugin().getImage(LOCK_BY_OTHER_IMAGE_DESCRIPTOR);
            label = new Label(message, lockStatusImage);
        } else {
            label = new Label(message);
        }
        label.setSize(25, 25);
        this.add((IFigure)label);
        if (!StringUtil.isEmpty((String)tooltip)) {
            this.setToolTip((IFigure)new Label(tooltip));
        }
        this.propListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DiagramSemanticElementLockedNotificationFigure.this.updateLocation();
            }
        };
    }

    public DiagramSemanticElementLockedNotificationFigure(DiagramRootEditPart rootEditPart, String message, LockStatus lockStatus, int height, int width) {
        this(rootEditPart, message, "", lockStatus, height, width);
    }

    public DiagramSemanticElementLockedNotificationFigure(DiagramRootEditPart rootEditPart, String message, String tooltip, LockStatus lockStatus) {
        this(rootEditPart, message, tooltip, lockStatus, 25, 25);
    }

    public DiagramSemanticElementLockedNotificationFigure(DiagramRootEditPart rootEditPart, String message, LockStatus lockStatus) {
        this(rootEditPart, message, lockStatus, 25, 25);
    }

    public void updateLocation() {
        Point viewLocation = this.viewport.getViewLocation().getCopy();
        viewLocation.performScale(1.0 / this.rootEditPart.getZoomManager().getZoom());
        this.setLocation(new Point(viewLocation.x, viewLocation.y));
    }

    public void addNotify() {
        super.addNotify();
        this.viewport.addPropertyChangeListener("viewLocation", this.propListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.viewport.removePropertyChangeListener("viewLocation", this.propListener);
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public static void createNotification(DiagramRootEditPart rootEditPart, String message, LockStatus lockStatus) {
        DiagramSemanticElementLockedNotificationFigure.createNotification(rootEditPart, message, "", lockStatus);
    }

    public static void createNotification(DiagramRootEditPart rootEditPart, String message, String tooltip, LockStatus lockStatus) {
        LayeredPane pane = (LayeredPane)rootEditPart.getLayer((Object)"Printable Layers");
        DiagramSemanticElementLockedNotificationFigure notificationFigure = new DiagramSemanticElementLockedNotificationFigure(rootEditPart, message, tooltip, lockStatus);
        DiagramSemanticElementLockedNotificationFigure.removeNotification(rootEditPart);
        pane.add((IFigure)notificationFigure);
    }

    public static void createNotification(DiagramRootEditPart rootEditPart, String message, LockStatus lockStatus, int height, int width) {
        DiagramSemanticElementLockedNotificationFigure.createNotification(rootEditPart, message, lockStatus, height, width);
    }

    public static void createNotification(DiagramRootEditPart rootEditPart, String message, String tooltip, LockStatus lockStatus, int height, int width) {
        LayeredPane pane = (LayeredPane)rootEditPart.getLayer((Object)"Printable Layers");
        DiagramSemanticElementLockedNotificationFigure notificationFigure = new DiagramSemanticElementLockedNotificationFigure(rootEditPart, message, tooltip, lockStatus, height, width);
        DiagramSemanticElementLockedNotificationFigure.removeNotification(rootEditPart);
        pane.add((IFigure)notificationFigure);
    }

    public static void createNotification(DiagramRootEditPart rootEditPart, LockStatus lockStatus) {
        LayeredPane pane = (LayeredPane)rootEditPart.getLayer((Object)"Printable Layers");
        DiagramSemanticElementLockedNotificationFigure notificationFigure = new DiagramSemanticElementLockedNotificationFigure(rootEditPart, "", lockStatus);
        DiagramSemanticElementLockedNotificationFigure.removeNotification(rootEditPart);
        pane.add((IFigure)notificationFigure);
    }

    public static void removeNotification(DiagramRootEditPart rootEditPart) {
        LayeredPane pane = (LayeredPane)rootEditPart.getLayer((Object)"Printable Layers");
        ArrayList<DiagramSemanticElementLockedNotificationFigure> figuresToRemove = new ArrayList<DiagramSemanticElementLockedNotificationFigure>();
        for (DiagramSemanticElementLockedNotificationFigure diagramSemanticElementLockedNotificationFigure : Iterables.filter((Iterable)pane.getChildren(), DiagramSemanticElementLockedNotificationFigure.class)) {
            figuresToRemove.add(diagramSemanticElementLockedNotificationFigure);
        }
        for (IFigure iFigure : figuresToRemove) {
            pane.remove(iFigure);
        }
    }

    public void paintFigure(Graphics g) {
        this.applyTransparency(g);
        super.paintFigure(g);
        g.setAlpha(255);
    }

    public Rectangle getHandleBounds() {
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.getBorder() instanceof TransparentBorder) {
            insets = ((TransparentBorder)this.getBorder()).getTransparentInsets((IFigure)this);
        }
        return new Rectangle(this.getBounds().x + insets.left, this.getBounds().y + insets.top, this.getBounds().width - (insets.right + insets.left), this.getBounds().height - (insets.bottom + insets.top));
    }

    public int getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int transparency) {
        if (transparency != this.transparency && transparency >= 0 && transparency <= 100) {
            this.transparency = transparency;
            this.repaint();
        }
    }

    protected void applyTransparency(Graphics g) {
        g.setAlpha(255 - this.transparency * 255 / 100);
    }
}

