/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.LayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.AbstractProviderDescriptor;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.LayoutProviderDescriptor;

public final class LayoutService {
    private static List<LayoutProviderDescriptor> layoutProviders = new ArrayList<LayoutProviderDescriptor>();
    private static final String LAYOUT_PROVIDER_EXTENSION_POINT = "org.eclipse.sirius.diagram.ui.layoutProvider";
    private static final String TAG_ENGINE = "layoutProvider";

    static {
        LayoutService.parseExtensionMetadata();
    }

    private LayoutService() {
    }

    private static void parseExtensionMetadata() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(LAYOUT_PROVIDER_EXTENSION_POINT).getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    AbstractProviderDescriptor desc = LayoutService.parseEngine(configElement);
                    if (desc instanceof LayoutProviderDescriptor) {
                        layoutProviders.add((LayoutProviderDescriptor)desc);
                    }
                    ++n4;
                }
                ++n2;
            }
            Collections.sort(layoutProviders);
        }
    }

    private static AbstractProviderDescriptor parseEngine(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_ENGINE)) {
            return null;
        }
        LayoutProviderDescriptor desc = new LayoutProviderDescriptor(configElement);
        return desc;
    }

    public static LayoutProvider getProvider(IGraphicalEditPart editPart) {
        ListIterator<LayoutProviderDescriptor> iterDescriptors = layoutProviders.listIterator();
        while (iterDescriptors.hasNext()) {
            LayoutProviderDescriptor currentDescriptor = (LayoutProviderDescriptor)iterDescriptors.next();
            LayoutProvider provider = currentDescriptor.getProviderInstance();
            if (provider != null) {
                if (!provider.provides(editPart)) continue;
                return provider;
            }
            iterDescriptors.remove();
        }
        return null;
    }
}

