/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.properties;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DocumentationPropertySection
extends AbstractPropertySection {
    public static final int LABEL_WIDTH = 292;
    public static final String ICONS_PREFERENCES_HELP = "icons/help.gif";
    protected static final int SOURCE_VIEWER_DEFAULT_SIZE = 150;
    protected SourceViewer sourceViewer;
    protected CLabel nameLabel;
    protected Composite composite;
    protected EObject eObject;
    protected List<EObject> eObjectList;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.composite.setLayout((Layout)new GridLayout(3, false));
        this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, this.getLabelText(), 128);
        this.nameLabel.setLayoutData((Object)new GridData(0, 128, false, true));
        CLabel help = this.getWidgetFactory().createCLabel(this.composite, "");
        help.setImage(this.getHelpIcon());
        help.setLayoutData((Object)new GridData(0, 128, false, true));
        help.setToolTipText(this.getToolTipText());
        int styles = 2818;
        this.sourceViewer = new SourceViewer(this.composite, null, styles);
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = 150;
        layoutData.heightHint = 150;
        this.sourceViewer.getControl().setLayoutData((Object)layoutData);
        TextListener fTextListener = new TextListener();
        this.sourceViewer.addTextListener((ITextListener)fTextListener);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.nameLabel.setText(this.getLabelText());
        if (selection instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof DDiagramEditPart) {
            DDiagramEditPart ddep = (DDiagramEditPart)((StructuredSelection)selection).getFirstElement();
            this.eObject = new DRepresentationQuery((DRepresentation)((Diagram)ddep.getModel()).getElement()).getRepresentationDescriptor();
            this.eObjectList = ((IStructuredSelection)selection).toList();
        }
    }

    protected void handleTextModified() {
        String newText = this.sourceViewer.getDocument().get();
        boolean equals = this.isEqual(newText);
        if (!equals) {
            TransactionalEditingDomain editingDomain = ((SiriusDiagramEditor)this.getPart()).getEditingDomain();
            Object value = this.getFeatureValue(newText);
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        if (this.getFeatureAsText() != null) {
            this.sourceViewer.setDocument((IDocument)new Document(this.getFeatureAsText()));
        }
    }

    protected boolean isEqual(String newText) {
        return this.getFeatureAsText().equals(newText);
    }

    public EAttribute getFeature() {
        return DescriptionPackage.eINSTANCE.getDocumentedElement_Documentation();
    }

    protected String getPropertyDescription() {
        return Messages.DocumentationPropertySection_description;
    }

    protected String getToolTipText() {
        return this.getPropertyDescription();
    }

    protected String getDefaultFeatureAsText() {
        String value = "";
        if (this.eObject != null && this.eObject.eGet((EStructuralFeature)this.getFeature()) != null) {
            value = this.eObject.eGet((EStructuralFeature)this.getFeature()).toString();
        }
        return value;
    }

    protected String getFeatureAsText() {
        return this.getDefaultFeatureAsText();
    }

    protected Object getFeatureValue(String newText) {
        return newText;
    }

    protected String getDefaultLabelText() {
        return Messages.DocumentationPropertySection_defaultLabel;
    }

    protected String getLabelText() {
        return this.getDefaultLabelText();
    }

    protected void makeReadonly() {
        this.sourceViewer.setEditable(false);
    }

    protected void makeWrittable() {
        this.sourceViewer.setEditable(true);
    }

    protected Image getHelpIcon() {
        ImageDescriptor findImageDescriptor = DiagramUIPlugin.Implementation.findImageDescriptor(ICONS_PREFERENCES_HELP);
        return DiagramUIPlugin.getPlugin().getImage(findImageDescriptor);
    }

    class TextListener
    implements ITextListener {
        TextListener() {
        }

        public void textChanged(TextEvent event) {
            DocumentationPropertySection.this.handleTextModified();
        }
    }
}

