/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.dialect.command;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.Messages;

public class MoveRepresentationCommand
extends RecordingCommand {
    private Collection<DRepresentationDescriptor> repDescriptors;
    private Session session;
    private DAnalysis targetAnalysis;

    public MoveRepresentationCommand(Session session, DAnalysis targetAnalysis, Collection<DRepresentationDescriptor> movableRepDescriptors) {
        super(session.getTransactionalEditingDomain(), MessageFormat.format(Messages.MoveRepresentationCommand_label, targetAnalysis.eResource().getURI().toString()));
        this.repDescriptors = movableRepDescriptors;
        this.targetAnalysis = targetAnalysis;
        this.session = session;
    }

    protected void doExecute() {
        if (this.repDescriptors == null || this.repDescriptors.isEmpty() || this.targetAnalysis == null || this.session == null) {
            return;
        }
        for (DRepresentationDescriptor repDesriptor : this.repDescriptors) {
            ((DAnalysisSession)this.session).moveRepresentation(this.targetAnalysis, repDesriptor);
        }
    }
}

