/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.swt.tools.internal.ASTField;
import org.eclipse.swt.tools.internal.ASTItem;
import org.eclipse.swt.tools.internal.ASTMethod;
import org.eclipse.swt.tools.internal.ASTType;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.ReflectClass;

public class ASTClass
extends ASTItem
implements JNIClass {
    String sourcePath;
    MetaData metaData;
    ASTClass superclass;
    ASTField[] fields;
    ASTMethod[] methods;
    String name;
    String simpleName;
    String superclassName;
    String packageName;
    String[] imports;
    String data;
    int start;
    ASTType.TypeResolver resolver = new ASTType.TypeResolver(){

        @Override
        public String findPath(String simpleName) {
            if (simpleName.equals(ASTClass.this.simpleName)) {
                return ASTClass.this.sourcePath;
            }
            String basePath = ASTClass.this.sourcePath.substring(0, ASTClass.this.sourcePath.length() - ASTClass.this.name.length() - ".java".length());
            File file = new File(String.valueOf(basePath) + ASTClass.this.packageName.replace('.', '/') + "/" + simpleName + ".java");
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            String[] stringArray = ASTClass.this.imports;
            int n = ASTClass.this.imports.length;
            int n2 = 0;
            while (n2 < n) {
                String imp = stringArray[n2];
                file = new File(String.valueOf(basePath) + imp.replace('.', '/') + "/" + simpleName + ".java");
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
                ++n2;
            }
            return "";
        }

        @Override
        public String resolve(String simpleName) {
            if (simpleName.equals(ASTClass.this.simpleName)) {
                return String.valueOf(ASTClass.this.packageName) + "." + simpleName;
            }
            String basePath = ASTClass.this.sourcePath.substring(0, ASTClass.this.sourcePath.length() - ASTClass.this.name.length() - ".java".length());
            File file = new File(String.valueOf(basePath) + ASTClass.this.packageName.replace('.', '/') + "/" + simpleName + ".java");
            if (file.exists()) {
                return String.valueOf(ASTClass.this.packageName) + "." + simpleName;
            }
            String[] stringArray = ASTClass.this.imports;
            int n = ASTClass.this.imports.length;
            int n2 = 0;
            while (n2 < n) {
                String imp = stringArray[n2];
                file = new File(String.valueOf(basePath) + imp.replace('.', '/') + "/" + simpleName + ".java");
                if (file.exists()) {
                    return String.valueOf(imp) + "." + simpleName;
                }
                ++n2;
            }
            return simpleName;
        }
    };

    public ASTClass(String sourcePath, MetaData metaData) {
        this.sourcePath = sourcePath;
        this.metaData = metaData;
        String source = JNIGenerator.loadFile(sourcePath);
        ASTParser parser = ASTParser.newParser((int)16);
        parser.setSource(source.toCharArray());
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        TypeDeclaration type = (TypeDeclaration)unit.types().get(0);
        this.simpleName = type.getName().getIdentifier();
        this.packageName = unit.getPackage().getName().getFullyQualifiedName();
        this.name = String.valueOf(this.packageName) + "." + this.simpleName;
        this.superclassName = type.getSuperclassType() != null ? type.getSuperclassType().toString() : null;
        List imports = unit.imports();
        this.imports = new String[imports.size()];
        int count = 0;
        for (ImportDeclaration imp : imports) {
            this.imports[count++] = imp.getName().getFullyQualifiedName();
        }
        this.start = type.getStartPosition();
        Javadoc doc = type.getJavadoc();
        List tags = null;
        if (doc != null) {
            tags = doc.tags();
            for (TagElement tag : tags) {
                if (!"@jniclass".equals(tag.getTagName())) continue;
                String data = tag.fragments().get(0).toString();
                this.setMetaData(data);
                break;
            }
        }
        ArrayList<ASTField> fid = new ArrayList<ASTField>();
        FieldDeclaration[] fieldDeclarationArray = type.getFields();
        int n = fieldDeclarationArray.length;
        int data = 0;
        while (data < n) {
            FieldDeclaration field = fieldDeclarationArray[data];
            List fragments = field.fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                fid.add(new ASTField(this, field, fragment));
            }
            ++data;
        }
        this.fields = fid.toArray(new ASTField[fid.size()]);
        ArrayList<ASTMethod> mid = new ArrayList<ASTMethod>();
        MethodDeclaration[] methodDeclarationArray = type.getMethods();
        int n2 = methodDeclarationArray.length;
        n = 0;
        while (n < n2) {
            MethodDeclaration method = methodDeclarationArray[n];
            if (method.getReturnType2() != null) {
                mid.add(new ASTMethod(this, method));
            }
            ++n;
        }
        this.methods = mid.toArray(new ASTMethod[mid.size()]);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ASTClass)) {
            return false;
        }
        return ((ASTClass)obj).getName().equals(this.getName());
    }

    @Override
    public JNIField[] getDeclaredFields() {
        JNIField[] result = new JNIField[this.fields.length];
        System.arraycopy(this.fields, 0, result, 0, result.length);
        return result;
    }

    @Override
    public JNIMethod[] getDeclaredMethods() {
        JNIMethod[] result = new JNIMethod[this.methods.length];
        System.arraycopy(this.methods, 0, result, 0, result.length);
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JNIClass getSuperclass() {
        if (this.superclassName == null) {
            return new ReflectClass(Object.class);
        }
        if (this.superclass != null) {
            return this.superclass;
        }
        String sourcePath = this.resolver.findPath(this.superclassName);
        this.superclass = new ASTClass(sourcePath, this.metaData);
        return this.superclass;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getExclude() {
        return (String)this.getParam("exclude");
    }

    @Override
    public String getMetaData() {
        if (this.data != null) {
            return this.data;
        }
        String key = JNIGenerator.toC(this.getName());
        return this.metaData.getMetaData(key, "");
    }

    @Override
    public void setExclude(String str) {
        this.setParam("exclude", str);
    }

    @Override
    public void setMetaData(String value) {
        this.data = value;
    }

    public String toString() {
        return this.getName();
    }
}

