/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.bindings;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.tcf.te.launch.core.bindings.internal.LaunchConfigTypeBinding;
import org.eclipse.tcf.te.launch.core.bindings.internal.LaunchConfigTypeUnBinding;
import org.eclipse.tcf.te.launch.core.bindings.internal.OverwritableLaunchBinding;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchManagerDelegate;
import org.eclipse.tcf.te.launch.core.lm.internal.ExtensionPointManager;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ILaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;
import org.eclipse.tcf.te.runtime.extensions.ExtensionPointComparator;

public class LaunchConfigTypeBindingsManager {
    private final Map<String, LaunchConfigTypeBinding> bindings = new Hashtable<String, LaunchConfigTypeBinding>();
    private final Map<String, LaunchConfigTypeUnBinding> unBindings = new Hashtable<String, LaunchConfigTypeUnBinding>();

    public static LaunchConfigTypeBindingsManager getInstance() {
        return LazyInstanceHolder.instance;
    }

    LaunchConfigTypeBindingsManager() {
        this.loadBindingsExtensions();
    }

    public String[] getValidLaunchConfigTypes(ILaunchSelection selection) {
        HashSet<String> validLaunchTypes = new HashSet<String>();
        if (selection != null && selection.getSelectedContexts() != null && selection.getSelectedContexts().length > 0) {
            for (String launchConfigTypeId : this.bindings.keySet()) {
                if (!this.isValidLaunchConfigType(launchConfigTypeId, selection)) continue;
                validLaunchTypes.add(launchConfigTypeId);
            }
        }
        return validLaunchTypes.toArray(new String[validLaunchTypes.size()]);
    }

    public boolean isValidLaunchConfigType(String typeId, ILaunchSelection selection) {
        Assert.isNotNull((Object)typeId);
        Assert.isNotNull((Object)selection);
        LaunchConfigTypeBinding binding = this.bindings.get(typeId);
        LaunchConfigTypeUnBinding unBinding = this.unBindings.get(typeId);
        ILaunchConfigurationType launchConfigType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(typeId);
        return !(launchConfigType == null || selection.getLaunchMode() != null && !launchConfigType.supportsMode(selection.getLaunchMode()) || binding == null || binding.validate(selection) != EvaluationResult.TRUE || unBinding != null && unBinding.validate(selection) == EvaluationResult.TRUE);
    }

    public boolean isValidLaunchConfigType(String typeId, String mode, ISelectionContext context) {
        Assert.isNotNull((Object)typeId);
        Assert.isNotNull((Object)context);
        LaunchConfigTypeBinding binding = this.bindings.get(typeId);
        LaunchConfigTypeUnBinding unBinding = this.unBindings.get(typeId);
        ILaunchConfigurationType launchConfigType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(typeId);
        return !(launchConfigType == null || mode != null && !launchConfigType.supportsMode(mode) || binding == null || binding.validate(mode, context) != EvaluationResult.TRUE || unBinding != null && unBinding.validate(mode, context) == EvaluationResult.TRUE);
    }

    public ILaunchManagerDelegate getLaunchManagerDelegate(String typeId, String mode) {
        String id;
        Assert.isNotNull((Object)typeId);
        Assert.isNotNull((Object)mode);
        LaunchConfigTypeBinding binding = this.bindings.get(typeId);
        if (binding != null && (id = binding.getLaunchManagerDelegate(mode)) != null) {
            return ExtensionPointManager.getInstance().getLaunchManagerDelegate(id);
        }
        return ExtensionPointManager.getInstance().getDefaultLaunchManagerDelegate();
    }

    public String getStepGroupId(String typeId, String mode) {
        Assert.isNotNull((Object)typeId);
        Assert.isNotNull((Object)mode);
        LaunchConfigTypeBinding binding = this.bindings.get(typeId);
        if (binding != null) {
            return binding.getStepGroupId(mode);
        }
        return null;
    }

    private void loadBindingsExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.tcf.te.launch.core.launchConfigTypeBindings");
        if (point != null) {
            IExtension[] bindings = point.getExtensions();
            Arrays.sort(bindings, new ExtensionPointComparator());
            IExtension[] iExtensionArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension binding = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = binding.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (!this.loadBinding(element)) {
                        this.loadUnBinding(element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private boolean loadBinding(IConfigurationElement element) {
        IConfigurationElement[] enablements;
        IConfigurationElement[] stepGroupBindings;
        IConfigurationElement[] lmDelegateBindings;
        Assert.isNotNull((Object)element);
        if (!element.getName().equals("launchConfigTypeBinding")) {
            return false;
        }
        String launchConfigTypeId = element.getAttribute("launchConfigTypeId");
        if (!this.bindings.containsKey(launchConfigTypeId)) {
            this.bindings.put(launchConfigTypeId, new LaunchConfigTypeBinding(launchConfigTypeId));
        }
        LaunchConfigTypeBinding binding = this.bindings.get(launchConfigTypeId);
        IConfigurationElement[] iConfigurationElementArray = lmDelegateBindings = element.getChildren("launchManagerDelegate");
        int n = lmDelegateBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement lmDelegateBinding = iConfigurationElementArray[n2];
            String id = lmDelegateBinding.getAttribute("id");
            String overwrites = lmDelegateBinding.getAttribute("overwrites");
            String modes = lmDelegateBinding.getAttribute("modes");
            binding.addLaunchManagerDelegate(new OverwritableLaunchBinding(id, overwrites, modes));
            ++n2;
        }
        IConfigurationElement[] iConfigurationElementArray2 = stepGroupBindings = element.getChildren("stepGroup");
        int n3 = stepGroupBindings.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement stepGroupBinding = iConfigurationElementArray2[n];
            String id = stepGroupBinding.getAttribute("id");
            String overwrites = stepGroupBinding.getAttribute("overwrites");
            String modes = stepGroupBinding.getAttribute("modes");
            binding.addStepGroup(new OverwritableLaunchBinding(id, overwrites, modes));
            ++n;
        }
        IConfigurationElement[] iConfigurationElementArray3 = enablements = element.getChildren("enablement");
        int n4 = enablements.length;
        n3 = 0;
        while (n3 < n4) {
            Expression expression;
            block8: {
                IConfigurationElement enablement = iConfigurationElementArray3[n3];
                expression = null;
                try {
                    expression = ExpressionConverter.getDefault().perform(enablement);
                }
                catch (CoreException e) {
                    if (!Platform.inDebugMode()) break block8;
                    e.printStackTrace();
                }
            }
            if (expression != null) {
                binding.addEnablement(expression);
            }
            ++n3;
        }
        return true;
    }

    private boolean loadUnBinding(IConfigurationElement element) {
        IConfigurationElement[] enablements;
        Assert.isNotNull((Object)element);
        if (!element.getName().equals("launchConfigTypeUnBinding")) {
            return false;
        }
        String launchConfigTypeId = element.getAttribute("launchConfigTypeId");
        if (!this.unBindings.containsKey(launchConfigTypeId)) {
            this.unBindings.put(launchConfigTypeId, new LaunchConfigTypeUnBinding(launchConfigTypeId));
        }
        LaunchConfigTypeUnBinding unBinding = this.unBindings.get(launchConfigTypeId);
        IConfigurationElement[] iConfigurationElementArray = enablements = element.getChildren("enablement");
        int n = enablements.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression;
            block6: {
                IConfigurationElement enablement = iConfigurationElementArray[n2];
                expression = null;
                try {
                    expression = ExpressionConverter.getDefault().perform(enablement);
                }
                catch (CoreException e) {
                    if (!Platform.inDebugMode()) break block6;
                    e.printStackTrace();
                }
            }
            if (expression != null) {
                unBinding.addEnablement(expression);
            }
            ++n2;
        }
        return true;
    }

    private static class LazyInstanceHolder {
        public static LaunchConfigTypeBindingsManager instance = new LaunchConfigTypeBindingsManager();

        private LazyInstanceHolder() {
        }
    }
}

