/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNodeBase;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IUserAccount;

public abstract class FSTreeNodeBase
extends PlatformObject
implements IFSTreeNodeBase {
    protected abstract int getWin32Attrs();

    protected abstract int getPermissions();

    protected abstract boolean checkPermission(int var1, int var2, int var3);

    @Override
    public final boolean getWin32Attr(int attribute) {
        return (this.getWin32Attrs() & attribute) == attribute;
    }

    @Override
    public final boolean isHidden() {
        return this.getWin32Attr(2);
    }

    @Override
    public final boolean isReadOnly() {
        return this.getWin32Attr(1);
    }

    @Override
    public final boolean getPermission(int bit) {
        return (this.getPermissions() & bit) == bit;
    }

    @Override
    public final boolean isReadable() {
        return this.checkPermission(256, 32, 4);
    }

    @Override
    public final boolean isWritable() {
        return this.checkPermission(128, 16, 2);
    }

    @Override
    public final boolean isExecutable() {
        return this.checkPermission(64, 8, 1);
    }

    @Override
    public final boolean isAgentOwner() {
        IUserAccount account = this.getUserAccount();
        if (account != null) {
            return this.getUID() == account.getEUID();
        }
        return false;
    }

    @Override
    public final boolean isSystemFile() {
        if (this.isFileSystem()) {
            return false;
        }
        return this.isWindowsNode() && this.getWin32Attr(4);
    }
}

