/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.swt;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public final class SWTControlUtil {
    private static final String CHECKED = "CHECKED";
    private static final String UNCHECKED = "UNCHECKED";
    private static final String GRAYED = "GRAYED";
    private static final String ENABLED = "ENABLED";
    private static final String DISABLED = "DISABLED";

    public static final String getText(Control control) {
        if (control != null && !control.isDisposed()) {
            if (control instanceof Button) {
                return ((Button)control).getText().trim();
            }
            if (control instanceof Combo) {
                return ((Combo)control).getText().trim();
            }
            if (control instanceof Group) {
                return ((Group)control).getText().trim();
            }
            if (control instanceof Label) {
                return ((Label)control).getText().trim();
            }
            if (control instanceof CLabel) {
                return ((CLabel)control).getText().trim();
            }
            if (control instanceof Link) {
                return ((Link)control).getText().trim();
            }
            if (control instanceof Text) {
                return ((Text)control).getText().trim();
            }
            if (control instanceof Decorations) {
                return ((Decorations)control).getText();
            }
        }
        return null;
    }

    public static final void setText(Control control, String value) {
        String oldValue;
        String trimmedValue;
        if (control != null && !control.isDisposed() && !(trimmedValue = value != null ? value.trim() : "").equals(oldValue = SWTControlUtil.getText(control))) {
            if (control instanceof Button) {
                ((Button)control).setText(trimmedValue);
            }
            if (control instanceof Combo) {
                ((Combo)control).setText(trimmedValue);
            }
            if (control instanceof Group) {
                ((Group)control).setText(trimmedValue);
            }
            if (control instanceof Label) {
                ((Label)control).setText(trimmedValue);
            }
            if (control instanceof CLabel) {
                ((CLabel)control).setText(trimmedValue);
            }
            if (control instanceof Link) {
                ((Link)control).setText(trimmedValue);
            }
            if (control instanceof Text) {
                ((Text)control).setText(trimmedValue);
            }
            if (control instanceof Decorations) {
                ((Decorations)control).setText(trimmedValue);
            }
        }
    }

    public static final void setToolTipText(Control control, String value) {
        if (control != null && !control.isDisposed()) {
            control.setToolTipText(value);
        }
    }

    public static final void setValueToolTip(Scrollable control) {
        if (control != null && !control.isDisposed()) {
            String text = null;
            int resize = 0;
            if (control instanceof Text) {
                text = ((Text)control).getText().trim();
                resize = control.getBorderWidth() * 2;
            }
            if (control instanceof Combo) {
                text = ((Combo)control).getText().trim();
                resize = (int)((double)control.getSize().y * 1.5) + control.getBorderWidth() * 2;
            }
            if (text != null) {
                GC gc = new GC((Drawable)control);
                int width = 0;
                int i = 0;
                while (i < text.length()) {
                    width += gc.getAdvanceWidth(text.charAt(i));
                    ++i;
                }
                if (width > control.getClientArea().width - resize) {
                    control.setToolTipText(text);
                } else {
                    control.setToolTipText(null);
                }
                gc.dispose();
            }
        }
    }

    public static final void add(Control control, String value) {
        SWTControlUtil.add(control, value, false);
    }

    public static final void add(Control control, String value, boolean allowEmpty) {
        if (control != null && !control.isDisposed() && value != null) {
            List list;
            Combo combo;
            if (!allowEmpty && value.trim().length() == 0) {
                return;
            }
            if (control instanceof Combo && (combo = (Combo)control).indexOf(value) == -1) {
                combo.add(value);
            }
            if (control instanceof List && (list = (List)control).indexOf(value) == -1) {
                list.add(value);
            }
        }
    }

    public static final void add(Control control, String value, int index) {
        SWTControlUtil.add(control, value, index, false);
    }

    public static final void add(Control control, String value, int index, boolean allowEmpty) {
        if (control != null && !control.isDisposed() && value != null) {
            List list;
            Combo combo;
            if (!allowEmpty && value.trim().length() == 0) {
                return;
            }
            if (control instanceof Combo && (combo = (Combo)control).indexOf(value) == -1) {
                if (index < 0) {
                    index = 0;
                }
                combo.add(value, index);
            }
            if (control instanceof List && (list = (List)control).indexOf(value) == -1) {
                if (index < 0) {
                    index = 0;
                }
                list.add(value, index);
            }
        }
    }

    public static final void setEnabled(Control control, boolean enabled) {
        if (control != null && !control.isDisposed()) {
            control.setEnabled(enabled);
        }
    }

    public static final boolean isEnabled(Control control) {
        if (control != null && !control.isDisposed()) {
            return control.isEnabled();
        }
        return true;
    }

    public static final void setVisible(Control control, boolean visible) {
        if (control != null && !control.isDisposed()) {
            control.setVisible(visible);
        }
    }

    public static final boolean isVisible(Control control) {
        if (control != null && !control.isDisposed()) {
            return control.getVisible();
        }
        return true;
    }

    public static final int getItemCount(Control control) {
        if (control != null && !control.isDisposed()) {
            if (control instanceof Combo) {
                return ((Combo)control).getItemCount();
            }
            if (control instanceof List) {
                return ((List)control).getItemCount();
            }
        }
        return -1;
    }

    public static final void setItems(Control control, String[] items) {
        if (control != null && !control.isDisposed() && items != null) {
            if (control instanceof Combo) {
                ((Combo)control).setItems(items);
            } else if (control instanceof List) {
                ((List)control).setItems(items);
            }
        }
    }

    public static final String[] getItems(Control control) {
        if (control != null && !control.isDisposed()) {
            if (control instanceof Combo) {
                return ((Combo)control).getItems();
            }
            if (control instanceof List) {
                return ((List)control).getItems();
            }
        }
        return new String[0];
    }

    public static final void setItem(Control control, int index, String value) {
        String oldValue;
        String trimmedValue;
        if (control != null && !control.isDisposed() && value != null && index >= 0 && index < SWTControlUtil.getItemCount(control) && !(trimmedValue = value.trim()).equals(oldValue = SWTControlUtil.getItem(control, index))) {
            if (control instanceof Combo) {
                ((Combo)control).setItem(index, trimmedValue);
            }
            if (control instanceof List) {
                ((List)control).setItem(index, trimmedValue);
            }
        }
    }

    public static final String getItem(Control control, int index) {
        if (control != null && !control.isDisposed() && index >= 0 && index < SWTControlUtil.getItemCount(control)) {
            if (control instanceof Combo) {
                return ((Combo)control).getItem(index).trim();
            }
            if (control instanceof List) {
                return ((List)control).getItem(index).trim();
            }
        }
        return null;
    }

    public static final int getSelectionIndex(Control control) {
        if (control != null && !control.isDisposed()) {
            if (control instanceof Combo) {
                return ((Combo)control).getSelectionIndex();
            }
            if (control instanceof List) {
                return ((List)control).getSelectionIndex();
            }
            if (control instanceof Table) {
                return ((Table)control).getSelectionIndex();
            }
        }
        return -1;
    }

    public static final int getSelectionCount(Control control) {
        if (control != null && !control.isDisposed()) {
            if (control instanceof List) {
                return ((List)control).getSelectionCount();
            }
            if (control instanceof Table) {
                return ((Table)control).getSelectionCount();
            }
            if (control instanceof Tree) {
                return ((Tree)control).getSelectionCount();
            }
        }
        return -1;
    }

    public static final void removeAll(Control control) {
        if (control != null && !control.isDisposed()) {
            if (control instanceof Combo) {
                ((Combo)control).removeAll();
            }
            if (control instanceof List) {
                ((List)control).removeAll();
            }
            if (control instanceof Table) {
                ((Table)control).removeAll();
            }
            if (control instanceof Tree) {
                ((Tree)control).removeAll();
            }
        }
    }

    public static final int indexOf(Control control, String item) {
        if (control != null && !control.isDisposed() && item != null) {
            if (control instanceof Combo) {
                return ((Combo)control).indexOf(item);
            }
            if (control instanceof List) {
                return ((List)control).indexOf(item);
            }
        }
        return -1;
    }

    public static final void select(Control control, int index) {
        if (control != null && !control.isDisposed() && index >= 0 && index < SWTControlUtil.getItemCount(control)) {
            if (control instanceof Combo) {
                ((Combo)control).select(index);
            }
            if (control instanceof List) {
                ((List)control).select(index);
            }
        }
    }

    public static final boolean getSelection(Button button) {
        if (button != null && !button.isDisposed()) {
            return button.getSelection();
        }
        return false;
    }

    public static final void setSelection(Button button, boolean selected) {
        if (button != null && !button.isDisposed()) {
            button.setSelection(selected);
        }
    }

    public static int convertHeightInCharsToPixels(Control control, int chars) {
        int height = 0;
        if (control != null && !control.isDisposed()) {
            GC gc = new GC((Drawable)control);
            gc.setFont(JFaceResources.getDialogFont());
            height = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)chars);
            gc.dispose();
        }
        return height;
    }

    public static int convertWidthInCharsToPixels(Control control, int chars) {
        int width = 0;
        if (control != null && !control.isDisposed()) {
            GC gc = new GC((Drawable)control);
            gc.setFont(JFaceResources.getDialogFont());
            width = Dialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)chars);
            gc.dispose();
        }
        return width;
    }

    public static boolean setFocus(Control control) {
        if (control != null && !control.isDisposed()) {
            return control.setFocus();
        }
        return false;
    }

    public static void setForeground(Control control, Color color) {
        if (control != null && !control.isDisposed() && color != null) {
            control.setForeground(color);
        }
    }

    public static void setBackground(Control control, Color color) {
        if (control != null && !control.isDisposed() && color != null) {
            control.setBackground(color);
        }
    }

    public static void setBackgroundImage(Control control, Image image) {
        if (control != null && !control.isDisposed() && image != null) {
            control.setBackgroundImage(image);
        }
    }

    private static Image makeShot(Shell shell, boolean checked, boolean grayed, boolean enabled) {
        shell = new Shell(shell, 524296);
        Color greenScreen = new Color((Device)shell.getDisplay(), 222, 223, 224);
        shell.setBackground(greenScreen);
        Button button = new Button((Composite)shell, 32);
        button.setBackground(greenScreen);
        button.setSelection(grayed || checked);
        button.setEnabled(enabled);
        button.setGrayed(grayed);
        button.setLocation(0, 0);
        Point bsize = button.computeSize(-1, -1);
        button.setSize(bsize);
        shell.setSize(bsize);
        shell.open();
        GC gc = new GC((Drawable)shell);
        Image image = new Image((Device)shell.getDisplay(), bsize.x, bsize.y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        ImageData imageData = image.getImageData();
        imageData.transparentPixel = imageData.palette.getPixel(greenScreen.getRGB());
        image = new Image((Device)shell.getDisplay(), imageData);
        shell.close();
        return image;
    }

    public static synchronized Image getCheckBoxImage(boolean checked, boolean grayed, boolean enabled) {
        String key = String.valueOf(SWTControlUtil.class.getName()) + "_" + (checked || grayed ? CHECKED : UNCHECKED) + "_" + (grayed ? "GRAYED_" : "") + (enabled ? ENABLED : DISABLED);
        Image image = JFaceResources.getImageRegistry().get(key);
        try {
            if (image == null || image.getImageData().data == null) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                image = SWTControlUtil.makeShot(shell, checked || grayed, grayed, enabled);
                if (image.getImageData().data != null) {
                    JFaceResources.getImageRegistry().put(key, image);
                }
            }
        }
        catch (Exception exception) {}
        return image;
    }
}

