/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.tcf.te.core.interfaces.IViewerInput;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.tcf.te.ui.trees.ColumnDescriptor;
import org.eclipse.tcf.te.ui.trees.FilterDescriptor;
import org.eclipse.tcf.te.ui.trees.TreeViewerExtension;
import org.eclipse.tcf.te.ui.trees.TreeViewerState;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ViewerStateManager {
    private static volatile ViewerStateManager instance;
    private Map<String, TreeViewerState> viewerStates;

    public static ViewerStateManager getInstance() {
        if (instance == null) {
            instance = new ViewerStateManager();
        }
        return instance;
    }

    public TreeViewerState getViewerState(String inputId) {
        return this.viewerStates.get(inputId);
    }

    public FilterDescriptor[] getFilterDescriptors(String viewerId, Object input) {
        TreeViewerExtension viewerExtension;
        FilterDescriptor[] filterDescriptors;
        if (input != null && (filterDescriptors = (viewerExtension = new TreeViewerExtension(viewerId)).parseFilters(input)) != null) {
            IViewerInput viewerInput = ViewerStateManager.getViewerInput(input);
            if (viewerInput != null) {
                String inputId = viewerInput.getInputId();
                inputId = String.valueOf(viewerId) + "." + inputId;
                TreeViewerState viewerState = this.getViewerState(inputId);
                if (viewerState != null) {
                    viewerState.updateFilterDescriptor(filterDescriptors);
                }
            }
            return filterDescriptors;
        }
        return new FilterDescriptor[0];
    }

    static IViewerInput getViewerInput(Object input) {
        IViewerInput viewerInput = null;
        if (input != null) {
            if (input instanceof IViewerInput) {
                viewerInput = (IViewerInput)input;
            } else {
                if (input instanceof IAdaptable) {
                    viewerInput = (IViewerInput)((IAdaptable)input).getAdapter(IViewerInput.class);
                }
                if (viewerInput == null) {
                    viewerInput = (IViewerInput)Platform.getAdapterManager().getAdapter(input, IViewerInput.class);
                }
            }
        }
        return viewerInput;
    }

    public void putViewerState(String inputId, TreeViewerState viewerState) {
        this.viewerStates.put(inputId, viewerState);
    }

    public void loadViewerStates() {
        this.viewerStates = Collections.synchronizedMap(new HashMap());
        final File stateFile = this.getViewerStateFile();
        if (stateFile.exists()) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void handleException(Throwable e) {
                }

                public void run() throws Exception {
                    Reader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(stateFile), "UTF-8"));
                        XMLMemento root = XMLMemento.createReadRoot((Reader)reader);
                        ViewerStateManager.this.loadViewerState((IMemento)root);
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
        }
    }

    void loadViewerState(IMemento root) {
        IMemento[] children = root.getChildren("viewerState");
        if (children != null && children.length > 0) {
            IMemento[] iMementoArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                this.createViewerState(child);
                ++n2;
            }
        }
    }

    void createViewerState(IMemento mViewerState) {
        String id = mViewerState.getString("id");
        Assert.isNotNull((Object)id);
        TreeViewerState viewerState = new TreeViewerState();
        viewerState.restoreState(mViewerState);
        this.viewerStates.put(id, viewerState);
    }

    private File getViewerStateFile() {
        File location;
        try {
            location = UIPlugin.getDefault().getStateLocation().toFile();
        }
        catch (IllegalStateException illegalStateException) {
            location = new File(System.getProperty("user.home"), ".tcf");
        }
        if (!location.exists()) {
            final File dir = location;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    if (!dir.mkdir()) {
                        throw new Exception(Messages.ViewerStateManager_MkdirFailed);
                    }
                }
            });
        }
        location = new File(location, "viewerstates.xml");
        return location;
    }

    public void storeViewerStates() {
        final File stateFile = this.getViewerStateFile();
        final XMLMemento root = XMLMemento.createWriteRoot((String)"viewerStates");
        this.storeViewerStates((IMemento)root);
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void handleException(Throwable e) {
            }

            public void run() throws Exception {
                Writer writer = null;
                try {
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(stateFile), "UTF-8"));
                    root.save(writer);
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    void storeViewerStates(IMemento root) {
        for (String id : this.viewerStates.keySet()) {
            IMemento mViewerState = root.createChild("viewerState");
            mViewerState.putString("id", id);
            TreeViewerState viewerState = this.viewerStates.get(id);
            viewerState.saveState(mViewerState);
        }
    }

    public static TreeViewerState createViewerState(ColumnDescriptor[] columns, FilterDescriptor[] filters) {
        int n;
        int n2;
        Object[] objectArray;
        TreeViewerState viewerState = new TreeViewerState();
        if (columns != null) {
            objectArray = columns;
            n2 = columns.length;
            n = 0;
            while (n < n2) {
                Object column = objectArray[n];
                viewerState.addColumn((ColumnDescriptor)column);
                ++n;
            }
        }
        if (filters != null) {
            objectArray = filters;
            n2 = filters.length;
            n = 0;
            while (n < n2) {
                Object filter = objectArray[n];
                viewerState.addFilter((FilterDescriptor)filter);
                ++n;
            }
        }
        return viewerState;
    }
}

