/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Sample;
import org.eclipse.test.internal.performance.db.Variations;
import org.eclipse.test.internal.performance.eval.StatisticsSession;
import org.eclipse.test.internal.performance.eval.StatisticsUtil;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceMeter;

public abstract class InternalPerformanceMeter
extends PerformanceMeter {
    public static final int AVERAGE = -3;
    public static final int SIZE = -4;
    public static final int STDEV = -5;
    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    protected static final String VERBOSE_PERFORMANCE_METER_PROPERTY = "InternalPrintPerformanceResults";
    protected static final String CSV_PERFORMANCE_METER_PROPERTY = "InternalPrintCsvPerformanceResults";
    private static final String DUMP_PERFORMANCE_DATA_PROPERTY = "InternalWriteRawPerformanceData";
    private String fScenarioId;
    private String fShortName;
    private Dimension[] fSummaryDimensions;
    private boolean fSummaryIsGlobal;
    private int fCommentType;
    private String fComment;

    public InternalPerformanceMeter(String scenarioId) {
        this.fScenarioId = scenarioId;
    }

    @Override
    public void dispose() {
        this.fScenarioId = null;
    }

    public abstract Sample getSample();

    public String getScenarioName() {
        return this.fScenarioId;
    }

    @Override
    public void commit() {
        Sample sample = this.getSample();
        if (sample != null) {
            Object var6_10;
            File output;
            String property;
            if (this.fSummaryDimensions != null) {
                sample.tagAsSummary(this.fSummaryIsGlobal, this.fShortName, this.fSummaryDimensions, this.fCommentType, this.fComment);
            } else if (this.fComment != null) {
                sample.setComment(this.fCommentType, this.fComment);
            }
            Variations variations = PerformanceTestPlugin.getVariations();
            if (System.getProperty(VERBOSE_PERFORMANCE_METER_PROPERTY) != null) {
                this.printSample(System.out, sample);
            }
            if ((property = System.getProperty(CSV_PERFORMANCE_METER_PROPERTY)) != null) {
                output = new File(property);
                try {
                    Throwable throwable = null;
                    var6_10 = null;
                    try (PrintStream ps = new PrintStream(new FileOutputStream(output));){
                        this.printSampleCSV(ps, sample);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((property = System.getProperty(DUMP_PERFORMANCE_DATA_PROPERTY)) != null) {
                output = new File(property);
                try {
                    Throwable e = null;
                    var6_10 = null;
                    try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(output, true));){
                        oos.writeObject(this.fScenarioId);
                        oos.writeObject(variations);
                        oos.writeObject(sample);
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void printSample(PrintStream ps, Sample sample) {
        ps.print("Scenario '" + this.getScenarioName() + "' ");
        DataPoint[] dataPoints = sample.getDataPoints();
        if (dataPoints.length > 0) {
            StatisticsSession s = new StatisticsSession(dataPoints);
            Dim[] dimensions = dataPoints[0].getDimensions();
            Arrays.sort(dimensions, new DimensionComparator());
            if (dimensions.length > 0) {
                ArrayList<Dim> badDimensions = new ArrayList<Dim>();
                long n = s.getCount(dimensions[0]);
                MessageFormat format = new MessageFormat("({0,number,percent} in [{1}, {2}])");
                String spaces = "                                                                                                       ";
                ps.println("(average over " + n + " samples):");
                Dim[] dimArray = dimensions;
                int n2 = dimensions.length;
                int n3 = 0;
                while (n3 < n2) {
                    block12: {
                        StringBuffer printBuffer;
                        Dim dimension = dimArray[n3];
                        double mean = s.getAverage(dimension);
                        String nameString = "  " + dimension.getName() + ":";
                        String meanString = dimension.getDisplayValue(mean);
                        int align = this.firstNonDigit(meanString);
                        int endIndex = 30 - align - nameString.length();
                        if (endIndex > 0) {
                            meanString = String.valueOf(spaces.substring(0, endIndex)) + meanString;
                        }
                        align = nameString.length() + meanString.length();
                        StatisticsUtil.Percentile percentile = StatisticsUtil.T95;
                        double[] confidenceInterval = s.getConfidenceInterval(dimension, percentile);
                        if (n <= 2L) {
                            printBuffer = new StringBuffer(" (no confidence)");
                        } else {
                            printBuffer = new StringBuffer();
                            int ns = align;
                            while (ns++ < 40) {
                                printBuffer.append(' ');
                            }
                            printBuffer.append(format.format(new Object[]{percentile.inside(), dimension.getDisplayValue(confidenceInterval[0]), dimension.getDisplayValue(confidenceInterval[1])}));
                        }
                        align += printBuffer.length();
                        try {
                            while (align++ < 70) {
                                printBuffer.append(' ');
                            }
                            printBuffer.append(this.checkSampleSize(s, sample, dimension));
                        }
                        catch (CoreException coreException) {
                            badDimensions.add(dimension);
                            break block12;
                        }
                        ps.print(nameString);
                        ps.print(meanString);
                        ps.println(printBuffer);
                    }
                    ++n3;
                }
                if (!badDimensions.isEmpty()) {
                    ps.print("  Dimensions with unusable statistical properties: ");
                    Iterator iter = badDimensions.iterator();
                    while (iter.hasNext()) {
                        Dim dimension = (Dim)iter.next();
                        ps.print(dimension.getName());
                        if (!iter.hasNext()) continue;
                        ps.print(", ");
                    }
                    ps.println();
                }
            }
        }
        ps.println();
    }

    private String checkSampleSize(StatisticsSession s, Sample sample, Dim dimension) throws CoreException {
        String baseName;
        double base;
        long sampleSize = s.getCount(dimension);
        double stdev = s.getStddev(dimension);
        double mean = s.getAverage(dimension);
        if (stdev == 0.0) {
            return "";
        }
        double effectSize = 4.0 * Math.sqrt(stdev * stdev / (double)sampleSize);
        if (stdev > Math.abs(mean)) {
            base = stdev;
            baseName = "stdev";
        } else {
            base = Math.abs(mean);
            baseName = "mean";
        }
        double fivePercentEffect = 0.05 * base;
        long requiredSampleSizeForFivePercentEffect = Math.round(16.0 * stdev * stdev / fivePercentEffect / fivePercentEffect + 0.5);
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(1);
        numberInstance.setMinimumFractionDigits(1);
        String measurableMsg = " Measurable effect: " + dimension.getDisplayValue(effectSize) + " (" + numberInstance.format(effectSize / stdev) + " SDs)";
        if (fivePercentEffect < effectSize) {
            measurableMsg = String.valueOf(measurableMsg) + " (required sample size for an effect of 5% of " + baseName + ": " + requiredSampleSizeForFivePercentEffect + ")";
        }
        return measurableMsg;
    }

    private int firstNonDigit(String string) {
        int length = string.length();
        int i = 0;
        while (i < length) {
            if (!Character.isDigit(string.charAt(i)) && string.charAt(i) != '-' && string.charAt(i) != '.') {
                return i;
            }
            ++i;
        }
        return length;
    }

    void printSampleCSV(PrintStream ps, Sample sample) {
        DataPoint[] dataPoints = sample.getDataPoints();
        if (dataPoints.length > 0) {
            Dim[] dimensions = dataPoints[0].getDimensions();
            Arrays.sort(dimensions, new DimensionComparator());
            if (dimensions.length > 0) {
                Dim[] dimArray = dimensions;
                int n = dimensions.length;
                int n2 = 0;
                while (n2 < n) {
                    Dim dimension = dimArray[n2];
                    ps.print(dimension.getName());
                    ps.print('\t');
                    ++n2;
                }
                ps.println("scenario");
                int p = 0;
                while (p < dataPoints.length - 1) {
                    DataPoint before = dataPoints[p];
                    DataPoint after = dataPoints[p + 1];
                    Dim[] dimArray2 = dimensions;
                    int n3 = dimensions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Dim dimension = dimArray2[n4];
                        long valBefore = before.getScalar(dimension).getMagnitude();
                        long valAfter = after.getScalar(dimension).getMagnitude();
                        ps.print(valAfter - valBefore);
                        ps.print('\t');
                        ++n4;
                    }
                    ps.print(sample.getShortname() != null ? sample.getShortname() : sample.getScenarioID());
                    ps.println();
                    p += 2;
                }
                ps.println();
            }
        }
    }

    public void tagAsSummary(boolean global, String shortName, Dimension[] dims) {
        this.fSummaryIsGlobal = global;
        this.fShortName = shortName;
        this.fSummaryDimensions = dims;
    }

    public void setComment(int commentType, String comment) {
        this.fCommentType = commentType;
        this.fComment = comment;
    }

    private static class DimensionComparator
    implements Comparator<Dim> {
        private DimensionComparator() {
        }

        @Override
        public int compare(Dim o1, Dim o2) {
            return o1.getId() - o2.getId();
        }
    }
}

