/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.local.showin.detectors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tm.terminal.view.ui.local.showin.IDetectExternalExecutable;

public class DetectWSL
implements IDetectExternalExecutable {
    List<Map<String, String>> result = null;

    @Override
    public boolean hasEntries() {
        return !this.getEntries().isEmpty();
    }

    @Override
    public List<Map<String, String>> getEntries(List<Map<String, String>> externalExecutables) {
        ArrayList<Map<String, String>> newEntries = new ArrayList<Map<String, String>>();
        List<Map<String, String>> entries = this.getEntries();
        for (Map<String, String> map : entries) {
            String name = map.get("Name");
            if (!externalExecutables.stream().map(m -> (String)m.get("Name")).noneMatch(Predicate.isEqual(name))) continue;
            newEntries.add(map);
        }
        return newEntries;
    }

    private synchronized List<Map<String, String>> getEntries() {
        if (this.result == null) {
            this.result = Collections.emptyList();
            if ("win32".equals(Platform.getOS())) {
                String windir = System.getenv("windir");
                if (windir == null) {
                    return this.result;
                }
                String wsl = String.valueOf(windir) + "\\System32\\wsl.exe";
                if (!Files.isExecutable(Paths.get(wsl, new String[0]))) {
                    return this.result;
                }
                ProcessBuilder pb = new ProcessBuilder(wsl, "--list", "--quiet");
                try {
                    Process process = pb.start();
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (InputStream is = process.getErrorStream();){
                        if (is.readAllBytes().length != 0) {
                            return this.result;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    throwable = null;
                    var6_9 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_16LE));){
                        this.result = new ArrayList<Map<String, String>>();
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            String distribution = line.trim();
                            if (distribution.isBlank() || distribution.startsWith("docker-desktop")) continue;
                            String name = String.valueOf(distribution) + " (WSL)";
                            HashMap<String, String> m = new HashMap<String, String>();
                            m.put("Name", name);
                            m.put("Path", wsl);
                            m.put("Args", "--distribution " + distribution);
                            m.put("Translate", Boolean.TRUE.toString());
                            this.result.add(m);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.result;
    }
}

