/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.validators;

import com.google.inject.Inject;
import java.util.Optional;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.AnnotationExpressionValidator;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.IPatternAnnotationAdditionalValidator;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.PatternAnnotationParameter;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.PatternAnnotationValidator;
import org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.validation.IIssueCallback;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference;

public abstract class AbstractAnnotationValidator
extends PatternAnnotationValidator
implements IPatternAnnotationAdditionalValidator {
    protected static final String VALIDATOR_BASE_CODE = "org.eclipse.viatra.query.viewers.";
    public static final String GENERAL_ISSUE_CODE = "org.eclipse.viatra.query.viewers.general";
    public static final String EXPRESSION_MISMATCH_ISSUE_CODE = "org.eclipse.viatra.query.viewers.expressionmismatch";
    @Inject
    private AnnotationExpressionValidator expressionValidator;

    public AbstractAnnotationValidator(String name, String description, PatternAnnotationParameter ... parameters) {
        super(name, description, parameters);
    }

    public Optional<IPatternAnnotationAdditionalValidator> getAdditionalValidator() {
        return Optional.of(this);
    }

    public void executeAdditionalValidation(Annotation annotation, IIssueCallback validator) {
        Pattern pattern = (Pattern)annotation.eContainer();
        ValueReference labelRef = PatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"label");
        if (labelRef instanceof StringValue) {
            String value = ((StringValue)labelRef).getValue();
            this.expressionValidator.validateStringExpression(value, pattern, labelRef, validator);
        }
    }
}

