/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.wizards;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.viatra.query.patternlanguage.emf.ui.EMFPatternLanguageUIPlugin;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ClassType;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ExecutionType;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Modifiers;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Parameter;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguageFactory;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Type;
import org.eclipse.viatra.query.tooling.ui.wizards.NewVqlFileWizardContainerConfigurationPage;
import org.eclipse.viatra.query.tooling.ui.wizards.NewVqlFileWizardPatternConfigurationPage;
import org.eclipse.viatra.query.tooling.ui.wizards.internal.ObjectParameter;

public class NewVqlFileWizard
extends Wizard
implements INewWizard {
    private static final String NEW_EMF_INC_QUERY_QUERY_DEFINITION_FILE = "Create a new VIATRA Query Definition file.";
    private NewVqlFileWizardContainerConfigurationPage page1;
    private NewVqlFileWizardPatternConfigurationPage page2;
    private ISelection selection;
    private IWorkbench workbench;
    private final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
    @Inject
    private Injector injector;

    public NewVqlFileWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page1 = new NewVqlFileWizardContainerConfigurationPage();
        this.page1.init((IStructuredSelection)this.selection);
        this.page1.setDescription(NEW_EMF_INC_QUERY_QUERY_DEFINITION_FILE);
        this.page2 = new NewVqlFileWizardPatternConfigurationPage();
        this.injector.injectMembers((Object)this.page2);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        this.setForcePreviousAndNextButtons(false);
    }

    public boolean performFinish() {
        final String containerName = this.page1.getContainerName();
        final String fileName = this.page1.getFileName();
        final String packageName = this.page1.getPackageName().replaceAll("\\.", "/");
        final String patternName = this.page2.getPatternName();
        final List<EPackage> imports = this.page2.getImports();
        final List<ObjectParameter> parameters = this.page2.getParameters();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask("Creating " + fileName, 1);
                        IFile file = NewVqlFileWizard.this.createEiqFile(containerName, fileName, packageName, patternName, imports, parameters);
                        BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)NewVqlFileWizard.this.workbench.getActiveWorkbenchWindow());
                        IDE.openEditor((IWorkbenchPage)NewVqlFileWizard.this.workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)file, (boolean)true);
                        monitor.worked(1);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            EMFPatternLanguageUIPlugin.getInstance().logException("Cannot create Query Definition file: " + realException.getMessage(), realException);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
    }

    private IFile createEiqFile(String containerName, String fileName, String packageName, String patternName, List<EPackage> imports, List<ObjectParameter> parameters) throws IOException, CoreException {
        IResource containerResource = this.root.findMember((IPath)new Path(containerName));
        ResourceSet resourceSet = this.page2.getResourceSet();
        IPath filePath = containerResource.getFullPath().append(packageName).append(fileName);
        IFile file = this.root.getFile(filePath);
        String fullPath = filePath.toString();
        URI fileURI = URI.createPlatformResourceURI((String)fullPath, (boolean)false);
        Resource resource = resourceSet.createResource(fileURI);
        PatternModel pm = PatternLanguageFactory.eINSTANCE.createPatternModel();
        if (packageName != null && !packageName.isEmpty()) {
            pm.setPackageName(packageName.replace("/", "."));
        }
        pm.setImportPackages(PatternLanguageFactory.eINSTANCE.createVQLImportSection());
        for (EPackage importedPackage : imports) {
            PackageImport importDecl = PatternLanguageFactory.eINSTANCE.createPackageImport();
            importDecl.setEPackage(importedPackage);
            pm.getImportPackages().getPackageImport().add((Object)importDecl);
        }
        if (patternName != null && patternName.length() > 0) {
            Pattern pattern = PatternLanguageFactory.eINSTANCE.createPattern();
            pattern.setName(patternName);
            PatternBody body = PatternLanguageFactory.eINSTANCE.createPatternBody();
            pattern.getBodies().add((Object)body);
            Modifiers modifiers = PatternLanguageFactory.eINSTANCE.createModifiers();
            modifiers.setPrivate(false);
            modifiers.setExecution(ExecutionType.UNSPECIFIED);
            pattern.setModifiers(modifiers);
            for (ObjectParameter parameter : parameters) {
                Parameter var = PatternLanguageFactory.eINSTANCE.createParameter();
                var.setName(parameter.getParameterName());
                ClassType classType = PatternLanguageFactory.eINSTANCE.createClassType();
                classType.setClassname(parameter.getObject());
                var.setType((Type)classType);
                pattern.getParameters().add((Object)var);
            }
            pm.getPatterns().add((Object)pattern);
        }
        resource.getContents().add((Object)pm);
        resource.save(Collections.emptyMap());
        containerResource.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        return file;
    }
}

