/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PApply;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.POperation;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;

public class CompilerHelper {
    private CompilerHelper() {
    }

    private static boolean isUserSpecified(PVariable var) {
        return !var.isVirtual() && !var.getName().startsWith("_");
    }

    public static Map<PVariable, Integer> createVariableMapping(SubPlan plan) {
        HashMap<PVariable, Integer> variableMapping = new HashMap<PVariable, Integer>();
        int variableNumber = 0;
        List symbolicParameterVariables = plan.getBody().getSymbolicParameterVariables();
        for (PVariable pVariable : symbolicParameterVariables) {
            if (variableMapping.containsKey(pVariable)) continue;
            variableMapping.put(pVariable, variableNumber++);
        }
        ArrayList allVariables = new ArrayList(plan.getBody().getUniqueVariables());
        Collections.sort(allVariables, (left, right) -> {
            boolean leftUserSpecified = CompilerHelper.isUserSpecified(left);
            boolean rightUserSpecified = CompilerHelper.isUserSpecified(right);
            if (leftUserSpecified && !rightUserSpecified) {
                return -1;
            }
            if (!leftUserSpecified && rightUserSpecified) {
                return 1;
            }
            return left.getName().compareTo(right.getName());
        });
        for (PVariable pVariable : allVariables) {
            if (variableMapping.containsKey(pVariable)) continue;
            variableMapping.put(pVariable, variableNumber++);
        }
        return variableMapping;
    }

    public static Map<PConstraint, Set<Integer>> cacheVariableBindings(SubPlan plan, Map<PVariable, Integer> variableMappings, Set<PParameter> adornment) {
        Set<Integer> externallyBoundVariables = CompilerHelper.getVariableIndicesForParameters(plan, variableMappings, adornment);
        HashMap<PConstraint, Set<Integer>> variableBindings = new HashMap<PConstraint, Set<Integer>>();
        List<SubPlan> allPlansInHierarchy = CompilerHelper.getAllParentPlans(plan);
        for (SubPlan subPlan : allPlansInHierarchy) {
            POperation operation = subPlan.getOperation();
            if (!(operation instanceof PApply)) continue;
            PConstraint pConstraint = ((PApply)operation).getPConstraint();
            Set<Integer> boundVariableIndices = CompilerHelper.getParametersBoundByParentPlan(variableMappings, subPlan);
            boundVariableIndices.addAll(externallyBoundVariables);
            variableBindings.put(pConstraint, boundVariableIndices);
        }
        return variableBindings;
    }

    private static Set<Integer> getParametersBoundByParentPlan(Map<PVariable, Integer> variableMappings, SubPlan subPlan) {
        if (!subPlan.getParentPlans().isEmpty()) {
            SubPlan parentPlan = (SubPlan)subPlan.getParentPlans().get(0);
            Set enforcedConstraints = parentPlan.getAllEnforcedConstraints();
            Set<PVariable> affectedVariables = CompilerHelper.getAffectedVariables(enforcedConstraints);
            return CompilerHelper.getVariableIndices(variableMappings, affectedVariables);
        }
        return Collections.emptySet();
    }

    private static List<SubPlan> getAllParentPlans(SubPlan plan) {
        SubPlan currentPlan = plan;
        ArrayList<SubPlan> allPlans = new ArrayList<SubPlan>();
        allPlans.add(plan);
        while (!currentPlan.getParentPlans().isEmpty()) {
            currentPlan = (SubPlan)currentPlan.getParentPlans().get(0);
            allPlans.add(currentPlan);
        }
        return allPlans;
    }

    private static Set<Integer> getVariableIndices(Map<PVariable, Integer> variableMappings, Iterable<PVariable> variables) {
        HashSet<Integer> variableIndices = new HashSet<Integer>();
        for (PVariable pVariable : variables) {
            variableIndices.add(variableMappings.get(pVariable));
        }
        return variableIndices;
    }

    private static Set<PVariable> getAffectedVariables(Set<PConstraint> pConstraints) {
        HashSet<PVariable> allDeducedVariables = new HashSet<PVariable>();
        for (PConstraint pConstraint : pConstraints) {
            allDeducedVariables.addAll(pConstraint.getAffectedVariables());
        }
        return allDeducedVariables;
    }

    private static Set<Integer> getVariableIndicesForParameters(SubPlan plan, Map<PVariable, Integer> variableMappings, Set<PParameter> parameters) {
        HashMap<PParameter, PVariable> parameterMapping = new HashMap<PParameter, PVariable>();
        for (ExportedParameter constraint : plan.getBody().getSymbolicParameters()) {
            parameterMapping.put(constraint.getPatternParameter(), constraint.getParameterVariable());
        }
        HashSet<Integer> variableIndices = new HashSet<Integer>();
        for (PParameter parameter : parameters) {
            PVariable parameterVariable = (PVariable)parameterMapping.get(parameter);
            if (parameterVariable == null) {
                parameterVariable = plan.getBody().getVariableByNameChecked((Object)parameter.getName());
            }
            Integer variableIndex = variableMappings.get(parameterVariable);
            variableIndices.add(variableIndex);
        }
        return variableIndices;
    }

    public static List<POperation> createOperationsList(SubPlan plan) {
        ArrayList<POperation> operationsList = new ArrayList<POperation>();
        while (plan.getParentPlans().size() > 0) {
            SubPlan parentPlan;
            operationsList.add(plan.getOperation());
            plan = parentPlan = (SubPlan)plan.getParentPlans().get(0);
        }
        operationsList.add(plan.getOperation());
        Collections.reverse(operationsList);
        return operationsList;
    }
}

