/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.tuple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple0;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple1;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple2;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple3;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple4;
import org.eclipse.viatra.query.runtime.matchers.tuple.IModifiableTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask0;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMaskIdentity;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

public class TupleMask {
    public final int[] indices;
    public int sourceWidth;
    int[] indicesSorted;
    Boolean isNonrepeating;

    protected TupleMask(int[] indices, int sourceWidth, int[] indicesSorted, Boolean isNonrepeating) {
        this.indices = indices;
        this.sourceWidth = sourceWidth;
        this.indicesSorted = indicesSorted;
        this.isNonrepeating = isNonrepeating;
    }

    protected static TupleMask fromSelectedIndicesInternal(int[] selectedIndices, int sourceArity, int[] indicesSorted, Boolean isNonrepeating) {
        boolean identity;
        if (selectedIndices.length == 0) {
            return new TupleMask0(sourceArity);
        }
        boolean bl = identity = sourceArity == selectedIndices.length;
        if (identity) {
            int k = 0;
            while (k < sourceArity) {
                if (selectedIndices[k] != k) {
                    identity = false;
                    break;
                }
                ++k;
            }
        }
        if (identity) {
            return new TupleMaskIdentity(selectedIndices, sourceArity);
        }
        return new TupleMask(selectedIndices, sourceArity, indicesSorted, isNonrepeating);
    }

    protected static TupleMask fromSelectedMonotonicIndicesInternal(int[] selectedIndices, int sourceArity) {
        return TupleMask.fromSelectedIndicesInternal(selectedIndices, sourceArity, selectedIndices, true);
    }

    public static TupleMask linear(int size, int sourceWidth) {
        if (size == sourceWidth) {
            return new TupleMaskIdentity(sourceWidth);
        }
        int[] indices = TupleMask.constructLinearSequence(size);
        return TupleMask.fromSelectedMonotonicIndicesInternal(indices, sourceWidth);
    }

    protected static int[] constructLinearSequence(int size) {
        int[] indices = new int[size];
        int i = 0;
        while (i < size) {
            indices[i] = i;
            ++i;
        }
        return indices;
    }

    public static TupleMask identity(int size) {
        return new TupleMaskIdentity(size);
    }

    public static TupleMask empty(int sourceWidth) {
        return TupleMask.linear(0, sourceWidth);
    }

    public static TupleMask omit(int omission, int sourceWidth) {
        int size = sourceWidth - 1;
        int[] indices = new int[size];
        int i = 0;
        while (i < omission) {
            indices[i] = i;
            ++i;
        }
        i = omission;
        while (i < size) {
            indices[i] = i + 1;
            ++i;
        }
        return TupleMask.fromSelectedMonotonicIndicesInternal(indices, sourceWidth);
    }

    public static TupleMask fromKeepIndicators(boolean[] keep) {
        int size = 0;
        int k = 0;
        while (k < keep.length) {
            if (keep[k]) {
                ++size;
            }
            ++k;
        }
        if (size == keep.length) {
            return new TupleMaskIdentity(size);
        }
        int[] indices = new int[size];
        int l = 0;
        int k2 = 0;
        while (k2 < keep.length) {
            if (keep[k2]) {
                indices[l++] = k2;
            }
            ++k2;
        }
        return TupleMask.fromSelectedMonotonicIndicesInternal(indices, keep.length);
    }

    public static TupleMask fromSelectedIndices(int sourceArity, Collection<Integer> selectedIndices) {
        int[] selected = TupleMask.integersToIntArray(selectedIndices);
        return TupleMask.fromSelectedIndicesInternal(selected, sourceArity, null, null);
    }

    public static TupleMask fromSelectedIndices(int sourceArity, int[] selectedIndices) {
        return TupleMask.fromSelectedIndicesInternal(Arrays.copyOf(selectedIndices, selectedIndices.length), sourceArity, null, null);
    }

    public static TupleMask fromNonNullIndices(ITuple tuple) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int i = 0;
        while (i < tuple.getSize()) {
            if (tuple.get(i) != null) {
                indices.add(i);
            }
            ++i;
        }
        if (indices.size() == tuple.getSize()) {
            return new TupleMaskIdentity(indices.size());
        }
        return TupleMask.fromSelectedMonotonicIndicesInternal(TupleMask.integersToIntArray(indices), tuple.getSize());
    }

    public static int[] integersToIntArray(Collection<Integer> selectedIndices) {
        int[] selected = new int[selectedIndices.size()];
        int k = 0;
        for (Integer integer : selectedIndices) {
            selected[k++] = integer;
        }
        return selected;
    }

    public static TupleMask displace(int from, int to, int sourceWidth) {
        if (from == to) {
            return new TupleMaskIdentity(sourceWidth);
        }
        int[] indices = new int[sourceWidth];
        int i = 0;
        while (i < sourceWidth) {
            indices[i] = i == to ? from : (i >= from && i < to ? i + 1 : (i > to && i <= from ? i - 1 : i));
            ++i;
        }
        return TupleMask.fromSelectedIndicesInternal(indices, sourceWidth, null, true);
    }

    public static TupleMask selectSingle(int selected, int sourceWidth) {
        int[] indices = new int[]{selected};
        return TupleMask.fromSelectedMonotonicIndicesInternal(indices, sourceWidth);
    }

    public static TupleMask append(TupleMask left, TupleMask right) {
        int leftLength = left.indices.length;
        int rightLength = right.indices.length;
        int[] indices = new int[leftLength + rightLength];
        int i = 0;
        while (i < leftLength) {
            indices[i] = left.indices[i];
            ++i;
        }
        i = 0;
        while (i < rightLength) {
            indices[i + leftLength] = right.indices[i];
            ++i;
        }
        return TupleMask.fromSelectedIndicesInternal(indices, left.sourceWidth, null, null);
    }

    void ensureIndicesSorted() {
        if (this.indicesSorted == null) {
            this.indicesSorted = new int[this.indices.length];
            LinkedList<Integer> list = new LinkedList<Integer>();
            int i = 0;
            while (i < this.indices.length) {
                list.add(this.indices[i]);
                ++i;
            }
            Collections.sort(list);
            i = 0;
            for (Integer a : list) {
                this.indicesSorted[i++] = a;
            }
        }
    }

    public OptionalInt getFirstOmittedIndex() {
        this.ensureIndicesSorted();
        int column = 0;
        while (column < this.getSize() && this.indicesSorted[column] == column) {
            ++column;
        }
        if (column < this.getSourceWidth()) {
            return OptionalInt.of(column);
        }
        return OptionalInt.empty();
    }

    public Object getValue(ITuple original, int index) {
        return original.get(this.indices[index]);
    }

    public void set(IModifiableTuple tuple, int index, Object value) {
        tuple.set(this.indices[index], value);
    }

    public Tuple transform(ITuple original) {
        switch (this.indices.length) {
            case 0: {
                return FlatTuple0.INSTANCE;
            }
            case 1: {
                return new FlatTuple1(original.get(this.indices[0]));
            }
            case 2: {
                return new FlatTuple2(original.get(this.indices[0]), original.get(this.indices[1]));
            }
            case 3: {
                return new FlatTuple3(original.get(this.indices[0]), original.get(this.indices[1]), original.get(this.indices[2]));
            }
            case 4: {
                return new FlatTuple4(original.get(this.indices[0]), original.get(this.indices[1]), original.get(this.indices[2]), original.get(this.indices[3]));
            }
        }
        Object[] signature = new Object[this.indices.length];
        int i = 0;
        while (i < this.indices.length) {
            signature[i] = original.get(this.indices[i]);
            ++i;
        }
        return new FlatTuple(signature);
    }

    public boolean isNonrepeating() {
        if (this.isNonrepeating == null) {
            this.ensureIndicesSorted();
            int previous = -1;
            int i = 0;
            while (i < this.sourceWidth && previous != this.indicesSorted[i]) {
                previous = this.indicesSorted[i];
                ++i;
            }
            this.isNonrepeating = i == this.sourceWidth;
        }
        return this.isNonrepeating;
    }

    public Tuple revertFrom(ITuple masked) {
        Object[] signature = new Object[this.sourceWidth];
        int i = 0;
        while (i < this.indices.length) {
            signature[this.indices[i]] = masked.get(i);
            ++i;
        }
        return Tuples.flatTupleOf(signature);
    }

    public Tuple keepSelectedIndices(ITuple original) {
        Object[] signature = new Object[this.sourceWidth];
        int i = 0;
        while (i < this.indices.length) {
            signature[this.indices[i]] = original.get(this.indices[i]);
            ++i;
        }
        return Tuples.flatTupleOf(signature);
    }

    public <T> List<T> transform(List<T> original) {
        ArrayList<T> signature = new ArrayList<T>(this.indices.length);
        int i = 0;
        while (i < this.indices.length) {
            signature.add(original.get(this.indices[i]));
            ++i;
        }
        return signature;
    }

    public TupleMask transform(TupleMask mask) {
        int[] cascadeIndices = new int[this.indices.length];
        int i = 0;
        while (i < this.indices.length) {
            cascadeIndices[i] = mask.indices[this.indices[i]];
            ++i;
        }
        return TupleMask.fromSelectedIndicesInternal(cascadeIndices, mask.sourceWidth, null, null);
    }

    public Tuple combine(Tuple unmasked, Tuple masked, boolean useInheritance, boolean asComplementer) {
        int i;
        int combinedLength;
        int n = combinedLength = asComplementer ? this.indices.length : masked.getSize() - this.indices.length;
        if (!useInheritance) {
            combinedLength += unmasked.getSize();
        }
        Object[] combined = new Object[combinedLength];
        int cPos = 0;
        if (!useInheritance) {
            i = 0;
            while (i < unmasked.getSize()) {
                combined[cPos++] = unmasked.get(i);
                ++i;
            }
        }
        if (asComplementer) {
            i = 0;
            while (i < this.indices.length) {
                combined[cPos++] = masked.get(this.indices[i]);
                ++i;
            }
        } else {
            this.ensureIndicesSorted();
            int mPos = 0;
            int i2 = 0;
            while (i2 < masked.getSize()) {
                if (mPos < this.indicesSorted.length && i2 == this.indicesSorted[mPos]) {
                    ++mPos;
                } else {
                    combined[cPos++] = masked.get(i2);
                }
                ++i2;
            }
        }
        return useInheritance ? Tuples.leftInheritanceTupleOf(unmasked, combined) : Tuples.flatTupleOf(combined);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = this.sourceWidth;
        int[] nArray = this.indices;
        int n = this.indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            result = 31 * result + i;
            ++n2;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TupleMask other = (TupleMask)obj;
        if (this.sourceWidth != other.sourceWidth) {
            return false;
        }
        if (this.indices.length != other.indices.length) {
            return false;
        }
        int k = 0;
        while (k < this.indices.length) {
            if (this.indices[k] != other.indices[k]) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("M(" + this.sourceWidth + "->");
        int[] nArray = this.indices;
        int n = this.indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            s.append(i);
            s.append(',');
            ++n2;
        }
        s.append(')');
        return s.toString();
    }

    public int getSize() {
        return this.indices.length;
    }

    public int getSourceWidth() {
        return this.sourceWidth;
    }

    public boolean isIdentity() {
        return false;
    }

    public <T> Set<T> transformUnique(List<T> original) {
        HashSet<T> signature = new HashSet<T>();
        int i = 0;
        while (i < this.indices.length) {
            signature.add(original.get(this.indices[i]));
            ++i;
        }
        return signature;
    }

    public List<Integer> getIndicesAsList() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.indices.length);
        int i = 0;
        while (i < this.indices.length) {
            result.add(this.indices[i]);
            ++i;
        }
        return result;
    }
}

