/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.single;

import java.util.Collection;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.context.IPosetComparator;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiset;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.rete.index.MemoryIdentityIndexer;
import org.eclipse.viatra.query.runtime.rete.index.MemoryNullIndexer;
import org.eclipse.viatra.query.runtime.rete.index.ProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.network.PosetAwareReceiver;
import org.eclipse.viatra.query.runtime.rete.network.RederivableNode;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.communication.timeless.RecursiveCommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless.BehaviorChangingMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless.PosetAwareMailbox;
import org.eclipse.viatra.query.runtime.rete.single.AbstractUniquenessEnforcerNode;

public class UniquenessEnforcerNode
extends AbstractUniquenessEnforcerNode
implements RederivableNode,
PosetAwareReceiver {
    protected IMultiset<Tuple> memory = CollectionsFactory.createMultiset();
    protected IMultiset<Tuple> rederivableMemory = CollectionsFactory.createMultiset();
    protected boolean deleteRederiveEvaluation;
    protected CommunicationGroup currentGroup;
    protected final TupleMask coreMask;
    protected final TupleMask posetMask;
    protected final IPosetComparator posetComparator;

    public UniquenessEnforcerNode(ReteContainer reteContainer, int tupleWidth) {
        this(reteContainer, tupleWidth, false);
    }

    public UniquenessEnforcerNode(ReteContainer reteContainer, int tupleWidth, boolean deleteRederiveEvaluation) {
        this(reteContainer, tupleWidth, deleteRederiveEvaluation, null, null, null);
    }

    public UniquenessEnforcerNode(ReteContainer reteContainer, int tupleWidth, boolean deleteRederiveEvaluation, TupleMask coreMask, TupleMask posetMask, IPosetComparator posetComparator) {
        super(reteContainer, tupleWidth);
        reteContainer.registerClearable((Clearable)this.memory);
        reteContainer.registerClearable((Clearable)this.rederivableMemory);
        this.deleteRederiveEvaluation = deleteRederiveEvaluation;
        this.coreMask = coreMask;
        this.posetMask = posetMask;
        this.posetComparator = posetComparator;
        this.mailbox = this.instantiateMailbox();
        reteContainer.registerClearable(this.mailbox);
    }

    @Override
    public void pullInto(Collection<Tuple> collector, boolean flush) {
        for (Tuple tuple : this.memory.distinctValues()) {
            collector.add(tuple);
        }
    }

    @Override
    public Collection<Tuple> getTuples() {
        return this.memory.distinctValues();
    }

    @Override
    public boolean isInDRedMode() {
        return this.deleteRederiveEvaluation;
    }

    @Override
    public TupleMask getCoreMask() {
        return this.coreMask;
    }

    @Override
    public TupleMask getPosetMask() {
        return this.posetMask;
    }

    @Override
    public IPosetComparator getPosetComparator() {
        return this.posetComparator;
    }

    @Override
    public void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> collector, boolean flush) {
        throw new UnsupportedOperationException("Use the timely version of this node!");
    }

    @Override
    protected Mailbox instantiateMailbox() {
        if (this.coreMask != null && this.posetMask != null && this.posetComparator != null) {
            return new PosetAwareMailbox(this, this.reteContainer);
        }
        return new BehaviorChangingMailbox(this, this.reteContainer);
    }

    @Override
    public void update(Direction direction, Tuple update, Timestamp timestamp) {
        this.updateWithPosetInfo(direction, update, false);
    }

    @Override
    public void updateWithPosetInfo(Direction direction, Tuple update, boolean monotone) {
        if (this.deleteRederiveEvaluation) {
            if (this.updateWithDeleteAndRederive(direction, update, monotone)) {
                this.propagate(direction, update, Timestamp.ZERO);
            }
        } else if (this.updateDefault(direction, update)) {
            this.propagate(direction, update, Timestamp.ZERO);
        }
    }

    protected boolean updateWithDeleteAndRederive(Direction direction, Tuple update, boolean monotone) {
        boolean propagate = false;
        int memoryCount = this.memory.getCount((Object)update);
        int rederivableCount = this.rederivableMemory.getCount((Object)update);
        if (direction == Direction.INSERT) {
            if (rederivableCount != 0) {
                this.rederivableMemory.addOne((Object)update);
                if (this.rederivableMemory.isEmpty()) {
                    ((RecursiveCommunicationGroup)this.currentGroup).removeRederivable(this);
                }
            } else {
                propagate = this.memory.addOne((Object)update);
            }
        } else if (rederivableCount != 0) {
            if (memoryCount != 0) {
                this.issueError("[INTERNAL ERROR] Inconsistent state for " + update + " because it is present both in the main and re-derivable memory in the UniquenessEnforcerNode " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), null);
            }
            try {
                this.rederivableMemory.removeOne((Object)update);
            }
            catch (IllegalStateException ex) {
                this.issueError("[INTERNAL ERROR] Duplicate deletion of " + update + " was detected in UniquenessEnforcer " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), ex);
            }
            if (this.rederivableMemory.isEmpty()) {
                ((RecursiveCommunicationGroup)this.currentGroup).removeRederivable(this);
            }
        } else if (monotone) {
            propagate = this.memory.removeOne((Object)update);
        } else {
            int count = memoryCount - 1;
            if (count > 0) {
                if (this.rederivableMemory.isEmpty()) {
                    ((RecursiveCommunicationGroup)this.currentGroup).addRederivable(this);
                }
                this.rederivableMemory.addPositive((Object)update, count);
            }
            this.memory.clearAllOf((Object)update);
            propagate = true;
        }
        return propagate;
    }

    protected boolean updateDefault(Direction direction, Tuple update) {
        boolean propagate = false;
        if (direction == Direction.INSERT) {
            propagate = this.memory.addOne((Object)update);
        } else {
            try {
                propagate = this.memory.removeOne((Object)update);
            }
            catch (IllegalStateException ex) {
                propagate = false;
                this.issueError("[INTERNAL ERROR] Duplicate deletion of " + update + " was detected in " + this.getClass().getName() + " " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), ex);
            }
        }
        return propagate;
    }

    @Override
    public void rederiveOne() {
        Tuple update = (Tuple)this.rederivableMemory.iterator().next();
        int count = this.rederivableMemory.getCount((Object)update);
        this.rederivableMemory.clearAllOf((Object)update);
        this.memory.addPositive((Object)update, count);
        if (this.rederivableMemory.isEmpty()) {
            ((RecursiveCommunicationGroup)this.currentGroup).removeRederivable(this);
        }
        this.propagate(Direction.INSERT, update, Timestamp.ZERO);
    }

    @Override
    public ProjectionIndexer getNullIndexer() {
        if (this.memoryNullIndexer == null) {
            this.memoryNullIndexer = new MemoryNullIndexer(this.reteContainer, this.tupleWidth, this.memory.distinctValues(), this, this, this.specializedListeners);
            this.getCommunicationTracker().registerDependency(this, this.memoryNullIndexer);
        }
        return this.memoryNullIndexer;
    }

    @Override
    public ProjectionIndexer getIdentityIndexer() {
        if (this.memoryIdentityIndexer == null) {
            this.memoryIdentityIndexer = new MemoryIdentityIndexer(this.reteContainer, this.tupleWidth, this.memory.distinctValues(), this, this, this.specializedListeners);
            this.getCommunicationTracker().registerDependency(this, this.memoryIdentityIndexer);
        }
        return this.memoryIdentityIndexer;
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.currentGroup;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup currentGroup) {
        this.currentGroup = currentGroup;
    }
}

