/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.emf;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.base.api.DataTypeListener;
import org.eclipse.viatra.query.runtime.base.api.FeatureListener;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.InstanceListener;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.emf.EMFQueryMetaContext;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EClassUnscopedTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.context.AbstractQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContextListener;
import org.eclipse.viatra.query.runtime.matchers.context.IndexingService;
import org.eclipse.viatra.query.runtime.matchers.context.common.JavaTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.Accuracy;

public class EMFQueryRuntimeContext
extends AbstractQueryRuntimeContext {
    protected final NavigationHelper baseIndex;
    protected final Map<EClass, EnumSet<IndexingService>> indexedClasses = new HashMap<EClass, EnumSet<IndexingService>>();
    protected final Map<EDataType, EnumSet<IndexingService>> indexedDataTypes = new HashMap<EDataType, EnumSet<IndexingService>>();
    protected final Map<EStructuralFeature, EnumSet<IndexingService>> indexedFeatures = new HashMap<EStructuralFeature, EnumSet<IndexingService>>();
    protected final EMFQueryMetaContext metaContext;
    protected Logger logger;
    private EMFScope emfScope;
    private static Function<Object, Tuple> wrapUnary = Tuples::staticArityFlatTupleOf;

    public EMFQueryRuntimeContext(NavigationHelper baseIndex, Logger logger, EMFScope emfScope) {
        this.baseIndex = baseIndex;
        this.logger = logger;
        this.metaContext = new EMFQueryMetaContext(emfScope);
        this.emfScope = emfScope;
    }

    public EMFScope getEmfScope() {
        return this.emfScope;
    }

    private static <K> boolean addIndexingService(Map<K, EnumSet<IndexingService>> map, K key, IndexingService service) {
        EnumSet<IndexingService> current = map.get(key);
        if (current == null) {
            current = EnumSet.of(service);
            map.put(key, current);
            return true;
        }
        return current.add(service);
    }

    public void dispose() {
        this.indexedFeatures.clear();
        this.indexedClasses.clear();
        this.indexedDataTypes.clear();
    }

    public <V> V coalesceTraversals(Callable<V> callable) throws InvocationTargetException {
        return (V)this.baseIndex.coalesceTraversals(callable);
    }

    public boolean isCoalescing() {
        return this.baseIndex.isCoalescing();
    }

    public IQueryMetaContext getMetaContext() {
        return this.metaContext;
    }

    public void ensureIndexed(IInputKey key, IndexingService service) {
        this.ensureEnumerableKey(key);
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            this.ensureIndexed(eClass, service);
        } else if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            this.ensureIndexed(dataType, service);
        } else if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            this.ensureIndexed(feature, service);
        } else {
            this.illegalInputKey(key);
        }
    }

    protected EnumSet<IndexingService> getCurrentIndexingServiceFor(IInputKey key) {
        this.ensureEnumerableKey(key);
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            EnumSet<IndexingService> is = this.indexedClasses.get(eClass);
            return is == null ? EnumSet.noneOf(IndexingService.class) : is;
        }
        if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            EnumSet<IndexingService> is = this.indexedDataTypes.get(dataType);
            return is == null ? EnumSet.noneOf(IndexingService.class) : is;
        }
        if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            EnumSet<IndexingService> is = this.indexedFeatures.get(feature);
            return is == null ? EnumSet.noneOf(IndexingService.class) : is;
        }
        this.illegalInputKey(key);
        return EnumSet.noneOf(IndexingService.class);
    }

    public boolean isIndexed(IInputKey key, IndexingService service) {
        return this.getCurrentIndexingServiceFor(key).contains(service);
    }

    public boolean containsTuple(IInputKey key, ITuple seed) {
        this.ensureValidKey(key);
        if (key instanceof JavaTransitiveInstancesKey) {
            Class<?> instanceClass = this.forceGetWrapperInstanceClass((JavaTransitiveInstancesKey)key);
            return instanceClass != null && instanceClass.isInstance(seed.get(0));
        }
        if (key instanceof EClassUnscopedTransitiveInstancesKey) {
            EClass emfKey = (EClass)((EClassUnscopedTransitiveInstancesKey)key).getEmfKey();
            Object candidateInstance = seed.get(0);
            return candidateInstance instanceof EObject && this.baseIndex.isInstanceOfUnscoped((EObject)candidateInstance, emfKey);
        }
        this.ensureIndexed(key, IndexingService.INSTANCES);
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            Object candidateInstance = seed.get(0);
            return candidateInstance instanceof EObject && this.baseIndex.isInstanceOfScoped((EObject)candidateInstance, eClass);
        }
        if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            return this.baseIndex.isInstanceOfDatatype(seed.get(0), dataType);
        }
        if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            Object sourceCandidate = seed.get(0);
            return sourceCandidate instanceof EObject && this.baseIndex.isFeatureInstance((EObject)sourceCandidate, seed.get(1), feature);
        }
        this.illegalInputKey(key);
        return false;
    }

    private Class<?> forceGetWrapperInstanceClass(JavaTransitiveInstancesKey key) {
        Class instanceClass;
        try {
            instanceClass = key.forceGetWrapperInstanceClass();
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)("Could not load instance class for type constraint " + (String)key.getWrappedKey()), (Throwable)e);
            instanceClass = null;
        }
        return instanceClass;
    }

    public Iterable<Tuple> enumerateTuples(IInputKey key, TupleMask seedMask, ITuple seed) {
        this.ensureIndexed(key, IndexingService.INSTANCES);
        HashSet<Tuple> result = new HashSet<Tuple>();
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            if (seedMask.indices.length == 0) {
                return this.baseIndex.getAllInstances(eClass).stream().map(wrapUnary).collect(Collectors.toSet());
            }
            Object seedInstance = seedMask.getValue(seed, 0);
            if (this.containsTuple(key, seed)) {
                result.add(Tuples.staticArityFlatTupleOf((Object)seedInstance));
            }
        } else if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            if (seedMask.indices.length == 0) {
                return this.baseIndex.getDataTypeInstances(dataType).stream().map(wrapUnary).collect(Collectors.toSet());
            }
            Object seedInstance = seedMask.getValue(seed, 0);
            if (this.containsTuple(key, seed)) {
                result.add(Tuples.staticArityFlatTupleOf((Object)seedInstance));
            }
        } else if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            boolean isSourceBound = false;
            int sourceIndex = -1;
            boolean isTargetBound = false;
            int targetIndex = -1;
            int i = 0;
            while (i < seedMask.getSize()) {
                int index = seedMask.indices[i];
                if (index == 0) {
                    isSourceBound = true;
                    sourceIndex = i;
                } else if (index == 1) {
                    isTargetBound = true;
                    targetIndex = i;
                }
                ++i;
            }
            if (!isSourceBound && isTargetBound) {
                Object seedTarget = seed.get(targetIndex);
                Set results = this.baseIndex.findByFeatureValue(seedTarget, feature);
                return results.stream().map(obj -> Tuples.staticArityFlatTupleOf((Object)obj, (Object)seedTarget)).collect(Collectors.toSet());
            }
            if (isSourceBound && isTargetBound) {
                Object seedSource = seed.get(sourceIndex);
                Object seedTarget = seed.get(targetIndex);
                if (this.containsTuple(key, seed)) {
                    result.add(Tuples.staticArityFlatTupleOf((Object)seedSource, (Object)seedTarget));
                }
            } else if (!isSourceBound && !isTargetBound) {
                this.baseIndex.processAllFeatureInstances(feature, (source, target) -> {
                    boolean bl = result.add(Tuples.staticArityFlatTupleOf((Object)source, (Object)target));
                });
            } else if (isSourceBound && !isTargetBound) {
                Object seedSource = seed.get(sourceIndex);
                Set results = this.baseIndex.getFeatureTargets((EObject)seedSource, feature);
                return results.stream().map(obj -> Tuples.staticArityFlatTupleOf((Object)seedSource, (Object)obj)).collect(Collectors.toSet());
            }
        } else {
            this.illegalInputKey(key);
        }
        return result;
    }

    public Iterable<? extends Object> enumerateValues(IInputKey key, TupleMask seedMask, ITuple seed) {
        this.ensureIndexed(key, IndexingService.INSTANCES);
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            if (seedMask.indices.length == 0) {
                return this.baseIndex.getAllInstances(eClass);
            }
            this.illegalEnumerateValues(seed.toImmutable());
        } else if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            if (seedMask.indices.length == 0) {
                return this.baseIndex.getDataTypeInstances(dataType);
            }
            this.illegalEnumerateValues(seed.toImmutable());
        } else if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            boolean isSourceBound = false;
            int sourceIndex = -1;
            boolean isTargetBound = false;
            int targetIndex = -1;
            int i = 0;
            while (i < seedMask.getSize()) {
                int index = seedMask.indices[i];
                if (index == 0) {
                    isSourceBound = true;
                    sourceIndex = i;
                } else if (index == 1) {
                    isTargetBound = true;
                    targetIndex = i;
                }
                ++i;
            }
            if (!isSourceBound && isTargetBound) {
                Object seedTarget = seed.get(targetIndex);
                return this.baseIndex.findByFeatureValue(seedTarget, feature);
            }
            if (isSourceBound && !isTargetBound) {
                Object seedSource = seed.get(sourceIndex);
                return this.baseIndex.getFeatureTargets((EObject)seedSource, feature);
            }
            this.illegalEnumerateValues(seed.toImmutable());
        } else {
            this.illegalInputKey(key);
        }
        return null;
    }

    public int countTuples(IInputKey key, TupleMask seedMask, ITuple seed) {
        this.ensureIndexed(key, IndexingService.STATISTICS);
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            if (seedMask.indices.length == 0) {
                return this.baseIndex.countAllInstances(eClass);
            }
            return this.containsTuple(key, seed) ? 1 : 0;
        }
        if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            if (seedMask.indices.length == 0) {
                return this.baseIndex.countDataTypeInstances(dataType);
            }
            return this.containsTuple(key, seed) ? 1 : 0;
        }
        if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            boolean isSourceBound = false;
            int sourceIndex = -1;
            boolean isTargetBound = false;
            int targetIndex = -1;
            int i = 0;
            while (i < seedMask.getSize()) {
                int index = seedMask.indices[i];
                if (index == 0) {
                    isSourceBound = true;
                    sourceIndex = i;
                } else if (index == 1) {
                    isTargetBound = true;
                    targetIndex = i;
                }
                ++i;
            }
            if (!isSourceBound && isTargetBound) {
                Object seedTarget = seed.get(targetIndex);
                return this.baseIndex.findByFeatureValue(seedTarget, feature).size();
            }
            if (isSourceBound && isTargetBound) {
                return this.containsTuple(key, seed) ? 1 : 0;
            }
            if (!isSourceBound && !isTargetBound) {
                return this.baseIndex.countFeatures(feature);
            }
            if (isSourceBound && !isTargetBound) {
                Object seedSource = seed.get(sourceIndex);
                return this.baseIndex.countFeatureTargets((EObject)seedSource, feature);
            }
        } else {
            this.illegalInputKey(key);
        }
        return 0;
    }

    public Optional<Long> estimateCardinality(IInputKey key, TupleMask groupMask, Accuracy requiredAccuracy) {
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            if (this.isIndexed(key, IndexingService.STATISTICS)) {
                if (groupMask.indices.length == 0) {
                    return this.baseIndex.countAllInstances(eClass) != 0 ? Optional.of(1L) : Optional.of(0L);
                }
                return Optional.of(Long.valueOf(this.baseIndex.countAllInstances(eClass)));
            }
            return Optional.empty();
        }
        if (key instanceof EClassUnscopedTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassUnscopedTransitiveInstancesKey)key).getEmfKey();
            if (Accuracy.BEST_LOWER_BOUND.atLeastAsPreciseAs(requiredAccuracy)) {
                return this.estimateCardinality((IInputKey)new EClassTransitiveInstancesKey(eClass), groupMask, requiredAccuracy);
            }
            return Optional.empty();
        }
        if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            if (this.isIndexed(key, IndexingService.STATISTICS)) {
                if (groupMask.indices.length == 0) {
                    return this.baseIndex.countDataTypeInstances(dataType) != 0 ? Optional.of(1L) : Optional.of(0L);
                }
                return Optional.of(Long.valueOf(this.baseIndex.countDataTypeInstances(dataType)));
            }
            return Optional.empty();
        }
        if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeatureInstancesKey featureKey = (EStructuralFeatureInstancesKey)key;
            EStructuralFeature feature = (EStructuralFeature)featureKey.getEmfKey();
            boolean isSourceSelected = false;
            boolean isTargetSelected = false;
            int i = 0;
            while (i < groupMask.getSize()) {
                int index = groupMask.indices[i];
                if (index == 0) {
                    isSourceSelected = true;
                } else if (index == 1) {
                    isTargetSelected = true;
                }
                ++i;
            }
            Optional<Long> sourceTypeUpperEstimate = this.estimateCardinality((IInputKey)this.metaContext.getSourceTypeKey(featureKey), TupleMask.identity((int)1), Accuracy.BEST_UPPER_BOUND);
            Optional<Long> targetTypeUpperEstimate = this.estimateCardinality(this.metaContext.getTargetTypeKey(featureKey), TupleMask.identity((int)1), Accuracy.BEST_UPPER_BOUND);
            if (!isSourceSelected && !isTargetSelected) {
                if (this.isIndexed(key, IndexingService.STATISTICS)) {
                    return this.baseIndex.countFeatures(feature) == 0 ? Optional.of(0L) : Optional.of(1L);
                }
                if (0L == sourceTypeUpperEstimate.orElse(-1L)) {
                    return Optional.of(0L);
                }
                if (0L == targetTypeUpperEstimate.orElse(-1L)) {
                    return Optional.of(0L);
                }
                return Optional.empty();
            }
            if (isSourceSelected && !isTargetSelected) {
                if (this.isIndexed(key, IndexingService.INSTANCES)) {
                    return Optional.of(Long.valueOf(this.baseIndex.getHoldersOfFeature(feature).size()));
                }
                if (this.metaContext.isFeatureMultiplicityToOne(feature) && this.isIndexed(key, IndexingService.STATISTICS)) {
                    return Optional.of(Long.valueOf(this.baseIndex.countFeatures(feature)));
                }
                if (Accuracy.BEST_UPPER_BOUND.atLeastAsPreciseAs(requiredAccuracy)) {
                    Optional<Long> estimate = sourceTypeUpperEstimate;
                    if (this.isIndexed(key, IndexingService.STATISTICS)) {
                        estimate = Optional.of(Math.min((long)this.baseIndex.countFeatures(feature), estimate.orElse(Long.MAX_VALUE)));
                    }
                    return estimate;
                }
                return Optional.empty();
            }
            if (!isSourceSelected) {
                if (this.isIndexed(key, IndexingService.INSTANCES)) {
                    return Optional.of(Long.valueOf(this.baseIndex.getValuesOfFeature(feature).size()));
                }
                if (this.metaContext.isFeatureMultiplicityOneTo(feature) && this.isIndexed(key, IndexingService.STATISTICS)) {
                    return Optional.of(Long.valueOf(this.baseIndex.countFeatures(feature)));
                }
                if (Accuracy.BEST_UPPER_BOUND.atLeastAsPreciseAs(requiredAccuracy)) {
                    Optional<Long> estimate = targetTypeUpperEstimate;
                    if (this.isIndexed(key, IndexingService.STATISTICS)) {
                        estimate = Optional.of(Math.min((long)this.baseIndex.countFeatures(feature), estimate.orElse(Long.MAX_VALUE)));
                    }
                    return estimate;
                }
                return Optional.empty();
            }
            if (this.isIndexed(key, IndexingService.STATISTICS)) {
                return Optional.of(Long.valueOf(this.baseIndex.countFeatures(feature)));
            }
            if (Accuracy.BEST_UPPER_BOUND.atLeastAsPreciseAs(requiredAccuracy)) {
                Optional<Long> estimate;
                Optional<Long> optional = estimate = sourceTypeUpperEstimate.isPresent() && targetTypeUpperEstimate.isPresent() ? Optional.of(sourceTypeUpperEstimate.get() * targetTypeUpperEstimate.get()) : Optional.empty();
                if (this.metaContext.isFeatureMultiplicityToOne(feature) && sourceTypeUpperEstimate.isPresent()) {
                    estimate = Optional.of(Math.min(sourceTypeUpperEstimate.get(), estimate.orElse(Long.MAX_VALUE)));
                }
                if (this.metaContext.isFeatureMultiplicityOneTo(feature) && targetTypeUpperEstimate.isPresent()) {
                    estimate = Optional.of(Math.min(targetTypeUpperEstimate.get(), estimate.orElse(Long.MAX_VALUE)));
                }
                return estimate;
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public Optional<Double> estimateAverageBucketSize(IInputKey key, TupleMask groupMask, Accuracy requiredAccuracy) {
        if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeatureInstancesKey featureKey = (EStructuralFeatureInstancesKey)key;
            EStructuralFeature feature = (EStructuralFeature)featureKey.getEmfKey();
            if (1 == groupMask.getSize()) {
                if (groupMask.indices[0] == 0 && this.metaContext.isFeatureMultiplicityToOne(feature)) {
                    return Optional.of(1.0);
                }
                if (1 == groupMask.indices[0] && this.metaContext.isFeatureMultiplicityOneTo(feature)) {
                    return Optional.of(1.0);
                }
            }
        }
        return super.estimateAverageBucketSize(key, groupMask, requiredAccuracy);
    }

    public void ensureEnumerableKey(IInputKey key) {
        this.ensureValidKey(key);
        if (!this.metaContext.isEnumerable(key)) {
            throw new IllegalArgumentException("Key is not enumerable: " + key);
        }
    }

    public void ensureValidKey(IInputKey key) {
        this.metaContext.ensureValidKey(key);
    }

    public void illegalInputKey(IInputKey key) {
        this.metaContext.illegalInputKey(key);
    }

    public void illegalEnumerateValues(Tuple seed) {
        throw new IllegalArgumentException("Must have exactly one unseeded element in enumerateValues() invocation, received instead: " + seed);
    }

    public void ensureIndexed(EClass eClass, IndexingService service) {
        if (EMFQueryRuntimeContext.addIndexingService(this.indexedClasses, eClass, service)) {
            Set<EClass> newClasses = Collections.singleton(eClass);
            IndexingLevel level = IndexingLevel.toLevel((IndexingService)service);
            if (!this.baseIndex.getIndexingLevel(eClass).providesLevel(level)) {
                this.baseIndex.registerEClasses(newClasses, level);
            }
        }
    }

    public void ensureIndexed(EDataType eDataType, IndexingService service) {
        if (EMFQueryRuntimeContext.addIndexingService(this.indexedDataTypes, eDataType, service)) {
            Set<EDataType> newDataTypes = Collections.singleton(eDataType);
            IndexingLevel level = IndexingLevel.toLevel((IndexingService)service);
            if (!this.baseIndex.getIndexingLevel(eDataType).providesLevel(level)) {
                this.baseIndex.registerEDataTypes(newDataTypes, level);
            }
        }
    }

    public void ensureIndexed(EStructuralFeature feature, IndexingService service) {
        if (EMFQueryRuntimeContext.addIndexingService(this.indexedFeatures, feature, service)) {
            Set<EStructuralFeature> newFeatures = Collections.singleton(feature);
            IndexingLevel level = IndexingLevel.toLevel((IndexingService)service);
            if (!this.baseIndex.getIndexingLevel(feature).providesLevel(level)) {
                this.baseIndex.registerEStructuralFeatures(newFeatures, level);
            }
        }
    }

    public void addUpdateListener(IInputKey key, Tuple seed, IQueryRuntimeContextListener listener) {
        if (key instanceof JavaTransitiveInstancesKey) {
            return;
        }
        this.ensureIndexed(key, IndexingService.INSTANCES);
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            this.baseIndex.addInstanceListener(Collections.singleton(eClass), (InstanceListener)new EClassTransitiveInstancesAdapter(listener, seed.get(0)));
        } else if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            this.baseIndex.addDataTypeListener(Collections.singleton(dataType), (DataTypeListener)new EDataTypeInSlotsAdapter(listener, seed.get(0)));
        } else if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            this.baseIndex.addFeatureListener(Collections.singleton(feature), (FeatureListener)new EStructuralFeatureInstancesKeyAdapter(listener, seed.get(0), seed.get(1)));
        } else {
            this.illegalInputKey(key);
        }
    }

    public void removeUpdateListener(IInputKey key, Tuple seed, IQueryRuntimeContextListener listener) {
        if (key instanceof JavaTransitiveInstancesKey) {
            return;
        }
        this.ensureIndexed(key, IndexingService.INSTANCES);
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            this.baseIndex.removeInstanceListener(Collections.singleton(eClass), (InstanceListener)new EClassTransitiveInstancesAdapter(listener, seed.get(0)));
        } else if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            this.baseIndex.removeDataTypeListener(Collections.singleton(dataType), (DataTypeListener)new EDataTypeInSlotsAdapter(listener, seed.get(0)));
        } else if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            this.baseIndex.removeFeatureListener(Collections.singleton(feature), (FeatureListener)new EStructuralFeatureInstancesKeyAdapter(listener, seed.get(0), seed.get(1)));
        } else {
            this.illegalInputKey(key);
        }
    }

    public Object unwrapElement(Object internalElement) {
        return internalElement;
    }

    public Tuple unwrapTuple(Tuple internalElements) {
        return internalElements;
    }

    public Object wrapElement(Object externalElement) {
        return externalElement;
    }

    public Tuple wrapTuple(Tuple externalElements) {
        return externalElements;
    }

    public void ensureWildcardIndexing(IndexingService service) {
        this.baseIndex.setWildcardLevel(IndexingLevel.toLevel((IndexingService)service));
    }

    public void executeAfterTraversal(Runnable runnable) throws InvocationTargetException {
        this.baseIndex.executeAfterTraversal(runnable);
    }

    private static class EClassTransitiveInstancesAdapter
    extends ListenerAdapter
    implements InstanceListener {
        private Object seedInstance;

        public EClassTransitiveInstancesAdapter(IQueryRuntimeContextListener listener, Object seedInstance) {
            super(listener, seedInstance);
            this.seedInstance = seedInstance;
        }

        public void instanceInserted(EClass clazz, EObject instance) {
            if (this.seedInstance != null && !this.seedInstance.equals(instance)) {
                return;
            }
            this.listener.update((IInputKey)new EClassTransitiveInstancesKey(clazz), Tuples.staticArityFlatTupleOf((Object)instance), true);
        }

        public void instanceDeleted(EClass clazz, EObject instance) {
            if (this.seedInstance != null && !this.seedInstance.equals(instance)) {
                return;
            }
            this.listener.update((IInputKey)new EClassTransitiveInstancesKey(clazz), Tuples.staticArityFlatTupleOf((Object)instance), false);
        }
    }

    private static class EDataTypeInSlotsAdapter
    extends ListenerAdapter
    implements DataTypeListener {
        private Object seedValue;

        public EDataTypeInSlotsAdapter(IQueryRuntimeContextListener listener, Object seedValue) {
            super(listener, seedValue);
            this.seedValue = seedValue;
        }

        public void dataTypeInstanceInserted(EDataType type, Object instance, boolean firstOccurrence) {
            if (firstOccurrence) {
                if (this.seedValue != null && !this.seedValue.equals(instance)) {
                    return;
                }
                this.listener.update((IInputKey)new EDataTypeInSlotsKey(type), Tuples.staticArityFlatTupleOf((Object)instance), true);
            }
        }

        public void dataTypeInstanceDeleted(EDataType type, Object instance, boolean lastOccurrence) {
            if (lastOccurrence) {
                if (this.seedValue != null && !this.seedValue.equals(instance)) {
                    return;
                }
                this.listener.update((IInputKey)new EDataTypeInSlotsKey(type), Tuples.staticArityFlatTupleOf((Object)instance), false);
            }
        }
    }

    private static class EStructuralFeatureInstancesKeyAdapter
    extends ListenerAdapter
    implements FeatureListener {
        private Object seedHost;
        private Object seedValue;

        public EStructuralFeatureInstancesKeyAdapter(IQueryRuntimeContextListener listener, Object seedHost, Object seedValue) {
            super(listener, seedHost, seedValue);
            this.seedHost = seedHost;
            this.seedValue = seedValue;
        }

        public void featureInserted(EObject host, EStructuralFeature feature, Object value) {
            if (this.seedHost != null && !this.seedHost.equals(host)) {
                return;
            }
            if (this.seedValue != null && !this.seedValue.equals(value)) {
                return;
            }
            this.listener.update((IInputKey)new EStructuralFeatureInstancesKey(feature), Tuples.staticArityFlatTupleOf((Object)host, (Object)value), true);
        }

        public void featureDeleted(EObject host, EStructuralFeature feature, Object value) {
            if (this.seedHost != null && !this.seedHost.equals(host)) {
                return;
            }
            if (this.seedValue != null && !this.seedValue.equals(value)) {
                return;
            }
            this.listener.update((IInputKey)new EStructuralFeatureInstancesKey(feature), Tuples.staticArityFlatTupleOf((Object)host, (Object)value), false);
        }
    }

    private static abstract class ListenerAdapter {
        IQueryRuntimeContextListener listener;
        Tuple seed;

        public ListenerAdapter(IQueryRuntimeContextListener listener, Object ... seed) {
            this.listener = listener;
            this.seed = Tuples.flatTupleOf((Object[])seed);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
            result = 31 * result + (this.seed == null ? 0 : this.seed.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            ListenerAdapter other = (ListenerAdapter)obj;
            if (this.listener == null ? other.listener != null : !this.listener.equals(other.listener)) {
                return false;
            }
            return !(this.seed == null ? other.seed != null : !this.seed.equals((Object)other.seed));
        }

        public String toString() {
            return "Wrapped<Seed:" + this.seed + ">#" + this.listener;
        }
    }
}

