/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.IPlanNode;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.OperationStatus;

public abstract class AbstractPlanNode
implements IPlanNode {
    final List<IPlanNode> children = new ArrayList<IPlanNode>();
    final Map<Object, IPlanNode> indexedChildren = new HashMap<Object, IPlanNode>();
    final IPlanNode parent;
    private OperationStatus operationStatus;
    private boolean breakpointSet;

    public AbstractPlanNode(IPlanNode parent) {
        this.parent = parent;
        this.operationStatus = OperationStatus.QUEUED;
        this.breakpointSet = false;
    }

    @Override
    public OperationStatus getOperationStatus() {
        return this.operationStatus;
    }

    @Override
    public void setOperationStatus(OperationStatus operationStatus) {
        if (operationStatus == OperationStatus.EXECUTED) {
            this.children.forEach(child -> child.setOperationStatus(OperationStatus.EXECUTED));
        }
        this.operationStatus = operationStatus;
    }

    @Override
    public boolean isBreakpointSet() {
        return this.breakpointSet;
    }

    @Override
    public void toggleBreakpoint(boolean breakpointSet) {
        this.breakpointSet = breakpointSet;
    }

    @Override
    public List<IPlanNode> getChildren() {
        return this.children;
    }

    @Override
    public IPlanNode getParent() {
        return this.parent;
    }

    @Override
    public void addChild(Object key, IPlanNode child) {
        this.children.add(child);
        this.indexedChildren.put(key, child);
    }

    @Override
    public IPlanNode getChildByKey(Object key) {
        return this.indexedChildren.get(key);
    }
}

