/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Objects;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.core.IType;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.transformation.debug.communication.IDebuggerHostAgent;
import org.eclipse.viatra.transformation.debug.communication.IDebuggerHostAgentListener;
import org.eclipse.viatra.transformation.debug.model.TransformationDebugElement;
import org.eclipse.viatra.transformation.debug.model.TransformationDebugTarget;
import org.eclipse.viatra.transformation.debug.model.TransformationStackFrame;
import org.eclipse.viatra.transformation.debug.model.TransformationThreadFactory;
import org.eclipse.viatra.transformation.debug.model.breakpoint.ITransformationBreakpoint;
import org.eclipse.viatra.transformation.debug.model.transformationstate.RuleActivation;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationModelProvider;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationState;

public class TransformationThread
extends TransformationDebugElement
implements IThread,
IDebuggerHostAgentListener,
IBreakpointListener {
    private static final String CONNECTING_DECORATOR_STRING = " connecting...";
    private String name = "Model Transformation Debugger Session";
    private boolean stepping = false;
    private boolean suspended = true;
    private boolean terminated = false;
    private boolean connecting = false;
    private final TransformationModelProvider modelProvider;
    private IType transformationClass;
    private TransformationState state;
    private IDebuggerHostAgent agent;
    private IStackFrame[] frames = new IStackFrame[0];

    protected TransformationThread(IDebuggerHostAgent agent, TransformationDebugTarget target, IType transformationClass) {
        super(target);
        IBreakpoint[] transfBreakpoints;
        this.modelProvider = new TransformationModelProvider(agent);
        this.transformationClass = Objects.requireNonNull(transformationClass, "Transformation Class must not be null.");
        this.agent = agent;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        agent.registerDebuggerHostAgentListener((IDebuggerHostAgentListener)this);
        IBreakpoint[] iBreakpointArray = transfBreakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.viatra.transformation.debug.model");
        int n = transfBreakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint iBreakpoint = iBreakpointArray[n2];
            this.breakpointAdded(iBreakpoint);
            ++n2;
        }
        try {
            this.stepOver();
        }
        catch (DebugException e) {
            ViatraQueryLoggingUtil.getDefaultLogger().error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resume() throws DebugException {
        this.stepping = false;
        this.suspended = false;
        this.startConnecting();
        this.agent.sendContinueMessage();
        this.endConnecting();
        this.fireResumeEvent(32);
    }

    public void suspend() throws DebugException {
        throw new UnsupportedOperationException("Suspend is not supported");
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return this.stepping;
    }

    public void stepInto() throws DebugException {
        throw new UnsupportedOperationException("Step into operation is not supported");
    }

    public void stepOver() throws DebugException {
        this.stepping = true;
        this.startConnecting();
        this.agent.sendStepMessage();
        this.endConnecting();
        this.fireResumeEvent(2);
    }

    public void stepReturn() throws DebugException {
        throw new UnsupportedOperationException("Step return operation is not supported");
    }

    public boolean canTerminate() {
        return !this.terminated;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() throws DebugException {
        this.startConnecting();
        this.agent.sendDisconnectMessage();
        this.endConnecting();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return this.frames;
    }

    public TransformationModelProvider getModelProvider() {
        return this.modelProvider;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.getStackFrames().length > 0;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] stackFrames = this.getStackFrames();
        if (stackFrames.length > 0) {
            return stackFrames[this.frames.length - 1];
        }
        throw new DebugException((IStatus)new Status(4, "org.eclipse.viatra.transformation.debug", "No transformation rules detected"));
    }

    public String getName() throws DebugException {
        return this.connecting ? String.valueOf(this.name) + CONNECTING_DECORATOR_STRING : this.name;
    }

    public IBreakpoint[] getBreakpoints() {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.viatra.transformation.debug.model");
    }

    public void terminated(IDebuggerHostAgent agent) {
        this.terminated = true;
        this.stepping = false;
        this.suspended = false;
        this.frames = new IStackFrame[0];
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        TransformationThreadFactory.getInstance().deleteTransformationThread(this);
        ((TransformationDebugTarget)this.getDebugTarget()).requestTermination();
        this.fireTerminateEvent();
    }

    public IType getTransformationType() {
        return this.transformationClass;
    }

    protected void setStepping(boolean stepping) {
        this.stepping = stepping;
    }

    public void setNextActivation(RuleActivation act) {
        this.startConnecting();
        this.agent.sendNextActivationMessage(act.getTrace());
        this.endConnecting();
    }

    private void endConnecting() {
        this.connecting = false;
    }

    private void startConnecting() {
        this.connecting = true;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (breakpoint instanceof ITransformationBreakpoint) {
            this.startConnecting();
            this.agent.sendAddBreakpointMessage(((ITransformationBreakpoint)breakpoint).getHandler());
            this.endConnecting();
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof ITransformationBreakpoint) {
            this.startConnecting();
            this.agent.sendRemoveBreakpointMessage(((ITransformationBreakpoint)breakpoint).getHandler());
            this.endConnecting();
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof ITransformationBreakpoint) {
            try {
                this.startConnecting();
                if (breakpoint.isEnabled()) {
                    this.agent.sendEnableBreakpointMessage(((ITransformationBreakpoint)breakpoint).getHandler());
                } else {
                    this.agent.sendDisableBreakpointMessage(((ITransformationBreakpoint)breakpoint).getHandler());
                }
                this.endConnecting();
            }
            catch (CoreException e1) {
                ViatraQueryLoggingUtil.getDefaultLogger().error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    public void transformationStateChanged(TransformationState state) {
        ArrayList<TransformationStackFrame> stackFrames = new ArrayList<TransformationStackFrame>();
        if (state != null) {
            ArrayDeque activationStack = new ArrayDeque();
            activationStack.addAll(state.getActivationStack());
            while (!activationStack.isEmpty()) {
                try {
                    stackFrames.add(new TransformationStackFrame(this, (RuleActivation)activationStack.pop(), this.modelProvider));
                }
                catch (EmptyStackException e) {
                    ViatraQueryLoggingUtil.getDefaultLogger().error((Object)e.getMessage());
                }
            }
        }
        this.frames = stackFrames.toArray(new TransformationStackFrame[stackFrames.size()]);
        this.suspended = true;
        this.fireSuspendEvent(16);
        this.state = state;
        this.name = state == null ? "" : state.getID();
    }

    public TransformationState getTransformationState() {
        return this.state;
    }

    public IDebuggerHostAgent getHostAgent() {
        return this.agent;
    }
}

