/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.dialogfields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;

public class ComboDialogField
extends DialogField {
    private String fText = "";
    private int fVisibleItemCount;
    private int fSelectionIndex;
    private List<String> fItems = new ArrayList<String>();
    private Combo fComboControl;
    private ModifyListener fModifyListener;
    private final int fFlags;

    public ComboDialogField(int flags) {
        this.fFlags = flags;
        this.fSelectionIndex = -1;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)ComboDialogField.gridDataForLabel(1));
        Combo combo = this.getComboControl(parent);
        combo.setLayoutData((Object)ComboDialogField.gridDataForCombo(nColumns - 1));
        return new Control[]{label, combo};
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    protected static GridData gridDataForCombo(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setFocus();
        }
        return true;
    }

    public Combo getComboControl(Composite parent) {
        if (this.fComboControl == null) {
            this.assertCompositeNotNull(parent);
            this.fModifyListener = e -> this.doModifyText(e);
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ComboDialogField.this.doSelectionChanged(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            this.fComboControl = new Combo(parent, this.fFlags);
            this.doSetItems();
            if (this.fSelectionIndex != -1) {
                this.fComboControl.select(this.fSelectionIndex);
            } else {
                this.fComboControl.setText(this.fText);
            }
            if (this.fVisibleItemCount != 0) {
                this.fComboControl.setVisibleItemCount(this.fVisibleItemCount);
            }
            this.fComboControl.setFont(parent.getFont());
            this.fComboControl.addModifyListener(this.fModifyListener);
            this.fComboControl.addSelectionListener(selectionListener);
            this.fComboControl.setEnabled(this.isEnabled());
        }
        return this.fComboControl;
    }

    private void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fText = this.fComboControl.getText();
            this.fSelectionIndex = this.fComboControl.getSelectionIndex();
        }
        this.dialogFieldChanged();
    }

    private void doSelectionChanged(SelectionEvent e) {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fItems = new ArrayList<String>();
            CollectionUtils.addAll(this.fItems, (Object[])this.fComboControl.getItems());
            this.fText = this.fComboControl.getText();
            this.fSelectionIndex = this.fComboControl.getSelectionIndex();
        }
        this.dialogFieldChanged();
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setEnabled(this.isEnabled());
        }
    }

    public int getItemCount() {
        return this.fItems.size();
    }

    public List<String> getListItems() {
        return this.fItems;
    }

    public String[] getItems() {
        return this.fItems.toArray(new String[this.fItems.size()]);
    }

    public void addItem(String newItem) {
        this.fItems.add(newItem);
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.add(newItem);
        }
        this.dialogFieldChanged();
    }

    public void removeItem(String newItem) {
        boolean remove = this.fItems.remove(newItem);
        if (remove && this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.remove(newItem);
        }
    }

    public void addItems(Collection<String> newItems) {
        for (String item : newItems) {
            this.addItem(item);
        }
    }

    private void doSetItems() {
        this.fComboControl.removeAll();
        for (String item : this.fItems) {
            this.fComboControl.add(item);
        }
    }

    public void setItems(String[] items) {
        this.fItems = new ArrayList<String>();
        CollectionUtils.addAll(this.fItems, (Object[])items);
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.doSetItems();
            this.fComboControl.setItems(items);
        }
        this.dialogFieldChanged();
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setVisibleItemCount(int visibleItemCount) {
        this.fVisibleItemCount = visibleItemCount;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setVisibleItemCount(this.fVisibleItemCount);
        } else {
            this.dialogFieldChanged();
        }
    }

    public boolean selectItem(int index) {
        boolean success = false;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.select(index);
            this.fText = this.fComboControl.getText();
            this.fSelectionIndex = this.fComboControl.getSelectionIndex();
            success = this.fSelectionIndex == index;
        } else if (index >= 0 && index < this.fItems.size()) {
            this.fText = this.fItems.get(index);
            this.fSelectionIndex = index;
            success = true;
        }
        if (success) {
            this.dialogFieldChanged();
        }
        return success;
    }

    public boolean selectItem(String name) {
        int i = 0;
        while (i < this.fItems.size()) {
            if (name.equals(this.fItems.get(i))) {
                return this.selectItem(i);
            }
            ++i;
        }
        return false;
    }

    public int getSelectionIndex() {
        return this.fSelectionIndex;
    }

    public void setTextWithoutUpdate(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.removeModifyListener(this.fModifyListener);
            this.fComboControl.setText(text);
            this.fComboControl.addModifyListener(this.fModifyListener);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.setTextWithoutUpdate(this.fText);
    }
}

