/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.support;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.support.AbstractSupport;
import org.eclipse.wb.internal.swt.support.ControlSupport;
import org.eclipse.wb.internal.swt.support.RectangleSupport;
import org.eclipse.wb.internal.swt.support.ToolkitSupport;

public class ContainerSupport
extends AbstractSupport {
    private static final Map<Image, Object> SWT_TO_TOOLKIT_IMAGES = Maps.newHashMap();

    public static boolean isRTL(Object composite) {
        if (composite == null) {
            return false;
        }
        return ControlSupport.isStyle(composite, 0x4000000);
    }

    public static Class<?> getShellClass() {
        return ContainerSupport.loadClass("org.eclipse.swt.widgets.Shell");
    }

    public static boolean isShell(Object o) {
        return ContainerSupport.getShellClass().isAssignableFrom(o.getClass());
    }

    public static boolean isShell(Class<?> clazz) {
        return ContainerSupport.getShellClass().isAssignableFrom(clazz);
    }

    public static Object createShell() throws Exception {
        return ContainerSupport.getShellClass().newInstance();
    }

    public static void setShellText(Object shell, String text) throws Exception {
        ReflectionUtils.invokeMethod((Object)shell, (String)"setText(java.lang.String)", (Object[])new Object[]{text});
    }

    public static void setFillLayout(Object composite) throws Exception {
        Class<?> layoutClass = ContainerSupport.loadClass("org.eclipse.swt.layout.FillLayout");
        Object layout = layoutClass.newInstance();
        ReflectionUtils.invokeMethod((Object)composite, (String)"setLayout(org.eclipse.swt.widgets.Layout)", (Object[])new Object[]{layout});
    }

    public static void setShellImage(Object shell, Image swtImage) throws Exception {
        Object image = SWT_TO_TOOLKIT_IMAGES.get(swtImage);
        if (image == null) {
            image = ToolkitSupport.createToolkitImage(swtImage);
            SWT_TO_TOOLKIT_IMAGES.put(swtImage, image);
        }
        ReflectionUtils.invokeMethod((Object)shell, (String)"setImage(org.eclipse.swt.graphics.Image)", (Object[])new Object[]{image});
    }

    public static void showShell(Object shell) throws Exception {
        ToolkitSupport.showShell(shell);
    }

    public static void closeShell(Object shell) {
        ReflectionUtils.invokeMethodEx((Object)shell, (String)"close()", (Object[])new Object[0]);
    }

    public static Class<?> getCompositeClass() {
        return ContainerSupport.loadClass("org.eclipse.swt.widgets.Composite");
    }

    public static boolean isCompositeClass(Class<?> clazz) {
        return ReflectionUtils.isSuccessorOf(clazz, (String)"org.eclipse.swt.widgets.Composite");
    }

    public static boolean isComposite(Object o) {
        return ContainerSupport.isCompositeClass(o.getClass());
    }

    public static Object createComposite(Object parent, int style) throws Exception {
        Constructor constructor = ReflectionUtils.getConstructorBySignature(ContainerSupport.getCompositeClass(), (String)"<init>(org.eclipse.swt.widgets.Composite,int)");
        return constructor.newInstance(parent, style);
    }

    public static Object[] getChildren(Object composite) {
        Object[] children = (Object[])ReflectionUtils.invokeMethodEx((Object)composite, (String)"getChildren()", (Object[])new Object[0]);
        return children != null ? children : ArrayUtils.EMPTY_OBJECT_ARRAY;
    }

    public static Class<?> getLayoutClass() {
        return ContainerSupport.loadClass("org.eclipse.swt.widgets.Layout");
    }

    public static Object getLayout(Object composite) throws Exception {
        return ReflectionUtils.invokeMethodEx((Object)composite, (String)"getLayout()", (Object[])new Object[0]);
    }

    public static void setLayout(Object composite, Object layout) throws Exception {
        ReflectionUtils.invokeMethod((Object)composite, (String)"setLayout(org.eclipse.swt.widgets.Layout)", (Object[])new Object[]{layout});
    }

    public static void layout(Object composite) throws Exception {
        ReflectionUtils.invokeMethod((Object)composite, (String)"layout()", (Object[])new Object[0]);
    }

    public static Rectangle computeTrim(Object composite, int x, int y, int width, int height) throws Exception {
        Object rectangle = ReflectionUtils.invokeMethod((Object)composite, (String)"computeTrim(int,int,int,int)", (Object[])new Object[]{x, y, width, height});
        return RectangleSupport.getRectangle(rectangle);
    }

    public static Rectangle getClientArea(final Object composite) {
        return (Rectangle)ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<Rectangle>(){

            public Rectangle runObject() throws Exception {
                Object rectangle = ReflectionUtils.invokeMethod((Object)composite, (String)"getClientArea()", (Object[])new Object[0]);
                return RectangleSupport.getRectangle(rectangle);
            }
        });
    }
}

