/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.ui.search.ExceptionOccurrencesGroupKey;
import org.eclipse.wst.jsdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public class ExceptionOccurrencesFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String IS_EXCEPTION = "isException";
    private AST fAST;
    private Name fSelectedName;
    private ITypeBinding fException;
    private ASTNode fStart;
    private List fResult = new ArrayList();

    @Override
    public String initialize(JavaScriptUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, offset, length));
    }

    public String initialize(JavaScriptUnit root, ASTNode node) {
        IVariableBinding var;
        CatchClause catchClause;
        TryStatement tryStatement;
        this.fAST = root.getAST();
        if (!(node instanceof Name)) {
            return SearchMessages.ExceptionOccurrencesFinder_no_exception;
        }
        this.fSelectedName = ASTNodes.getTopMostName((Name)node);
        ASTNode parent = this.fSelectedName.getParent();
        FunctionDeclaration decl = this.resolveMethodDeclaration(parent);
        if (decl != null && this.methodThrowsException(decl, this.fSelectedName)) {
            this.fException = this.fSelectedName.resolveTypeBinding();
            this.fStart = decl.getBody();
        } else if (parent instanceof Type && (parent = parent.getParent()) instanceof SingleVariableDeclaration && parent.getParent() instanceof CatchClause && (tryStatement = (TryStatement)(catchClause = (CatchClause)parent.getParent()).getParent()) != null && (var = catchClause.getException().resolveBinding()) != null && var.getType() != null) {
            this.fException = var.getType();
            this.fStart = tryStatement.getBody();
        }
        if (this.fException == null || this.fStart == null) {
            return SearchMessages.ExceptionOccurrencesFinder_no_exception;
        }
        return null;
    }

    private FunctionDeclaration resolveMethodDeclaration(ASTNode node) {
        if (node instanceof FunctionDeclaration) {
            return (FunctionDeclaration)node;
        }
        JSdoc doc = (JSdoc)ASTNodes.getParent(node, 29);
        if (doc == null) {
            return null;
        }
        if (doc.getParent() instanceof FunctionDeclaration) {
            return (FunctionDeclaration)doc.getParent();
        }
        return null;
    }

    private boolean methodThrowsException(FunctionDeclaration method, Name exception) {
        ASTMatcher matcher = new ASTMatcher();
        for (Name thrown : method.thrownExceptions()) {
            if (!exception.subtreeMatch(matcher, (Object)thrown)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List perform() {
        this.fStart.accept((ASTVisitor)this);
        if (this.fSelectedName != null) {
            this.fResult.add(this.fSelectedName);
        }
        return this.fResult;
    }

    @Override
    public void collectOccurrenceMatches(IJavaScriptElement element, IDocument document, Collection resultingMatches) {
        HashMap<Integer, ExceptionOccurrencesGroupKey> lineToLineElement = new HashMap<Integer, ExceptionOccurrencesGroupKey>();
        for (ASTNode node : this.fResult) {
            int startPosition = node.getStartPosition();
            int length = node.getLength();
            try {
                boolean isException = node == this.fSelectedName;
                int line = document.getLineOfOffset(startPosition);
                Integer lineInteger = line;
                ExceptionOccurrencesGroupKey groupKey = (ExceptionOccurrencesGroupKey)lineToLineElement.get(lineInteger);
                if (groupKey == null) {
                    IRegion region = document.getLineInformation(line);
                    String lineContents = document.get(region.getOffset(), region.getLength()).trim();
                    groupKey = new ExceptionOccurrencesGroupKey(element, line, lineContents, isException);
                    lineToLineElement.put(lineInteger, groupKey);
                } else if (isException) {
                    groupKey.setException(true);
                }
                Match match = new Match((Object)groupKey, startPosition, length);
                resultingMatches.add(match);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    @Override
    public String getJobLabel() {
        return SearchMessages.ExceptionOccurrencesFinder_searchfor;
    }

    @Override
    public String getElementName() {
        if (this.fSelectedName != null) {
            return ASTNodes.asString((ASTNode)this.fSelectedName);
        }
        return null;
    }

    @Override
    public String getUnformattedPluralLabel() {
        return SearchMessages.ExceptionOccurrencesFinder_label_plural;
    }

    @Override
    public String getUnformattedSingularLabel() {
        return SearchMessages.ExceptionOccurrencesFinder_label_singular;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (this.matches(node.resolveConstructorBinding())) {
            this.fResult.add(node.getType());
        }
        return super.visit(node);
    }

    public boolean visit(ConstructorInvocation node) {
        if (this.matches(node.resolveConstructorBinding())) {
            SimpleName name = this.fAST.newSimpleName("xxxx");
            name.setSourceRange(node.getStartPosition(), 4);
            this.fResult.add(name);
        }
        return super.visit(node);
    }

    public boolean visit(FunctionInvocation node) {
        if (this.matches(node.resolveMethodBinding())) {
            this.fResult.add(node.getName());
        }
        return super.visit(node);
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (this.matches(node.resolveConstructorBinding())) {
            SimpleName name = this.fAST.newSimpleName("xxxxx");
            name.setSourceRange(node.getStartPosition(), 5);
            this.fResult.add(name);
        }
        return super.visit(node);
    }

    public boolean visit(SuperMethodInvocation node) {
        if (this.matches(node.resolveMethodBinding())) {
            this.fResult.add(node.getName());
        }
        return super.visit(node);
    }

    public boolean visit(ThrowStatement node) {
        if (this.matches(node.getExpression().resolveTypeBinding())) {
            SimpleName name = this.fAST.newSimpleName("xxxxx");
            name.setSourceRange(node.getStartPosition(), 5);
            this.fResult.add(name);
        }
        return super.visit(node);
    }

    public boolean visit(TypeDeclarationStatement node) {
        return false;
    }

    private boolean matches(IFunctionBinding binding) {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean matches(ITypeBinding exception) {
        if (exception != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (Bindings.equals((IBinding)this.fException, (IBinding)exception)) {
                return true;
            }
            exception = exception.getSuperclass();
lbl6:
            // 2 sources

            ** while (exception != null)
        }
lbl7:
        // 1 sources

        return false;
    }
}

