/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.internal.impl.ImportImpl;
import org.eclipse.wst.wsdl.ui.internal.actions.AddElementDeclarationAction;
import org.eclipse.wst.wsdl.ui.internal.actions.AddWSISchemaImportAction;
import org.eclipse.wst.wsdl.ui.internal.commands.AddImportCommand;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLImportManager;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.w3c.dom.Element;

public class WSDLSetComponentHelper {
    private Definition definition;
    private IFile currentIFile;

    public WSDLSetComponentHelper(IFile iFile, Definition definition) {
        this.currentIFile = iFile;
        this.definition = definition;
    }

    public void setWSDLComponent(WSDLElement inputElement, String property, ComponentSpecification spec) {
        this.addImportIfNecessary(spec);
        String componentObject = this.getPrefixedComponentName(spec);
        Element wsdlElement = inputElement.getElement();
        wsdlElement.setAttribute(property, componentObject);
        WSDLImportManager.removeUnusedImports(this.definition);
    }

    public void setXSDTypeComponent(Part part, ComponentSpecification spec) {
        if (spec.getName() != null && spec.getQualifier() != null) {
            this.addImportIfNecessary(spec);
        }
        String componentObject = this.getPrefixedComponentName(spec);
        ComponentReferenceUtil.setComponentReference(part, true, componentObject);
        WSDLImportManager.removeUnusedImports(this.definition);
    }

    public void setXSDElementComponent(Part part, ComponentSpecification spec) {
        this.addImportIfNecessary(spec);
        String componentObject = this.getPrefixedComponentName(spec);
        ComponentReferenceUtil.setComponentReference(part, false, componentObject);
        WSDLImportManager.removeUnusedImports(this.definition);
    }

    public String getPrefixedComponentName(ComponentSpecification spec) {
        String name = spec.getName();
        List prefixes = this.getPrefixes(this.definition, spec.getQualifier());
        if (prefixes.size() > 0) {
            name = prefixes.get(0) + ":" + name;
        }
        return name;
    }

    private List getPrefixes(Definition definition, String namespace) {
        ArrayList<String> list = new ArrayList<String>();
        Map map = definition.getNamespaces();
        for (String prefix : map.keySet()) {
            String theNamespace = (String)map.get(prefix);
            if (theNamespace == null || !theNamespace.equals(namespace)) continue;
            list.add(prefix);
        }
        return list;
    }

    private void addImportIfNecessary(ComponentSpecification spec) {
        XSDSchema schema;
        boolean foundMatch = false;
        Path currentFileLocation = new Path(this.currentIFile.getLocation().toString());
        if (spec.getFile() == null || currentFileLocation.equals((Object)spec.getFile().getLocation())) {
            foundMatch = true;
        }
        if (!foundMatch) {
            Iterator importsIt = this.definition.getEImports().iterator();
            while (importsIt.hasNext()) {
                String importLocation = "";
                ImportImpl importImpl = (ImportImpl)importsIt.next();
                importImpl.importDefinitionOrSchema();
                if (importImpl.getESchema() != null) {
                    schema = importImpl.getESchema();
                    importLocation = this.getNormalizedLocation(schema.getSchemaLocation());
                } else {
                    Definition importDefinition = importImpl.getEDefinition();
                    importLocation = this.getNormalizedLocation(importDefinition.getLocation());
                }
                if (!spec.getFile().getLocation().equals((Object)new Path(importLocation))) continue;
                foundMatch = true;
                break;
            }
        }
        if (!foundMatch) {
            ArrayList<XSDSchemaContent> imports = new ArrayList<XSDSchemaContent>();
            if (this.definition.getETypes() != null) {
                for (XSDSchemaExtensibilityElement xSDSchemaExtensibilityElement : this.definition.getETypes().getEExtensibilityElements()) {
                    schema = xSDSchemaExtensibilityElement.getSchema();
                    if (schema.getTargetNamespace() != null && !schema.getTargetNamespace().equals("")) continue;
                    for (XSDSchemaContent content : schema.getContents()) {
                        if (!(content instanceof XSDImport)) continue;
                        imports.add(content);
                    }
                }
            }
            for (XSDImport xSDImport : imports) {
                XSDSchema resolvedSchema = xSDImport.getResolvedSchema();
                String resolvedString = resolvedSchema.getSchemaLocation();
                String importLocation = this.getNormalizedLocation(resolvedString);
                if (!spec.getFile().getLocation().equals((Object)new Path(importLocation))) continue;
                foundMatch = true;
                break;
            }
        }
        if (!foundMatch) {
            boolean wsiStyleImport = this.isXSDSchemaFile(spec);
            if (wsiStyleImport) {
                AddElementDeclarationAction action = new AddElementDeclarationAction(this.definition, spec.getQualifier(), "xsd");
                action.run();
                String string = URIHelper.getRelativeURI((IPath)spec.getFile().getLocation(), (IPath)this.currentIFile.getLocation());
                AddWSISchemaImportAction addImport = new AddWSISchemaImportAction(this.definition, spec.getQualifier(), string);
                addImport.run();
            } else {
                String newSelectedFileLoc = spec.getFile().getLocation().toOSString();
                String string = this.getNormalizedLocation(this.definition.getLocation());
                String relativeLoc = ComponentReferenceUtil.computeRelativeURI(newSelectedFileLoc, string, true);
                String prefix = this.definition.getPrefix("http://schemas.xmlsoap.org/wsdl/");
                String uniquePrefix = this.getUniquePrefix(this.definition, prefix);
                String namespace = spec.getQualifier();
                AddImportCommand command = new AddImportCommand(this.definition, namespace, relativeLoc);
                command.run();
                this.definition.addNamespace(uniquePrefix, namespace);
            }
        }
    }

    private boolean isXSDSchemaFile(ComponentSpecification spec) {
        String extension;
        String fileLocation = spec.getFile().getLocation().toOSString();
        int periodIndex = fileLocation.lastIndexOf(".");
        return periodIndex > 0 && (extension = fileLocation.substring(periodIndex + 1)).equalsIgnoreCase("xsd");
    }

    private String getUniquePrefix(Definition definition, String initPrefix) {
        String uniquePrefix;
        Map map = definition.getNamespaces();
        if (definition.getNamespace(initPrefix) == null) {
            uniquePrefix = initPrefix;
        } else {
            String tempPrefix = initPrefix;
            int i = 1;
            while (map.containsKey(String.valueOf(tempPrefix) + i)) {
                ++i;
            }
            uniquePrefix = String.valueOf(tempPrefix) + i;
        }
        return uniquePrefix;
    }

    private String getNormalizedLocation(String location) {
        try {
            URL url = new URL(location);
            URL resolvedURL = FileLocator.resolve((URL)url);
            location = resolvedURL.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return location;
    }
}

