/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.exampleStructures;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.zest.layouts.LayoutBendPoint;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.constraints.BasicEdgeConstraints;
import org.eclipse.zest.layouts.constraints.LabelLayoutConstraint;
import org.eclipse.zest.layouts.constraints.LayoutConstraint;
import org.eclipse.zest.layouts.dataStructures.BendPoint;

public class SimpleRelationship
implements LayoutRelationship {
    private static int DEFAULT_REL_LINE_WIDTH = 1;
    private static int DEFAULT_REL_LINE_WIDTH_SELECTED = DEFAULT_REL_LINE_WIDTH + 2;
    private static Object DEFAULT_RELATIONSHIP_COLOR;
    private static Object DEFAULT_RELATIONSHIP_HIGHLIGHT_COLOR;
    private int lineWidth = DEFAULT_REL_LINE_WIDTH;
    private Object color = DEFAULT_RELATIONSHIP_COLOR;
    private Map attributes;
    protected LayoutEntity sourceEntity;
    protected LayoutEntity destinationEntity;
    protected boolean bidirectional;
    private double weight;
    private Object internalRelationship;
    private LayoutBendPoint[] bendPoints;
    private String label;

    public SimpleRelationship(LayoutEntity sourceEntity, LayoutEntity destinationEntity, boolean bidirectional) {
        this(sourceEntity, destinationEntity, bidirectional, 1.0);
    }

    public SimpleRelationship(LayoutEntity sourceEntity, LayoutEntity destinationEntity, boolean bidirectional, double weight) {
        this.destinationEntity = destinationEntity;
        this.sourceEntity = sourceEntity;
        this.bidirectional = bidirectional;
        this.weight = weight;
        this.attributes = new HashMap();
        this.lineWidth = DEFAULT_REL_LINE_WIDTH;
        this.color = DEFAULT_RELATIONSHIP_COLOR;
    }

    public LayoutEntity getSourceInLayout() {
        return this.sourceEntity;
    }

    public LayoutEntity getDestinationInLayout() {
        return this.destinationEntity;
    }

    public boolean isBidirectionalInLayout() {
        return this.bidirectional;
    }

    public void setWeightInLayout(double weight) {
        this.weight = weight;
    }

    public double getWeightInLayout() {
        return this.weight;
    }

    public void setAttributeInLayout(String attribute, Object value) {
        this.attributes.put(attribute, value);
    }

    public Object getAttributeInLayout(String attribute) {
        return this.attributes.get(attribute);
    }

    public String toString() {
        String arrow = this.isBidirectionalInLayout() ? " <-> " : " -> ";
        return "(" + this.sourceEntity + arrow + this.destinationEntity + ")";
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void resetLineWidth() {
        this.lineWidth = DEFAULT_REL_LINE_WIDTH;
    }

    public static void setDefaultSize(int i) {
        DEFAULT_REL_LINE_WIDTH = i;
        DEFAULT_REL_LINE_WIDTH_SELECTED = DEFAULT_REL_LINE_WIDTH + 2;
    }

    public void setSelected() {
        this.color = DEFAULT_RELATIONSHIP_HIGHLIGHT_COLOR;
        this.lineWidth = DEFAULT_REL_LINE_WIDTH_SELECTED;
    }

    public void setUnSelected() {
        this.color = DEFAULT_RELATIONSHIP_COLOR;
        this.lineWidth = DEFAULT_REL_LINE_WIDTH;
    }

    public Object getColor() {
        return this.color;
    }

    public void setColor(Object c) {
        this.color = c;
    }

    public static void setDefaultColor(Object c) {
        DEFAULT_RELATIONSHIP_COLOR = c;
    }

    public static void setDefaultHighlightColor(Object c) {
        DEFAULT_RELATIONSHIP_HIGHLIGHT_COLOR = c;
    }

    public Object getLayoutInformation() {
        return this.internalRelationship;
    }

    public void setLayoutInformation(Object layoutInformation) {
        this.internalRelationship = layoutInformation;
    }

    public void setBendPoints(LayoutBendPoint[] bendPoints) {
        this.bendPoints = bendPoints;
    }

    public LayoutBendPoint[] getBendPoints() {
        return this.bendPoints;
    }

    public void clearBendPoints() {
        this.bendPoints = new BendPoint[0];
    }

    public void setDestinationInLayout(LayoutEntity destination) {
        this.destinationEntity = destination;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void populateLayoutConstraint(LayoutConstraint constraint) {
        if (constraint instanceof LabelLayoutConstraint) {
            LabelLayoutConstraint labelConstraint = (LabelLayoutConstraint)constraint;
            labelConstraint.label = this.label;
            labelConstraint.pointSize = 18;
        } else {
            boolean cfr_ignored_0 = constraint instanceof BasicEdgeConstraints;
        }
    }

    public Object getGraphData() {
        return null;
    }

    public void setGraphData(Object o) {
    }
}

