/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;

final class DollarVariable
extends TemplateElement {
    private final Expression expression;
    private final Expression escapedExpression;

    DollarVariable(Expression expression, Expression escapedExpression) {
        this.expression = expression;
        this.escapedExpression = escapedExpression;
    }

    void accept(Environment env) throws TemplateException, IOException {
        env.getOut().write(this.escapedExpression.evalAndCoerceToString(env));
    }

    protected String dump(boolean canonical) {
        StringBuffer sb = new StringBuffer();
        sb.append("${");
        sb.append(this.expression.getCanonicalForm());
        sb.append("}");
        if (!canonical && this.expression != this.escapedExpression) {
            sb.append(" auto-escaped");
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return "${...}";
    }

    boolean heedsOpeningWhitespace() {
        return true;
    }

    boolean heedsTrailingWhitespace() {
        return true;
    }

    int getParameterCount() {
        return 1;
    }

    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.expression;
    }

    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.CONTENT;
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

